/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.debug.debugmodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.eclipse.lsp4e.debug.debugmodel.TraceInputStream;
import org.eclipse.lsp4e.debug.debugmodel.TraceOutputStream;
import org.eclipse.lsp4e.internal.NullSafetyHelper;

public abstract class TransportStreams {
    public InputStream in = (InputStream)NullSafetyHelper.lateNonNull();
    public OutputStream out = (OutputStream)NullSafetyHelper.lateNonNull();

    public void close() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public TransportStreams withTrace() {
        return new DefaultTransportStreams(new TraceInputStream(this.in, System.out), new TraceOutputStream(this.out, System.out)){

            @Override
            public void close() {
                TransportStreams.this.close();
            }
        };
    }

    public static class DefaultTransportStreams
    extends TransportStreams {
        public DefaultTransportStreams(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }
    }

    public static class SocketTransportStreams
    extends TransportStreams {
        private final Socket socket;

        public SocketTransportStreams(String host, int port) {
            try {
                this.socket = new Socket(host, port);
                this.in = this.socket.getInputStream();
                this.out = this.socket.getOutputStream();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public void close() {
            super.close();
            try {
                this.socket.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

