/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j;

import java.util.LinkedHashMap;
import org.eclipse.lsp4j.jsonrpc.ProtocolSince;
import org.eclipse.lsp4j.jsonrpc.messages.Either3;

public class FormattingOptions
extends LinkedHashMap<String, Either3<String, Number, Boolean>> {
    private static final String TAB_SIZE = "tabSize";
    private static final String INSERT_SPACES = "insertSpaces";
    private static final String TRIM_TRAILING_WHITESPACE = "trimTrailingWhitespace";
    private static final String INSERT_FINAL_NEWLINE = "insertFinalNewline";
    private static final String TRIM_FINAL_NEWLINES = "trimFinalNewlines";

    public FormattingOptions() {
    }

    public FormattingOptions(int tabSize, boolean insertSpaces) {
        this.setTabSize(tabSize);
        this.setInsertSpaces(insertSpaces);
    }

    public String getString(String key) {
        Either3 _get = (Either3)this.get(key);
        String _first = null;
        if (_get != null) {
            _first = (String)_get.getFirst();
        }
        return _first;
    }

    public void putString(String key, String value) {
        this.put(key, Either3.forFirst((Object)value));
    }

    public Number getNumber(String key) {
        Either3 _get = (Either3)this.get(key);
        Number _second = null;
        if (_get != null) {
            _second = (Number)_get.getSecond();
        }
        return _second;
    }

    public void putNumber(String key, Number value) {
        this.put(key, Either3.forSecond((Object)value));
    }

    public Boolean getBoolean(String key) {
        Either3 _get = (Either3)this.get(key);
        Boolean _third = null;
        if (_get != null) {
            _third = (Boolean)_get.getThird();
        }
        return _third;
    }

    public void putBoolean(String key, Boolean value) {
        this.put(key, Either3.forThird((Object)value));
    }

    public int getTabSize() {
        Number value = this.getNumber(TAB_SIZE);
        if (value != null) {
            return value.intValue();
        }
        return 0;
    }

    public void setTabSize(int tabSize) {
        this.putNumber(TAB_SIZE, tabSize);
    }

    public boolean isInsertSpaces() {
        Boolean value = this.getBoolean(INSERT_SPACES);
        if (value != null) {
            return value;
        }
        return false;
    }

    public void setInsertSpaces(boolean insertSpaces) {
        this.putBoolean(INSERT_SPACES, insertSpaces);
    }

    @ProtocolSince(value="3.15.0")
    public boolean isTrimTrailingWhitespace() {
        Boolean value = this.getBoolean(TRIM_TRAILING_WHITESPACE);
        if (value != null) {
            return value;
        }
        return false;
    }

    public void setTrimTrailingWhitespace(boolean trimTrailingWhitespace) {
        this.putBoolean(TRIM_TRAILING_WHITESPACE, trimTrailingWhitespace);
    }

    @ProtocolSince(value="3.15.0")
    public boolean isInsertFinalNewline() {
        Boolean value = this.getBoolean(INSERT_FINAL_NEWLINE);
        if (value != null) {
            return value;
        }
        return false;
    }

    public void setInsertFinalNewline(boolean insertFinalNewline) {
        this.putBoolean(INSERT_FINAL_NEWLINE, insertFinalNewline);
    }

    @ProtocolSince(value="3.15.0")
    public boolean isTrimFinalNewlines() {
        Boolean value = this.getBoolean(TRIM_FINAL_NEWLINES);
        if (value != null) {
            return value;
        }
        return false;
    }

    public void setTrimFinalNewlines(boolean trimFinalNewlines) {
        this.putBoolean(TRIM_FINAL_NEWLINES, trimFinalNewlines);
    }
}

