/**
 * Copyright (c) 2017, 2020 Kichwa Coders Ltd. and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */
package org.eclipse.lsp4j.debug;

import org.eclipse.lsp4j.jsonrpc.ProtocolSince;
import org.eclipse.lsp4j.jsonrpc.util.ToStringBuilder;

/**
 * Arguments for 'reverseContinue' request.
 */
@SuppressWarnings("all")
public class ReverseContinueArguments {
  /**
   * Specifies the active thread. If the debug adapter supports single thread
   * execution (see {@link Capabilities#getSupportsSingleThreadExecutionRequests})
   * and the 'singleThread' argument is true, only the thread with this ID is resumed.
   */
  private int threadId;

  /**
   * If this flag is true, backward execution is resumed only for the
   * thread with given 'threadId'.
   * <p>
   * This is an optional property.
   */
  @ProtocolSince("1.51")
  private Boolean singleThread;

  /**
   * Specifies the active thread. If the debug adapter supports single thread
   * execution (see {@link Capabilities#getSupportsSingleThreadExecutionRequests})
   * and the 'singleThread' argument is true, only the thread with this ID is resumed.
   */
  public int getThreadId() {
    return this.threadId;
  }

  /**
   * Specifies the active thread. If the debug adapter supports single thread
   * execution (see {@link Capabilities#getSupportsSingleThreadExecutionRequests})
   * and the 'singleThread' argument is true, only the thread with this ID is resumed.
   */
  public void setThreadId(final int threadId) {
    this.threadId = threadId;
  }

  /**
   * If this flag is true, backward execution is resumed only for the
   * thread with given 'threadId'.
   * <p>
   * This is an optional property.
   */
  @ProtocolSince("1.51")
  public Boolean getSingleThread() {
    return this.singleThread;
  }

  /**
   * If this flag is true, backward execution is resumed only for the
   * thread with given 'threadId'.
   * <p>
   * This is an optional property.
   */
  @ProtocolSince("1.51")
  public void setSingleThread(final Boolean singleThread) {
    this.singleThread = singleThread;
  }

  @Override
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("threadId", this.threadId);
    b.add("singleThread", this.singleThread);
    return b.toString();
  }

  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    ReverseContinueArguments other = (ReverseContinueArguments) obj;
    if (other.threadId != this.threadId)
      return false;
    if (this.singleThread == null) {
      if (other.singleThread != null)
        return false;
    } else if (!this.singleThread.equals(other.singleThread))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + this.threadId;
    return prime * result + ((this.singleThread== null) ? 0 : this.singleThread.hashCode());
  }
}
