/**
 * Copyright (c) 2016-2018 TypeFox and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */
package org.eclipse.lsp4j;

import com.google.gson.annotations.JsonAdapter;
import java.util.List;
import org.eclipse.lsp4j.adapters.SymbolInformationTypeAdapter;
import org.eclipse.lsp4j.jsonrpc.ProtocolDeprecated;
import org.eclipse.lsp4j.jsonrpc.ProtocolSince;
import org.eclipse.lsp4j.jsonrpc.util.Preconditions;
import org.eclipse.lsp4j.jsonrpc.util.ToStringBuilder;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;

/**
 * Represents information about programming constructs like variables, classes, interfaces etc.
 * <p>
 * Deprecated in LSP: Use {@link DocumentSymbol} or {@link WorkspaceSymbol} instead if supported.
 */
@JsonAdapter(SymbolInformationTypeAdapter.Factory.class)
@ProtocolDeprecated
@SuppressWarnings("all")
public class SymbolInformation {
  /**
   * The name of this symbol.
   */
  @NonNull
  @ProtocolDeprecated
  private String name;

  /**
   * The kind of this symbol.
   */
  @NonNull
  @ProtocolDeprecated
  private SymbolKind kind;

  /**
   * Tags for this symbol.
   */
  @ProtocolSince("3.16.0")
  @ProtocolDeprecated
  private List<SymbolTag> tags;

  /**
   * Indicates if this symbol is deprecated.
   * <p>
   * Deprecated in LSP:  Use {@link #tags} instead if supported.
   */
  @ProtocolSince("3.8.0")
  @ProtocolDeprecated
  private Boolean deprecated;

  /**
   * The location of this symbol. The location's range is used by a tool
   * to reveal the location in the editor. If the symbol is selected in the
   * tool the range's start information is used to position the cursor. So
   * the range usually spans more then the actual symbol's name and does
   * normally include things like visibility modifiers.
   * <p>
   * The range doesn't have to denote a node range in the sense of a abstract
   * syntax tree. It can therefore not be used to re-construct a hierarchy of
   * the symbols.
   */
  @NonNull
  @ProtocolDeprecated
  private Location location;

  /**
   * The name of the symbol containing this symbol. This information is for
   * user interface purposes (e.g. to render a qualifier in the user interface
   * if necessary). It can't be used to re-infer a hierarchy for the document
   * symbols.
   */
  @ProtocolDeprecated
  private String containerName;

  @ProtocolDeprecated
  public SymbolInformation() {
  }

  @ProtocolDeprecated
  public SymbolInformation(@NonNull final String name, @NonNull final SymbolKind kind, @NonNull final Location location) {
    this.name = Preconditions.<String>checkNotNull(name, "name");
    this.kind = Preconditions.<SymbolKind>checkNotNull(kind, "kind");
    this.location = Preconditions.<Location>checkNotNull(location, "location");
  }

  @ProtocolDeprecated
  public SymbolInformation(@NonNull final String name, @NonNull final SymbolKind kind, @NonNull final Location location, final String containerName) {
    this(name, kind, location);
    this.containerName = containerName;
  }

  /**
   * The name of this symbol.
   */
  @ProtocolDeprecated
  @NonNull
  public String getName() {
    return this.name;
  }

  /**
   * The name of this symbol.
   */
  @ProtocolDeprecated
  public void setName(@NonNull final String name) {
    this.name = Preconditions.checkNotNull(name, "name");
  }

  /**
   * The kind of this symbol.
   */
  @ProtocolDeprecated
  @NonNull
  public SymbolKind getKind() {
    return this.kind;
  }

  /**
   * The kind of this symbol.
   */
  @ProtocolDeprecated
  public void setKind(@NonNull final SymbolKind kind) {
    this.kind = Preconditions.checkNotNull(kind, "kind");
  }

  /**
   * Tags for this symbol.
   */
  @ProtocolSince("3.16.0")
  @ProtocolDeprecated
  public List<SymbolTag> getTags() {
    return this.tags;
  }

  /**
   * Tags for this symbol.
   */
  @ProtocolSince("3.16.0")
  @ProtocolDeprecated
  public void setTags(final List<SymbolTag> tags) {
    this.tags = tags;
  }

  /**
   * Indicates if this symbol is deprecated.
   * <p>
   * Deprecated in LSP:  Use {@link #tags} instead if supported.
   */
  @ProtocolSince("3.8.0")
  @ProtocolDeprecated
  public Boolean getDeprecated() {
    return this.deprecated;
  }

  /**
   * Indicates if this symbol is deprecated.
   * <p>
   * Deprecated in LSP:  Use {@link #tags} instead if supported.
   */
  @ProtocolSince("3.8.0")
  @ProtocolDeprecated
  public void setDeprecated(final Boolean deprecated) {
    this.deprecated = deprecated;
  }

  /**
   * The location of this symbol. The location's range is used by a tool
   * to reveal the location in the editor. If the symbol is selected in the
   * tool the range's start information is used to position the cursor. So
   * the range usually spans more then the actual symbol's name and does
   * normally include things like visibility modifiers.
   * <p>
   * The range doesn't have to denote a node range in the sense of a abstract
   * syntax tree. It can therefore not be used to re-construct a hierarchy of
   * the symbols.
   */
  @ProtocolDeprecated
  @NonNull
  public Location getLocation() {
    return this.location;
  }

  /**
   * The location of this symbol. The location's range is used by a tool
   * to reveal the location in the editor. If the symbol is selected in the
   * tool the range's start information is used to position the cursor. So
   * the range usually spans more then the actual symbol's name and does
   * normally include things like visibility modifiers.
   * <p>
   * The range doesn't have to denote a node range in the sense of a abstract
   * syntax tree. It can therefore not be used to re-construct a hierarchy of
   * the symbols.
   */
  @ProtocolDeprecated
  public void setLocation(@NonNull final Location location) {
    this.location = Preconditions.checkNotNull(location, "location");
  }

  /**
   * The name of the symbol containing this symbol. This information is for
   * user interface purposes (e.g. to render a qualifier in the user interface
   * if necessary). It can't be used to re-infer a hierarchy for the document
   * symbols.
   */
  @ProtocolDeprecated
  public String getContainerName() {
    return this.containerName;
  }

  /**
   * The name of the symbol containing this symbol. This information is for
   * user interface purposes (e.g. to render a qualifier in the user interface
   * if necessary). It can't be used to re-infer a hierarchy for the document
   * symbols.
   */
  @ProtocolDeprecated
  public void setContainerName(final String containerName) {
    this.containerName = containerName;
  }

  @Override
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("name", this.name);
    b.add("kind", this.kind);
    b.add("tags", this.tags);
    b.add("deprecated", this.deprecated);
    b.add("location", this.location);
    b.add("containerName", this.containerName);
    return b.toString();
  }

  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    SymbolInformation other = (SymbolInformation) obj;
    if (this.name == null) {
      if (other.name != null)
        return false;
    } else if (!this.name.equals(other.name))
      return false;
    if (this.kind == null) {
      if (other.kind != null)
        return false;
    } else if (!this.kind.equals(other.kind))
      return false;
    if (this.tags == null) {
      if (other.tags != null)
        return false;
    } else if (!this.tags.equals(other.tags))
      return false;
    if (this.deprecated == null) {
      if (other.deprecated != null)
        return false;
    } else if (!this.deprecated.equals(other.deprecated))
      return false;
    if (this.location == null) {
      if (other.location != null)
        return false;
    } else if (!this.location.equals(other.location))
      return false;
    if (this.containerName == null) {
      if (other.containerName != null)
        return false;
    } else if (!this.containerName.equals(other.containerName))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.name== null) ? 0 : this.name.hashCode());
    result = prime * result + ((this.kind== null) ? 0 : this.kind.hashCode());
    result = prime * result + ((this.tags== null) ? 0 : this.tags.hashCode());
    result = prime * result + ((this.deprecated== null) ? 0 : this.deprecated.hashCode());
    result = prime * result + ((this.location== null) ? 0 : this.location.hashCode());
    return prime * result + ((this.containerName== null) ? 0 : this.containerName.hashCode());
  }
}
