/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.earmodules;

import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.eclipse.m2e.wtp.earmodules.ArtifactTypeMappingService;
import org.eclipse.m2e.wtp.earmodules.EarPluginException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactRepository {
    private final Set<Artifact> artifacts;
    private final String mainArtifactId;
    private final ArtifactTypeMappingService artifactTypeMappingService;

    public ArtifactRepository(Set<Artifact> artifacts, String mainArtifactId, ArtifactTypeMappingService artifactTypeMappingService) {
        this.artifacts = artifacts;
        this.mainArtifactId = mainArtifactId;
        this.artifactTypeMappingService = artifactTypeMappingService;
    }

    public Artifact getUniqueArtifact(String groupId, String artifactId, String type, String classifier) {
        Set<Artifact> candidates = this.getArtifacts(groupId, artifactId, type);
        if (candidates.isEmpty()) {
            return null;
        }
        if (candidates.size() == 1 && classifier == null) {
            return candidates.iterator().next();
        }
        if (classifier != null) {
            for (Artifact a : this.artifacts) {
                if (a.getClassifier() == null && classifier.equals(this.mainArtifactId)) {
                    return a;
                }
                if (!classifier.equals(a.getClassifier())) continue;
                return a;
            }
        }
        return null;
    }

    public Artifact getUniqueArtifact(String groupId, String artifactId, String type) {
        return this.getUniqueArtifact(groupId, artifactId, type, null);
    }

    public Set<Artifact> getArtifacts(String groupId, String artifactId, String type) {
        TreeSet<Artifact> result = new TreeSet<Artifact>();
        for (Artifact a : this.artifacts) {
            if (!a.getGroupId().equals(groupId) || !a.getArtifactId().equals(artifactId) || !this.artifactTypeMappingService.isMappedToType(type, a.getType())) continue;
            result.add(a);
        }
        return result;
    }

    public Artifact resolveArtifact(String groupId, String artifactId, String type, String classifier) throws EarPluginException {
        if (groupId == null || artifactId == null) {
            throw new IllegalArgumentException("Could not resolve artifact[" + type + ":" + groupId + ":" + artifactId + "]");
        }
        Artifact artifact = this.getUniqueArtifact(groupId, artifactId, type, classifier);
        if (artifact == null) {
            Set<Artifact> candidates = this.getArtifacts(groupId, artifactId, type);
            if (candidates.size() > 1) {
                throw new EarPluginException("Artifact[" + type + ":" + groupId + ":" + artifactId + "] has " + candidates.size() + " candidates, please provide a classifier.");
            }
            throw new EarPluginException("Artifact[" + type + ":" + groupId + ":" + artifactId + "] is not a dependency of the project.");
        }
        return artifact;
    }
}

