/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.overlay.internal.modulecore;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.eclipse.m2e.wtp.overlay.internal.modulecore.IResourceFilter;
import org.eclipse.m2e.wtp.overlay.internal.utilities.PathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicResourceFilter
implements IResourceFilter {
    protected static final String[] DEFAULTEXCLUDES = new String[]{"**/*~", "**/#*#", "**/.#*", "**/%*%", "**/._*", "**/CVS", "**/CVS/**", "**/.cvsignore", "**/SCCS", "**/SCCS/**", "**/vssver.scc", "**/.svn", "**/.svn/**", "**/.DS_Store"};
    protected String[] includes;
    protected String[] excludes;
    protected boolean isCaseSensitive = true;
    private String[] includePatterns;
    private String[] excludePatterns;
    private boolean areNonPatternSetsReady = false;
    private Set<String> includeNonPatterns = new HashSet<String>();
    private Set<String> excludeNonPatterns = new HashSet<String>();

    public DynamicResourceFilter(Collection<String> inclusions, Collection<String> exclusions) {
        if (inclusions != null && !inclusions.isEmpty()) {
            this.setIncludes(inclusions.toArray(new String[inclusions.size()]));
        } else {
            this.setIncludes(new String[]{"**/**"});
        }
        if (exclusions != null && !exclusions.isEmpty()) {
            this.addExcludes(exclusions.toArray(new String[exclusions.size()]));
        }
        this.addExcludes(DEFAULTEXCLUDES);
    }

    public synchronized void setIncludes(String[] includes) {
        if (includes == null) {
            this.includes = null;
        } else {
            this.includes = new String[includes.length];
            int i = 0;
            while (i < includes.length) {
                this.includes[i] = DynamicResourceFilter.normalizePattern(includes[i]);
                ++i;
            }
        }
    }

    public synchronized void setExcludes(String[] excludes) {
        if (excludes == null) {
            this.excludes = null;
        } else {
            this.excludes = new String[excludes.length];
            int i = 0;
            while (i < excludes.length) {
                this.excludes[i] = DynamicResourceFilter.normalizePattern(excludes[i]);
                ++i;
            }
        }
    }

    public synchronized void addExcludes(String[] excludes) {
        if (excludes != null && excludes.length > 0) {
            if (this.excludes != null && this.excludes.length > 0) {
                String[] tmp = new String[excludes.length + this.excludes.length];
                System.arraycopy(this.excludes, 0, tmp, 0, this.excludes.length);
                int i = 0;
                while (i < excludes.length) {
                    tmp[this.excludes.length + i] = DynamicResourceFilter.normalizePattern(excludes[i]);
                    ++i;
                }
                this.excludes = tmp;
            } else {
                this.setExcludes(excludes);
            }
        }
    }

    private static String normalizePattern(String p) {
        String pattern = PathUtil.useSystemSeparator(p);
        if (pattern.endsWith(File.separator)) {
            pattern = String.valueOf(pattern) + "**";
        }
        return pattern;
    }

    private synchronized void ensureNonPatternSetsReady() {
        if (!this.areNonPatternSetsReady) {
            this.includePatterns = this.fillNonPatternSet(this.includeNonPatterns, this.includes);
            this.excludePatterns = this.fillNonPatternSet(this.excludeNonPatterns, this.excludes);
            this.areNonPatternSetsReady = true;
        }
    }

    private String[] fillNonPatternSet(Set<String> set, String[] patterns) {
        ArrayList<String> al = new ArrayList<String>(patterns.length);
        int i = 0;
        while (i < patterns.length) {
            if (!SelectorUtils.hasWildcards((String)patterns[i])) {
                set.add(this.isCaseSensitive() ? patterns[i] : patterns[i].toUpperCase());
            } else {
                al.add(patterns[i]);
            }
            ++i;
        }
        return set.size() == 0 ? patterns : al.toArray(new String[al.size()]);
    }

    private boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    protected boolean isExcluded(String name) {
        this.ensureNonPatternSetsReady();
        if (this.isCaseSensitive() ? this.excludeNonPatterns.contains(name) : this.excludeNonPatterns.contains(name.toUpperCase())) {
            return true;
        }
        int i = 0;
        while (i < this.excludePatterns.length) {
            if (DynamicResourceFilter.matchPath(this.excludePatterns[i], name, this.isCaseSensitive())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isIncluded(String name) {
        this.ensureNonPatternSetsReady();
        if (this.isCaseSensitive() ? this.includeNonPatterns.contains(name) : this.includeNonPatterns.contains(name.toUpperCase())) {
            return true;
        }
        int i = 0;
        while (i < this.includePatterns.length) {
            if (DynamicResourceFilter.matchPath(this.includePatterns[i], name, this.isCaseSensitive())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static boolean matchPath(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtils.matchPath((String)pattern, (String)str, (boolean)isCaseSensitive);
    }

    @Override
    public boolean accepts(String path, boolean isFile) {
        if (path == null) {
            return false;
        }
        boolean isIncluded = this.isIncluded(path = PathUtil.useSystemSeparator(path)) && !this.isExcluded(path);
        return isIncluded;
    }
}

