/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp;

import java.util.Collections;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.lifecycle.internal.DependencyContext;
import org.apache.maven.lifecycle.internal.MojoExecutor;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.internal.embedder.MavenImpl;
import org.eclipse.m2e.wtp.internal.Messages;

public class MavenSessionHelper {
    private final MavenProject project;
    private Set<Artifact> artifacts;
    private Set<Artifact> dependencyArtifacts;

    public MavenSessionHelper(MavenProject mavenProject) {
        if (mavenProject == null) {
            throw new IllegalArgumentException(Messages.Error_Maven_Project_Cant_Be_Null);
        }
        this.project = mavenProject;
    }

    public void ensureDependenciesAreResolved(String pluginId, String goal) throws CoreException {
        this.artifacts = this.project.getArtifacts();
        this.dependencyArtifacts = this.project.getDependencyArtifacts();
        NullProgressMonitor monitor = new NullProgressMonitor();
        MavenExecutionPlan executionPlan = MavenPlugin.getMaven().calculateExecutionPlan(this.project, Collections.singletonList(goal), true, (IProgressMonitor)monitor);
        MojoExecution execution = MavenSessionHelper.getExecution(executionPlan, pluginId);
        IMavenExecutionContext context = MavenPlugin.getMaven().createExecutionContext();
        this.ensureDependenciesAreResolved(context.getSession(), execution, (IProgressMonitor)monitor);
    }

    public void ensureDependenciesAreResolved(MavenSession session, MojoExecution execution, IProgressMonitor monitor) throws CoreException {
        this.artifacts = this.project.getArtifacts();
        this.dependencyArtifacts = this.project.getDependencyArtifacts();
        try {
            MojoExecutor mojoExecutor = this.lookup(MojoExecutor.class);
            DependencyContext dependencyContext = mojoExecutor.newDependencyContext(session, Collections.singletonList(execution));
            mojoExecutor.ensureDependenciesAreResolved(execution.getMojoDescriptor(), session, dependencyContext);
        }
        catch (Exception ex) {
            this.dispose();
        }
    }

    public void dispose() {
        this.project.setArtifactFilter(null);
        this.project.setResolvedArtifacts(null);
        this.project.setArtifacts(this.artifacts);
        this.project.setDependencyArtifacts(this.dependencyArtifacts);
    }

    private <T> T lookup(Class<T> clazz) throws CoreException {
        try {
            return (T)((MavenImpl)MavenPlugin.getMaven()).getPlexusContainer().lookup(clazz);
        }
        catch (ComponentLookupException ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.MavenSessionHelper_Error_Component_Lookup, (Throwable)ex));
        }
    }

    public static MojoExecution getExecution(MavenExecutionPlan executionPlan, String artifactId) throws CoreException {
        if (executionPlan == null) {
            return null;
        }
        for (MojoExecution execution : executionPlan.getMojoExecutions()) {
            if (!artifactId.equals(execution.getArtifactId())) continue;
            return execution;
        }
        return null;
    }
}

