/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal.snapshot;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.BitField;
import org.eclipse.mat.collect.QueueInt;
import org.eclipse.mat.parser.index.IIndexReader;
import org.eclipse.mat.parser.internal.Messages;
import org.eclipse.mat.parser.internal.ParserPlugin;
import org.eclipse.mat.parser.internal.util.IntStack;
import org.eclipse.mat.snapshot.ExcludedReferencesDescriptor;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.NamedReference;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

public class ObjectMarker {
    int[] roots;
    boolean[] bits;
    IIndexReader.IOne2ManyIndex outbound;
    long outboundMem;
    IProgressListener progressListener;
    private static final boolean DEBUG = Platform.inDebugMode() && ParserPlugin.getDefault().isDebugging();
    private static final boolean USELOCAL = !Platform.inDebugMode() || !ParserPlugin.getDefault().isDebugging() || !Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.mat.parser/debug/oldMarker"));
    private static final int MIN_LOCALITY = 1000000;

    public ObjectMarker(int[] roots, boolean[] bits, IIndexReader.IOne2ManyIndex outbound, IProgressListener progressListener) {
        this(roots, bits, outbound, 0L, progressListener);
    }

    public ObjectMarker(int[] roots, boolean[] bits, IIndexReader.IOne2ManyIndex outbound, long outboundLength, IProgressListener progressListener) {
        this.roots = roots;
        this.bits = bits;
        this.outbound = outbound;
        this.outboundMem = outboundLength > 0L ? outboundLength : (long)outbound.size() * 30L;
        this.progressListener = progressListener;
    }

    public int markSingleThreaded() throws IProgressListener.OperationCanceledException {
        int count = 0;
        int size = 0;
        int[] data = new int[10240];
        int rootsToProcess = 0;
        int[] nArray = this.roots;
        int n = this.roots.length;
        int n2 = 0;
        while (n2 < n) {
            int rootId = nArray[n2];
            if (!this.bits[rootId]) {
                if (size == data.length) {
                    int[] newArr = new int[data.length << 1];
                    System.arraycopy(data, 0, newArr, 0, data.length);
                    data = newArr;
                }
                data[size++] = rootId;
                this.bits[rootId] = true;
                ++count;
                ++rootsToProcess;
            }
            ++n2;
        }
        this.progressListener.beginTask(Messages.ObjectMarker_MarkingObjects, rootsToProcess);
        while (size > 0) {
            int current = data[--size];
            if (size <= rootsToProcess) {
                --rootsToProcess;
                this.progressListener.worked(1);
                if (this.progressListener.isCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
            }
            int[] nArray2 = this.outbound.get(current);
            int n3 = nArray2.length;
            n = 0;
            while (n < n3) {
                int child = nArray2[n];
                if (!this.bits[child]) {
                    if (size == data.length) {
                        int[] newArr = new int[data.length << 1];
                        System.arraycopy(data, 0, newArr, 0, data.length);
                        data = newArr;
                    }
                    data[size++] = child;
                    this.bits[child] = true;
                    ++count;
                }
                ++n;
            }
        }
        this.progressListener.done();
        return count;
    }

    public int markSingleThreaded(ExcludedReferencesDescriptor[] excludeSets, ISnapshot snapshot) throws SnapshotException, IProgressListener.OperationCanceledException {
        int n;
        int n2;
        int[] nArray;
        BitField excludeObjectsBF = new BitField(snapshot.getSnapshotInfo().getNumberOfObjects());
        ExcludedReferencesDescriptor[] excludedReferencesDescriptorArray = excludeSets;
        int n3 = excludeSets.length;
        int n4 = 0;
        while (n4 < n3) {
            ExcludedReferencesDescriptor set = excludedReferencesDescriptorArray[n4];
            nArray = set.getObjectIds();
            n2 = nArray.length;
            n = 0;
            while (n < n2) {
                int k = nArray[n];
                excludeObjectsBF.set(k);
                ++n;
            }
            ++n4;
        }
        int count = 0;
        int rootsToProcess = 0;
        int size = 0;
        int[] data = new int[10240];
        nArray = this.roots;
        n2 = this.roots.length;
        n = 0;
        while (n < n2) {
            int rootId = nArray[n];
            if (!this.bits[rootId]) {
                if (size == data.length) {
                    int[] newArr = new int[data.length << 1];
                    System.arraycopy(data, 0, newArr, 0, data.length);
                    data = newArr;
                }
                data[size++] = rootId;
                this.bits[rootId] = true;
                ++count;
                ++rootsToProcess;
            }
            ++n;
        }
        this.progressListener.beginTask(Messages.ObjectMarker_MarkingObjects, rootsToProcess);
        ArrayList<NamedReference> refCache = new ArrayList<NamedReference>();
        while (size > 0) {
            int current = data[--size];
            if (size <= rootsToProcess) {
                --rootsToProcess;
                this.progressListener.worked(1);
                if (this.progressListener.isCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
            }
            refCache.clear();
            int[] nArray2 = this.outbound.get(current);
            int n5 = nArray2.length;
            int n6 = 0;
            while (n6 < n5) {
                int child = nArray2[n6];
                if (!this.bits[child] && !this.refersOnlyThroughExcluded(current, child, excludeSets, excludeObjectsBF, refCache, snapshot)) {
                    if (size == data.length) {
                        int[] newArr = new int[data.length << 1];
                        System.arraycopy(data, 0, newArr, 0, data.length);
                        data = newArr;
                    }
                    data[size++] = child;
                    this.bits[child] = true;
                    if (++count % 10000 == 0 && this.progressListener.isCanceled()) {
                        throw new IProgressListener.OperationCanceledException();
                    }
                }
                ++n6;
            }
        }
        this.progressListener.done();
        return count;
    }

    public void markMultiThreaded(int numberOfThreads) throws InterruptedException {
        MultiThreadedRootStack rootsStack = new MultiThreadedRootStack(this.roots.length);
        int[] nArray = this.roots;
        int n = this.roots.length;
        int n2 = 0;
        while (n2 < n) {
            int rootId = nArray[n2];
            if (!this.bits[rootId]) {
                rootsStack.push(rootId);
                this.bits[rootId] = true;
            }
            ++n2;
        }
        long l = System.currentTimeMillis();
        if (DEBUG) {
            System.out.println("Starting threads " + new Date());
        }
        this.progressListener.beginTask(Messages.ObjectMarker_MarkingObjects, rootsStack.size());
        int n3 = this.bits.length;
        Runtime runtime = Runtime.getRuntime();
        long maxFree = runtime.maxMemory() - runtime.totalMemory() + runtime.freeMemory();
        if (maxFree < this.outboundMem) {
            runtime.gc();
            maxFree = runtime.maxMemory() - runtime.totalMemory() + runtime.freeMemory();
        }
        int n1 = (int)Math.min((long)this.bits.length, (long)this.bits.length * maxFree / this.outboundMem);
        int m = (int)((1.0 - Math.pow((double)(n3 - n1) / (double)n3, 1.0 / (double)numberOfThreads)) * (double)n3);
        int locality = Math.min(n3, Math.max(1000000, m));
        if (DEBUG) {
            System.out.println("maxFree=" + maxFree + " outbound mem=" + this.outboundMem + " n=" + n3 + " n1=" + n1 + " m=" + m + " locality=" + locality);
        }
        DfsThread[] dfsthreads = new DfsThread[numberOfThreads];
        Thread[] threads = new Thread[numberOfThreads];
        int i = 0;
        while (i < numberOfThreads) {
            DfsThread dfsthread = USELOCAL ? new LocalDfsThread(rootsStack, locality) : new DfsThread(rootsStack);
            dfsthreads[i] = dfsthread;
            Thread thread = new Thread((Runnable)dfsthread, "ObjectMarkerThread-" + (i + 1));
            thread.start();
            threads[i] = thread;
            ++i;
        }
        int failed = 0;
        Throwable failure = null;
        int i2 = 0;
        while (i2 < numberOfThreads) {
            threads[i2].join();
            if (!dfsthreads[i2].completed) {
                ++failed;
                if (failure == null) {
                    failure = dfsthreads[i2].failure;
                }
            }
            ++i2;
        }
        if (this.progressListener.isCanceled()) {
            return;
        }
        if (failed > 0) {
            throw new RuntimeException(MessageUtil.format((String)Messages.ObjectMarker_ErrorMarkingObjectsSeeLog, (Object[])new Object[]{failed}), failure);
        }
        this.progressListener.done();
        if (DEBUG) {
            System.out.println("Took " + (System.currentTimeMillis() - l) + "ms");
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean refersOnlyThroughExcluded(int referrerId, int referentId, ExcludedReferencesDescriptor[] excludeSets, BitField excludeObjectsBF, List<NamedReference> refCache, ISnapshot snapshot) throws SnapshotException {
        block13: {
            block12: {
                if (!excludeObjectsBF.get(referrerId)) {
                    return false;
                }
                excludeFields = null;
                var11_8 = excludeSets;
                var10_10 = excludeSets.length;
                var9_11 = 0;
                while (var9_11 < var10_10) {
                    set = var11_8[var9_11];
                    if (set.contains(referrerId)) {
                        excludeFields = set.getFields();
                        break;
                    }
                    ++var9_11;
                }
                if (excludeFields == null) {
                    return true;
                }
                referrerObject = snapshot.getObject(referrerId);
                referentAddr = snapshot.mapIdToAddress(referentId);
                minsort = 10;
                if (refCache.isEmpty()) {
                    refs = referrerObject.getOutboundReferences();
                    refCache.addAll(refs);
                    v0 = sorted = refCache.size() >= 10;
                    if (sorted) {
                        refCache.sort(CompObjectReference.INSTANCE);
                    }
                } else {
                    v1 = sorted = refCache.size() >= 10;
                }
                if (!sorted) break block12;
                idx = Collections.binarySearch(refCache, new ObjectReference(snapshot, referentAddr), CompObjectReference.INSTANCE);
                if (idx >= 0) ** GOTO lbl33
                return true;
lbl-1000:
                // 1 sources

                {
                    --idx;
lbl33:
                    // 2 sources

                    ** while (idx > 0 && refCache.get((int)(idx - 1)).getObjectAddress() == referentAddr)
                }
lbl34:
                // 1 sources

                break block13;
            }
            idx = 0;
        }
        i = idx;
        while (i < refCache.size()) {
            reference = refCache.get(i);
            if (referentAddr == reference.getObjectAddress()) {
                if (!excludeFields.contains(reference.getName())) {
                    return false;
                }
            } else if (sorted) break;
            ++i;
        }
        return true;
    }

    private static final class CompObjectReference
    implements Comparator<ObjectReference> {
        static CompObjectReference INSTANCE = new CompObjectReference();

        private CompObjectReference() {
        }

        @Override
        public int compare(ObjectReference o1, ObjectReference o2) {
            return Long.compare(o1.getObjectAddress(), o2.getObjectAddress());
        }
    }

    public class DfsThread
    implements Runnable {
        boolean completed;
        int size = 0;
        int[] data = new int[10240];
        IntStack rootsStack;
        int current = -1;
        Throwable failure;

        public DfsThread(IntStack roots) {
            this.rootsStack = roots;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            try {
                while (true) {
                    var1_1 = this.rootsStack;
                    synchronized (var1_1) {
                        ObjectMarker.this.progressListener.worked(1);
                        if (ObjectMarker.this.progressListener.isCanceled()) {
                            return;
                        }
                        if (this.rootsStack.size() <= 0) {
                            break;
                        }
                        this.data[0] = this.rootsStack.pop();
                        this.size = 1;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 6] lbl15 : MonitorExitStatement: MONITOREXIT : var1_1
                        if (true) ** GOTO lbl33
                    }
                    do {
                        this.current = this.data[--this.size];
                        var4_7 = ObjectMarker.this.outbound.get(this.current);
                        var3_6 = var4_7.length;
                        var2_5 = 0;
                        while (var2_5 < var3_6) {
                            child = var4_7[var2_5];
                            if (!ObjectMarker.this.bits[child]) {
                                ObjectMarker.this.bits[child] = true;
                                if (this.size == this.data.length) {
                                    newArr = new int[this.data.length << 1];
                                    System.arraycopy(this.data, 0, newArr, 0, this.data.length);
                                    this.data = newArr;
                                }
                                this.data[this.size++] = child;
                            }
                            ++var2_5;
                        }
lbl33:
                        // 2 sources

                    } while (this.size > 0);
                }
                this.completed = true;
            }
            catch (RuntimeException e) {
                ObjectMarker.this.progressListener.sendUserMessage(IProgressListener.Severity.ERROR, Messages.ObjectMarker_ErrorMarkingObjects, (Throwable)e);
                this.failure = e;
            }
            catch (Error e) {
                ObjectMarker.this.progressListener.sendUserMessage(IProgressListener.Severity.ERROR, Messages.ObjectMarker_ErrorMarkingObjects, (Throwable)e);
                this.failure = e;
            }
        }
    }

    public class LocalDfsThread
    extends DfsThread {
        private static final int RESERVED = 35;
        static final int MAXSTACK = 102400;
        private static final int CHECKCOUNT = 10;
        private static final int CHECKCOUNT2 = 200;
        int localRange;
        final int localRangeLimit;
        SoftReference<int[]> sr;
        double scaleUp;
        MultiThreadedRootStack rootsStack;
        QueueInt queue;
        int localBase;

        public LocalDfsThread(MultiThreadedRootStack roots) {
            this(roots, 1000000);
        }

        public LocalDfsThread(MultiThreadedRootStack roots, int range) {
            super(roots);
            this.scaleUp = 0.005;
            this.queue = new QueueInt(1024);
            this.rootsStack = roots;
            this.localRange = this.localRangeLimit = range;
        }

        void initLocalStack(int val) {
            this.data[0] = val;
            this.size = 1;
            this.localBase = this.calcBase(this.data[0]);
        }

        void fillStack() {
            int originalQueueSize = this.queue.size();
            int i = 0;
            while (i < originalQueueSize) {
                int z = this.queue.get();
                if (this.inRange(z)) {
                    this.data[this.size++] = z;
                    if (this.size == this.data.length) {
                        break;
                    }
                } else {
                    this.queue.put(z);
                }
                ++i;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            block26: {
                block27: {
                    block32: {
                        block31: {
                            block30: {
                                this.rootsStack.linkThread();
                                try {
                                    check = false;
                                    checkCount = 0;
                                    while (true) {
                                        var5_8 = this.rootsStack;
                                        synchronized (var5_8) {
                                            block29: {
                                                block28: {
                                                    if (this.rootsStack.size() <= 0) break block28;
                                                    d = this.rootsStack.pop();
                                                    break block29;
                                                }
                                                d = this.rootsStack.waitAndPop();
                                                if (d != -1) break block29;
                                                ** GOTO lbl-1000
                                            }
                                            work = this.rootsStack.worked();
                                            if (work > 0) {
                                                ObjectMarker.this.progressListener.worked(work);
                                            }
                                        }
                                        this.queue.put(d);
                                        if (true) ** GOTO lbl42
lbl-1000:
                                        // 1 sources

                                        {
                                            this.completed = true;
                                            return;
                                            do {
                                                if (ObjectMarker.this.progressListener.isCanceled()) {
                                                    return;
                                                }
                                                ** try [egrp 3[TRYBLOCK] [6, 8, 10 : 131->514)] { 
lbl31:
                                                // 1 sources

                                                this.initLocalStack(this.queue.get());
                                                this.fillStack();
                                                if (this.size <= 0) continue;
                                                this.current = this.data[--this.size];
                                                if (check || checkCount++ >= 10) {
                                                    checkCount = 0;
                                                    check = this.fillRootsStack();
                                                }
                                                var8_12 = ObjectMarker.this.outbound.get(this.current);
                                                var7_11 = var8_12.length;
                                                var6_10 = 0;
                                                break block26;
lbl42:
                                                // 2 sources

                                            } while (this.queue.size() > 0);
                                            continue;
                                        }
                                        break;
                                    }
                                }
lbl44:
                                // 2 sources

                                catch (RuntimeException e) {
                                    ObjectMarker.this.progressListener.sendUserMessage(IProgressListener.Severity.ERROR, Messages.ObjectMarker_ErrorMarkingObjects, (Throwable)e);
                                    this.failure = e;
                                    return;
                                }
lbl48:
                                // 2 sources

                                catch (OutOfMemoryError e) {
                                    this.failure = e;
                                    if (this.emptyLocalStacks()) {
                                        ObjectMarker.this.progressListener.sendUserMessage(IProgressListener.Severity.WARNING, Messages.ObjectMarker_WarningMarkingObjects, (Throwable)e);
                                        this.completed = true;
                                        return;
                                    }
                                    ObjectMarker.this.progressListener.sendUserMessage(IProgressListener.Severity.ERROR, Messages.ObjectMarker_ErrorMarkingObjects, (Throwable)e);
                                    return;
                                }
lbl56:
                                // 2 sources

                                catch (Error e) {
                                    ObjectMarker.this.progressListener.sendUserMessage(IProgressListener.Severity.ERROR, Messages.ObjectMarker_ErrorMarkingObjects, (Throwable)e);
                                    this.failure = e;
                                    return;
                                }
                                finally {
                                    this.rootsStack.unlinkThread();
                                }
lbl63:
                                // 1 sources

                                child = var8_12[var6_10];
                                if (ObjectMarker.this.bits[child]) break block27;
                                ObjectMarker.this.bits[child] = true;
                                if (this.queue.size() + this.size <= 35 || !check && checkCount++ < 200) break block30;
                                checkCount = 0;
                                var9_13 = this.rootsStack;
                                synchronized (var9_13) {
                                    check = this.rootsStack.pushIfWaiting(child);
                                }
                                if (!check) break block30;
                                check = this.fillRootsStack();
                                break block27;
                            }
                            if (this.size != 0) break block31;
                            this.initLocalStack(child);
                            this.fillStack();
                            break block27;
                        }
                        if (!this.inRange(child)) break block32;
                        if (this.size < this.data.length) {
                            this.data[this.size++] = child;
                            break block27;
                        } else if (this.size < 102400) {
                            newArr = new int[Math.min(Math.max(0, this.data.length << 1), 102400)];
                            System.arraycopy(this.data, 0, newArr, 0, this.data.length);
                            this.data = newArr;
                            this.data[this.size++] = child;
                            break block27;
                        } else {
                            this.queue.put(child);
                        }
                        break block27;
                    }
                    this.queue.put(child);
                }
                ++var6_10;
            }
            if (var6_10 < var7_11) ** GOTO lbl63
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean fillRootsStack() {
            boolean check = true;
            if (this.queue.size() > 0 && this.queue.size() + this.size > 35) {
                int fromQueue;
                MultiThreadedRootStack multiThreadedRootStack = this.rootsStack;
                synchronized (multiThreadedRootStack) {
                    while ((check = this.rootsStack.pushIfWaiting(fromQueue = this.queue.get())) && this.queue.size() > 0 && this.queue.size() + this.size > 35) {
                    }
                }
                if (!check) {
                    this.queue.put(fromQueue);
                }
            } else if (this.size > 35) {
                MultiThreadedRootStack multiThreadedRootStack = this.rootsStack;
                synchronized (multiThreadedRootStack) {
                    do {
                        int item;
                        if (check = this.rootsStack.pushIfWaiting(item = this.data[--this.size])) continue;
                        this.data[this.size++] = item;
                    } while (check && this.size > 35);
                }
            }
            return check;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean emptyLocalStacks() {
            MultiThreadedRootStack multiThreadedRootStack = this.rootsStack;
            synchronized (multiThreadedRootStack) {
                if (DEBUG) {
                    System.out.println("emptyLocalStacks " + this.rootsStack.totalThreads + " " + this.current + " " + this.size + " " + this.queue.size());
                }
                if (this.rootsStack.totalThreads >= 2) {
                    if (this.current != -1) {
                        this.rootsStack.push(this.current);
                        this.current = -1;
                    }
                    while (this.size > 0) {
                        this.rootsStack.push(this.data[--this.size]);
                    }
                    while (this.queue.size() > 0) {
                        this.rootsStack.push(this.queue.get());
                    }
                }
            }
            if (DEBUG) {
                System.out.println("emptyLocalStacks " + this.current + " " + this.size + " " + this.queue.size());
            }
            return this.current == -1 && this.size == 0 && this.queue.size() == 0;
        }

        private boolean inRange(int val) {
            return val >= this.localBase && val - this.localBase < this.localRange;
        }

        private int calcBase(int v) {
            this.calcRange();
            return Math.max(Math.min(v + (this.localRange * 3 >>> 2), ObjectMarker.this.bits.length) - this.localRange, 0);
        }

        private void calcRange() {
            if (this.sr == null) {
                if (DEBUG) {
                    System.out.println("Set local range=" + this.localRange);
                }
                this.sr = new SoftReference<int[]>(new int[1024]);
            } else if (this.sr.get() != null) {
                if (this.localRange < ObjectMarker.this.bits.length && this.scaleUp > 0.0) {
                    this.localRange = Math.min((int)((double)this.localRange * (1.0 + this.scaleUp)), ObjectMarker.this.bits.length);
                    if (DEBUG) {
                        System.out.println("Increased local range=" + this.localRange + " " + this.scaleUp);
                    }
                }
            } else if (this.localRange != this.localRangeLimit || this.scaleUp != 0.0) {
                this.localRange = Math.max((int)((double)this.localRange * 0.9), this.localRangeLimit);
                this.scaleUp *= 0.5;
                if (this.scaleUp * (double)this.localRange < 1.0) {
                    this.scaleUp = 0.0;
                }
                if (DEBUG) {
                    System.out.println("Decreased local range=" + this.localRange + " " + this.scaleUp);
                }
                this.sr = new SoftReference<int[]>(new int[1024]);
            }
        }
    }

    static class MultiThreadedRootStack
    extends IntStack {
        private int waitingThreads;
        private int totalThreads;
        private int waits;
        private long waitsduration;
        static final int RESERVED_WAITING = 50;
        static final int RESERVED_RUNNING = 15;
        int totalWork;
        int worked;
        int pushed;
        int lastDone;

        MultiThreadedRootStack(int n) {
            super(n);
            this.totalWork = n;
            this.pushed = n;
        }

        synchronized void linkThread() {
            ++this.totalThreads;
        }

        synchronized void unlinkThread() {
            --this.totalThreads;
            if (this.waitingThreads >= this.totalThreads) {
                this.notifyAll();
                if (DEBUG && this.totalThreads == 0) {
                    System.out.println("Total waits " + this.waits + " " + this.waitsduration + "ms");
                }
            }
        }

        int worked() {
            int done = this.pushed - this.size();
            int newDone = done - this.lastDone;
            int ticksLeft = this.totalWork - this.worked;
            if (newDone > 0) {
                int k = ticksLeft * newDone / (newDone + this.size());
                if (k < this.totalWork / 1000) {
                    k = 0;
                }
                if (k > 0) {
                    this.worked += k;
                    this.lastDone = done;
                }
                return k;
            }
            return 0;
        }

        int waitAndPop() {
            ++this.waitingThreads;
            long t = System.currentTimeMillis();
            ++this.waits;
            try {
                while (this.waitingThreads < this.totalThreads && this.size() == 0) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                return -1;
            }
            long t2 = System.currentTimeMillis();
            this.waitsduration += t2 - t;
            if (DEBUG && t2 - t > 10L) {
                System.out.println("Slow wait " + (t2 - t) + "ms " + Thread.currentThread() + " " + this.size());
            }
            if (this.waitingThreads >= this.totalThreads) {
                --this.waitingThreads;
                return -1;
            }
            --this.waitingThreads;
            return this.pop();
        }

        boolean pushIfWaiting(int z) {
            if (this.waitingThreads * 50 + (this.totalThreads - this.waitingThreads - 1) * 15 > this.size()) {
                this.push(z);
                ++this.pushed;
                if (this.waitingThreads > 0) {
                    if (this.size() > 1) {
                        this.notifyAll();
                    } else {
                        this.notify();
                    }
                }
                return true;
            }
            return false;
        }
    }
}

