/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import com.ibm.icu.text.NumberFormat;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayIntBig;
import org.eclipse.mat.collect.BitField;
import org.eclipse.mat.collect.SetInt;
import org.eclipse.mat.inspections.FindLeaksQuery;
import org.eclipse.mat.inspections.threads.ThreadInfoQuery;
import org.eclipse.mat.inspections.util.ObjectTreeFactory;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.internal.snapshot.inspections.MultiplePath2GCRootsQuery;
import org.eclipse.mat.query.BytesFormat;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IContextObjectSet;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IResultTree;
import org.eclipse.mat.query.ISelectionProvider;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.query.refined.RefinedResultBuilder;
import org.eclipse.mat.query.refined.RefinedStructuredResult;
import org.eclipse.mat.query.refined.RefinedTree;
import org.eclipse.mat.query.registry.Converters;
import org.eclipse.mat.query.results.CompositeResult;
import org.eclipse.mat.query.results.ListResult;
import org.eclipse.mat.query.results.TextResult;
import org.eclipse.mat.report.ITestResult;
import org.eclipse.mat.report.QuerySpec;
import org.eclipse.mat.report.SectionSpec;
import org.eclipse.mat.report.Spec;
import org.eclipse.mat.snapshot.ClassHistogramRecord;
import org.eclipse.mat.snapshot.Histogram;
import org.eclipse.mat.snapshot.IMultiplePathsFromGCRootsComputer;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.MultiplePathsFromGCRootsClassRecord;
import org.eclipse.mat.snapshot.MultiplePathsFromGCRootsRecord;
import org.eclipse.mat.snapshot.extension.IThreadInfo;
import org.eclipse.mat.snapshot.extension.ITroubleTicketResolver;
import org.eclipse.mat.snapshot.model.GCRootInfo;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IClassLoader;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IStackFrame;
import org.eclipse.mat.snapshot.model.IThreadStack;
import org.eclipse.mat.snapshot.model.NamedReference;
import org.eclipse.mat.snapshot.model.ThreadToLocalReference;
import org.eclipse.mat.snapshot.query.Icons;
import org.eclipse.mat.snapshot.query.ObjectListResult;
import org.eclipse.mat.snapshot.query.PieFactory;
import org.eclipse.mat.snapshot.query.RetainedSizeDerivedData;
import org.eclipse.mat.snapshot.query.SnapshotQuery;
import org.eclipse.mat.snapshot.registry.TroubleTicketResolverRegistry;
import org.eclipse.mat.util.HTMLUtils;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.SimpleMonitor;

@CommandName(value="leakhunter")
@Icon(value="/META-INF/icons/leak.gif")
@HelpUrl(value="/org.eclipse.mat.ui.help/tasks/runningleaksuspectreport.html")
public class LeakHunterQuery
implements IQuery {
    static final String SYSTEM_CLASSLOADER = Messages.LeakHunterQuery_SystemClassLoader;
    NumberFormat percentFormatter = NumberFormat.getPercentInstance();
    NumberFormat numberFormatter;
    BytesFormat bytesFormatter;
    @Argument
    public ISnapshot snapshot;
    @Argument(isMandatory=false)
    public int threshold_percent;
    @Argument(isMandatory=false)
    public int max_paths;
    @Argument(isMandatory=false, advice=Argument.Advice.CLASS_NAME_PATTERN, flag="skip")
    public Pattern skipPattern;
    @Argument(isMandatory=false)
    public List<String> excludes;
    private long totalHeap;

    public LeakHunterQuery() {
        this.percentFormatter.setMinimumFractionDigits(2);
        this.percentFormatter.setMaximumFractionDigits(2);
        this.numberFormatter = NumberFormat.getNumberInstance();
        this.bytesFormatter = BytesFormat.getInstance();
        this.threshold_percent = 10;
        this.max_paths = 10000;
        this.skipPattern = Pattern.compile("java\\..*|javax\\..*|com\\.sun\\..*|sun\\..*|jdk\\..*");
        this.excludes = Arrays.asList("java.lang.ref.Reference:referent", "java.lang.ref.Finalizer:unfinalized", "java.lang.Runtime:<" + GCRootInfo.getTypeAsString(1024) + ">");
    }

    public IResult execute(IProgressListener listener) throws Exception {
        this.totalHeap = this.snapshot.getSnapshotInfo().getUsedHeapSize();
        SimpleMonitor monitor = new SimpleMonitor(Messages.LeakHunterQuery_ProgressName, listener, new int[]{30, 70});
        listener.subTask(Messages.LeakHunterQuery_FindingProblemSuspects);
        FindLeaksQuery.SuspectsResultTable findLeaksResult = this.callFindLeaks(monitor.nextMonitor());
        FindLeaksQuery.SuspectRecord[] leakSuspects = findLeaksResult.getData();
        SectionSpec result = new SectionSpec(Messages.LeakHunterQuery_LeakHunter);
        listener.subTask(Messages.LeakHunterQuery_PreparingResults);
        if (leakSuspects.length > 0) {
            int[] ticks2 = new int[leakSuspects.length + 1];
            int i = 0;
            while (i < leakSuspects.length - 1) {
                ticks2[i] = 100;
                ++i;
            }
            ticks2[leakSuspects.length] = 50;
            SimpleMonitor monitor2 = new SimpleMonitor(Messages.LeakHunterQuery_ProgressName, monitor.nextMonitor(), ticks2);
            PieFactory pie = new PieFactory(this.snapshot);
            int num = 0;
            while (num < leakSuspects.length) {
                FindLeaksQuery.SuspectRecord rec = leakSuspects[num];
                pie.addSlice(rec.suspect.getObjectId(), MessageUtil.format((String)Messages.LeakHunterQuery_ProblemSuspect, (Object[])new Object[]{num + 1}), rec.suspect.getUsedHeapSize(), rec.getSuspectRetained());
                ++num;
            }
            result.add((Spec)new QuerySpec(Messages.LeakHunterQuery_Overview, (IResult)pie.build()));
            HashMap<Integer, List<Integer>> accPoint2ProblemNr = new HashMap<Integer, List<Integer>>();
            int problemNum = 0;
            FindLeaksQuery.SuspectRecord[] suspectRecordArray = leakSuspects;
            int n = leakSuspects.length;
            int n2 = 0;
            while (n2 < n) {
                FindLeaksQuery.SuspectRecord rec = suspectRecordArray[n2];
                ++problemNum;
                FindLeaksQuery.AccumulationPoint ap = rec.getAccumulationPoint();
                if (ap != null) {
                    List<Integer> numbers = accPoint2ProblemNr.get(ap.getObject().getObjectId());
                    if (numbers == null) {
                        numbers = new ArrayList<Integer>(2);
                        accPoint2ProblemNr.put(ap.getObject().getObjectId(), numbers);
                    }
                    numbers.add(problemNum);
                }
                CompositeResult suspectDetails = this.getLeakSuspectDescription(rec, monitor2.nextMonitor());
                suspectDetails.setStatus(ITestResult.Status.ERROR);
                QuerySpec spec = new QuerySpec(MessageUtil.format((String)Messages.LeakHunterQuery_ProblemSuspect, (Object[])new Object[]{problemNum}));
                spec.setResult((IResult)suspectDetails);
                spec.set("rendering.pattern", "overview_details");
                spec.set("html.is_important", Boolean.TRUE.toString());
                result.add((Spec)spec);
                ++n2;
            }
            List<CompositeResult> hints = this.findCommonPathForSuspects(accPoint2ProblemNr, monitor2.nextMonitor());
            int k = 0;
            while (k < hints.size()) {
                QuerySpec spec = new QuerySpec(MessageUtil.format((String)Messages.LeakHunterQuery_Hint, (Object[])new Object[]{k + 1}));
                spec.setResult((IResult)hints.get(k));
                spec.set("rendering.pattern", "overview_details");
                spec.set("html.is_important", Boolean.TRUE.toString());
                result.add((Spec)spec);
                ++k;
            }
        }
        listener.done();
        if (result.getChildren().size() != 0) {
            return result;
        }
        return new TextResult(Messages.LeakHunterQuery_NothingFound);
    }

    FindLeaksQuery.SuspectsResultTable callFindLeaks(IProgressListener listener) throws Exception {
        return (FindLeaksQuery.SuspectsResultTable)SnapshotQuery.lookup("find_leaks", this.snapshot).setArgument("threshold_percent", this.threshold_percent).setArgument("max_paths", this.max_paths).setArgument("excludes", this.excludes).execute(listener);
    }

    private boolean isThreadRelated(FindLeaksQuery.SuspectRecord suspect) throws SnapshotException {
        return this.isThread(suspect.getSuspect().getObjectId());
    }

    private boolean isThread(int objectId) throws SnapshotException {
        GCRootInfo[] gcRootInfo = this.snapshot.getGCRootInfo(objectId);
        if (gcRootInfo != null) {
            GCRootInfo[] gCRootInfoArray = gcRootInfo;
            int n = gcRootInfo.length;
            int n2 = 0;
            while (n2 < n) {
                GCRootInfo singleInfo = gCRootInfoArray[n2];
                if (singleInfo.getType() == 256) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean isStackFrame(int objectId) throws SnapshotException {
        return this.snapshot.getClassOf(objectId).doesExtend("<method>") || this.snapshot.getClassOf(objectId).doesExtend("<stack frame>");
    }

    private boolean isStackFrameLocal(int frameId, int objectId) throws SnapshotException {
        IObject frame = this.snapshot.getObject(frameId);
        List<NamedReference> refs = frame.getOutboundReferences();
        for (NamedReference ref : refs) {
            if (!(ref instanceof ThreadToLocalReference) || ref.getObjectId() != objectId) continue;
            return true;
        }
        return false;
    }

    private CompositeResult getLeakSuspectDescription(FindLeaksQuery.SuspectRecord suspect, IProgressListener listener) throws SnapshotException {
        if (suspect instanceof FindLeaksQuery.SuspectRecordGroupOfObjects) {
            return this.getLeakDescriptionGroupOfObjects((FindLeaksQuery.SuspectRecordGroupOfObjects)suspect, listener);
        }
        return this.getLeakDescriptionSingleObject(suspect, listener);
    }

    private CompositeResult getLeakDescriptionSingleObject(FindLeaksQuery.SuspectRecord suspect, IProgressListener listener) throws SnapshotException {
        QuerySpec qspath;
        IObject describedObject;
        IObject threadObj;
        ThreadInfoQuery.Result threadDetails;
        ArrayList<IObject> objectsForTroubleTicketInfo;
        LinkedHashSet<String> keywords;
        TextResult overviewResult;
        StringBuilder overview;
        SimpleMonitor monitor;
        block26: {
            String classloaderName;
            IClassLoader suspectClassloader;
            String className;
            int subq = 5;
            int[] ticks = new int[subq];
            Arrays.fill(ticks, 100);
            monitor = new SimpleMonitor(Messages.LeakHunterQuery_DescriptionSingleObject, listener, ticks);
            overview = new StringBuilder(256);
            overviewResult = new TextResult();
            keywords = new LinkedHashSet<String>();
            objectsForTroubleTicketInfo = new ArrayList<IObject>(2);
            int suspectId = suspect.getSuspect().getObjectId();
            boolean isThreadRelated = this.isThreadRelated(suspect);
            if (isThreadRelated) {
                overview.append("<p>");
                overview.append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_Thread, (Object[])new Object[]{HTMLUtils.escapeText((String)suspect.getSuspect().getDisplayName()), this.formatRetainedHeap(suspect.getSuspectRetained(), this.totalHeap)}));
                overview.append("</p>");
            } else if (this.snapshot.isClassLoader(suspectId)) {
                IClassLoader suspectClassloader2 = (IClassLoader)suspect.getSuspect();
                objectsForTroubleTicketInfo.add(suspectClassloader2);
                String classloaderName2 = this.getClassLoaderName(suspectClassloader2, keywords);
                overview.append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_ClassLoader, (Object[])new Object[]{classloaderName2, this.formatRetainedHeap(suspect.getSuspectRetained(), this.totalHeap)}));
            } else if (this.snapshot.isClass(suspectId)) {
                className = ((IClass)suspect.getSuspect()).getName();
                keywords.add(className);
                suspectClassloader = (IClassLoader)this.snapshot.getObject(((IClass)suspect.getSuspect()).getClassLoaderId());
                objectsForTroubleTicketInfo.add(suspect.getSuspect());
                classloaderName = this.getClassLoaderName(suspectClassloader, keywords);
                overview.append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_Class, (Object[])new Object[]{HTMLUtils.escapeText((String)className), classloaderName, this.formatRetainedHeap(suspect.getSuspectRetained(), this.totalHeap)}));
            } else {
                int referrerId;
                className = suspect.getSuspect().getClazz().getName();
                keywords.add(className);
                suspectClassloader = (IClassLoader)this.snapshot.getObject(suspect.getSuspect().getClazz().getClassLoaderId());
                objectsForTroubleTicketInfo.add(suspect.getSuspect());
                classloaderName = this.getClassLoaderName(suspectClassloader, keywords);
                overview.append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_Instance, (Object[])new Object[]{HTMLUtils.escapeText((String)className), classloaderName, this.formatRetainedHeap(suspect.getSuspectRetained(), this.totalHeap)}));
                if (this.skipPattern.matcher(className).matches() && !isThreadRelated && (referrerId = this.findReferrer(suspect.getSuspect().getObjectId())) != -1) {
                    String referrerClassloaderName;
                    IObject referrer = this.snapshot.getObject(referrerId);
                    IObject referrerClassloader = null;
                    if (this.snapshot.isClassLoader(referrerId)) {
                        referrerClassloader = referrer;
                        objectsForTroubleTicketInfo.add(referrerClassloader);
                        referrerClassloaderName = this.getClassLoaderName(referrerClassloader, keywords);
                        overview.append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_ReferencedBy, (Object[])new Object[]{referrerClassloaderName}));
                    } else if (this.snapshot.isClass(referrerId)) {
                        className = ((IClass)referrer).getName();
                        keywords.add(className);
                        referrerClassloader = this.snapshot.getObject(((IClass)referrer).getClassLoaderId());
                        objectsForTroubleTicketInfo.add(referrer);
                        referrerClassloaderName = this.getClassLoaderName(referrerClassloader, keywords);
                        overview.append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_ReferencedByClass, (Object[])new Object[]{HTMLUtils.escapeText((String)className), referrerClassloaderName}));
                    } else {
                        if (this.isThread(referrerId)) {
                            isThreadRelated = true;
                            suspectId = referrerId;
                            IObject suspectObject = this.snapshot.getObject(suspectId);
                            suspect = new FindLeaksQuery.SuspectRecord(suspectObject, suspectObject.getRetainedHeapSize(), suspect.getAccumulationPoint());
                        }
                        className = referrer.getClazz().getName();
                        keywords.add(className);
                        referrerClassloader = this.snapshot.getObject(referrer.getClazz().getClassLoaderId());
                        objectsForTroubleTicketInfo.add(referrer);
                        referrerClassloaderName = this.getClassLoaderName(referrerClassloader, keywords);
                        overview.append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_ReferencedByInstance, (Object[])new Object[]{HTMLUtils.escapeText((String)referrer.getDisplayName()), referrerClassloaderName}));
                        if (isThreadRelated) {
                            overview.append("<p>");
                            overview.append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_Thread, (Object[])new Object[]{HTMLUtils.escapeText((String)suspect.getSuspect().getDisplayName()), this.formatRetainedHeap(suspect.getSuspectRetained(), this.totalHeap)}));
                            overview.append("</p>");
                        }
                    }
                }
            }
            if (suspect.getAccumulationPoint() != null) {
                String classloaderName3;
                IObject accumulationObject = suspect.getAccumulationPoint().getObject();
                int accumulationPointId = accumulationObject.getObjectId();
                if (this.snapshot.isClassLoader(accumulationPointId)) {
                    IClassLoader accPointClassloader = (IClassLoader)accumulationObject;
                    objectsForTroubleTicketInfo.add(accPointClassloader);
                    String classloaderName4 = this.getClassLoaderName(accPointClassloader, keywords);
                    overview.append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_AccumulatedBy, (Object[])new Object[]{classloaderName4, this.formatRetainedHeap(suspect.getAccumulationPoint().getRetainedHeapSize(), this.totalHeap)}));
                } else if (this.snapshot.isClass(accumulationPointId)) {
                    IClass clazz = (IClass)accumulationObject;
                    keywords.add(clazz.getName());
                    IClassLoader accPointClassloader = (IClassLoader)this.snapshot.getObject(clazz.getClassLoaderId());
                    objectsForTroubleTicketInfo.add(accumulationObject);
                    classloaderName3 = this.getClassLoaderName(accPointClassloader, keywords);
                    overview.append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_AccumulatedByLoadedBy, (Object[])new Object[]{HTMLUtils.escapeText((String)clazz.getName()), classloaderName3, this.formatRetainedHeap(suspect.getAccumulationPoint().getRetainedHeapSize(), this.totalHeap)}));
                } else {
                    String className2 = accumulationObject.getClazz().getName();
                    keywords.add(className2);
                    IClassLoader accPointClassloader = (IClassLoader)this.snapshot.getObject(accumulationObject.getClazz().getClassLoaderId());
                    objectsForTroubleTicketInfo.add(accumulationObject);
                    classloaderName3 = this.getClassLoaderName(accPointClassloader, keywords);
                    overview.append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_AccumulatedByInstance, (Object[])new Object[]{HTMLUtils.escapeText((String)className2), classloaderName3, this.formatRetainedHeap(suspect.getAccumulationPoint().getRetainedHeapSize(), this.totalHeap)}));
                }
            }
            threadDetails = null;
            threadObj = null;
            if (isThreadRelated) {
                threadDetails = this.extractThreadData(suspect, keywords, objectsForTroubleTicketInfo, overview, overviewResult, monitor.nextMonitor());
                threadObj = suspect.getSuspect();
            }
            describedObject = suspect.getAccumulationPoint() != null ? suspect.getAccumulationPoint().getObject() : suspect.getSuspect();
            try {
                IResult result = SnapshotQuery.lookup("path2gc", this.snapshot).setArgument("object", describedObject).setArgument("excludes", this.excludes).execute(monitor.nextMonitor());
                qspath = new QuerySpec(Messages.LeakHunterQuery_ShortestPaths, result);
                StringBuilder sb = new StringBuilder("path2gc");
                sb.append(" 0x").append(Long.toHexString(describedObject.getObjectAddress()));
                this.addExcludes(sb);
                qspath.setCommand(sb.toString());
                if (isThreadRelated || !(result instanceof IResultTree) || !(result instanceof ISelectionProvider)) break block26;
                IResultTree tree = (IResultTree)result;
                ISelectionProvider sel = (ISelectionProvider)result;
                for (Object row : tree.getElements()) {
                    int[] r = this.findEndTree(tree, sel, row, describedObject.getObjectId(), -1);
                    if (r == null || !this.isThread(r[0])) continue;
                    isThreadRelated = true;
                    int accObjId = r[2] >= 0 && this.isStackFrame(r[1]) && this.isStackFrameLocal(r[1], r[2]) ? r[2] : r[1];
                    FindLeaksQuery.AccumulationPoint ap = accObjId >= 0 ? new FindLeaksQuery.AccumulationPoint(this.snapshot.getObject(accObjId)) : null;
                    IObject suspectObject = this.snapshot.getObject(r[0]);
                    FindLeaksQuery.SuspectRecord suspect2 = new FindLeaksQuery.SuspectRecord(suspectObject, suspectObject.getRetainedHeapSize(), ap);
                    objectsForTroubleTicketInfo.add(suspect2.getSuspect());
                    overview.append("<p>");
                    if (ap != null) {
                        overview.append(MessageUtil.format((String)Messages.LeakHunterQuery_ThreadLocalVariable, (Object[])new Object[]{HTMLUtils.escapeText((String)suspect2.getSuspect().getDisplayName()), HTMLUtils.escapeText((String)ap.getObject().getDisplayName()), HTMLUtils.escapeText((String)describedObject.getDisplayName())}));
                    } else {
                        overview.append(MessageUtil.format((String)Messages.LeakHunterQuery_ThreadShortestPath, (Object[])new Object[]{HTMLUtils.escapeText((String)suspect2.getSuspect().getDisplayName()), HTMLUtils.escapeText((String)describedObject.getDisplayName())}));
                    }
                    overview.append(" ");
                    overview.append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_Thread, (Object[])new Object[]{HTMLUtils.escapeText((String)suspect2.getSuspect().getDisplayName()), this.formatRetainedHeap(suspect2.getSuspectRetained(), this.totalHeap)}));
                    overview.append("</p>");
                    threadDetails = this.extractThreadData(suspect2, keywords, objectsForTroubleTicketInfo, overview, overviewResult, monitor.nextMonitor());
                    threadObj = suspect2.getSuspect();
                    break;
                }
            }
            catch (Exception e) {
                throw new SnapshotException(Messages.LeakHunterQuery_ErrorShortestPaths, (Throwable)e);
            }
        }
        this.appendKeywords(keywords, overview);
        this.appendTroubleTicketInformation(objectsForTroubleTicketInfo, overview, monitor.nextMonitor());
        CompositeResult composite = new CompositeResult(new IResult[0]);
        overviewResult.setText(overview.toString());
        composite.addResult(Messages.LeakHunterQuery_Description, (IResult)overviewResult);
        composite.addResult((IResult)qspath);
        IResult objectInDominatorTree = this.showInDominatorTree(describedObject.getObjectId());
        QuerySpec qs = new QuerySpec(Messages.LeakHunterQuery_AccumulatedObjects, objectInDominatorTree);
        qs.setCommand("show_dominator_tree 0x" + Long.toHexString(describedObject.getObjectAddress()));
        composite.addResult((IResult)qs);
        IResult histogramOfDominated = this.getHistogramOfDominated(describedObject.getObjectId(), monitor.nextMonitor());
        if (histogramOfDominated != null) {
            qs = new QuerySpec(Messages.LeakHunterQuery_AccumulatedObjectsByClass, histogramOfDominated);
            qs.setCommand("show_dominator_tree 0x" + Long.toHexString(describedObject.getObjectAddress()) + " -groupby BY_CLASS");
            composite.addResult((IResult)qs);
            IResult result = SnapshotQuery.lookup("show_retained_set", this.snapshot).setArgument("objects", describedObject).execute(monitor.nextMonitor());
            qs = new QuerySpec(Messages.LeakHunterQuery_AllAccumulatedObjectsByClass, result);
            qs.setCommand("show_retained_set 0x" + Long.toHexString(describedObject.getObjectAddress()));
            composite.addResult((IResult)qs);
        }
        if (threadDetails != null) {
            qs = new QuerySpec(Messages.LeakHunterQuery_ThreadDetails, (IResult)threadDetails);
            qs.setCommand("thread_details 0x" + Long.toHexString(threadObj.getObjectAddress()));
            composite.addResult((IResult)qs);
        }
        listener.done();
        return composite;
    }

    private void addCommand(QuerySpec spec, String command, int[] suspects) {
        if (suspects.length > 0) {
            if (suspects.length <= 30) {
                try {
                    StringBuilder sb = new StringBuilder(command);
                    int[] nArray = suspects;
                    int n = suspects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int i = nArray[n2];
                        sb.append(" 0x").append(Long.toHexString(this.snapshot.mapIdToAddress(i)));
                        ++n2;
                    }
                    spec.setCommand(sb.toString());
                    return;
                }
                catch (SnapshotException sb) {
                    // empty catch block
                }
            }
            try {
                IClass cls = this.snapshot.getClassOf(suspects[0]);
                if (cls.getNumberOfObjects() == suspects.length) {
                    Collection<IClass> cl1;
                    int[] a = cls.getObjectIds();
                    int[] b = (int[])suspects.clone();
                    Arrays.sort(a);
                    Arrays.sort(b);
                    if (Arrays.equals(a, b) && (cl1 = this.snapshot.getClassesByName(cls.getName(), false)) != null && cl1.size() == 1) {
                        StringBuilder sb = new StringBuilder(command);
                        sb.append(' ');
                        sb.append(cls.getName());
                        spec.setCommand(sb.toString());
                        return;
                    }
                }
            }
            catch (SnapshotException snapshotException) {
                // empty catch block
            }
        }
    }

    private CompositeResult getLeakDescriptionGroupOfObjects(FindLeaksQuery.SuspectRecordGroupOfObjects suspect, IProgressListener listener) throws SnapshotException {
        QuerySpec qs;
        Object iObject;
        int subq = 4;
        if (suspect.getAccumulationPoint() != null) {
            subq += 3;
        }
        int[] ticks = new int[subq];
        Arrays.fill(ticks, 100);
        SimpleMonitor monitor = new SimpleMonitor(Messages.LeakHunterQuery_DescriptionGroupObjects, listener, ticks);
        StringBuilder builder = new StringBuilder(256);
        LinkedHashSet<String> keywords = new LinkedHashSet<String>();
        ArrayList<IObject> objectsForTroubleTicketInfo = new ArrayList<IObject>(2);
        String className = ((IClass)suspect.getSuspect()).getName();
        keywords.add(className);
        IClassLoader classloader = (IClassLoader)this.snapshot.getObject(((IClass)suspect.getSuspect()).getClassLoaderId());
        objectsForTroubleTicketInfo.add(suspect.getSuspect());
        String classloaderName = this.getClassLoaderName(classloader, keywords);
        String numberOfInstances = this.numberFormatter.format((long)suspect.getSuspectInstances().length);
        builder.append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_InstancesOccupy, (Object[])new Object[]{numberOfInstances, HTMLUtils.escapeText((String)className), classloaderName, this.formatRetainedHeap(suspect.getSuspectRetained(), this.totalHeap)}));
        int[] suspectInstances = suspect.getSuspectInstances();
        ArrayList<IObject> bigSuspectInstances = new ArrayList<IObject>();
        int j = 0;
        while (j < suspectInstances.length) {
            IObject inst = this.snapshot.getObject(suspectInstances[j]);
            if (inst.getRetainedHeapSize() < this.totalHeap / 100L) break;
            bigSuspectInstances.add(inst);
            ++j;
        }
        if (bigSuspectInstances.size() > 0) {
            builder.append("<p>").append(Messages.LeakHunterQuery_BiggestInstances);
            builder.append("</p>");
            builder.append("<ul title=\"").append(this.escapeHTMLAttribute(Messages.LeakHunterQuery_BiggestInstances)).append("\">");
            for (IObject inst : bigSuspectInstances) {
                builder.append("<li>").append(HTMLUtils.escapeText((String)inst.getDisplayName()));
                builder.append("&nbsp;-&nbsp;").append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_Bytes, (Object[])new Object[]{this.formatRetainedHeap(inst.getRetainedHeapSize(), this.totalHeap)}));
                builder.append("</li>");
            }
            builder.append("</ul>");
        }
        if (suspect.getAccumulationPoint() != null) {
            IClassLoader accPointClassloader;
            builder.append("<p>");
            int accumulationPointId = suspect.getAccumulationPoint().getObject().getObjectId();
            if (this.snapshot.isClassLoader(accumulationPointId)) {
                objectsForTroubleTicketInfo.add((IClassLoader)suspect.getAccumulationPoint().getObject());
                classloaderName = this.getClassLoaderName(suspect.getAccumulationPoint().getObject(), keywords);
                builder.append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_ReferencedFromClassLoader, (Object[])new Object[]{classloaderName, this.formatRetainedHeap(suspect.getAccumulationPoint().getRetainedHeapSize(), this.totalHeap)}));
            } else if (this.snapshot.isClass(accumulationPointId)) {
                className = ((IClass)suspect.getAccumulationPoint().getObject()).getName();
                keywords.add(className);
                accPointClassloader = (IClassLoader)this.snapshot.getObject(((IClass)suspect.getAccumulationPoint().getObject()).getClassLoaderId());
                objectsForTroubleTicketInfo.add(suspect.getAccumulationPoint().getObject());
                classloaderName = this.getClassLoaderName(accPointClassloader, keywords);
                builder.append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_ReferencedFromClass, (Object[])new Object[]{HTMLUtils.escapeText((String)className), classloaderName, this.formatRetainedHeap(suspect.getAccumulationPoint().getRetainedHeapSize(), this.totalHeap)}));
            } else {
                int referrerId;
                className = suspect.getAccumulationPoint().getObject().getClazz().getName();
                keywords.add(className);
                accPointClassloader = (IClassLoader)this.snapshot.getObject(suspect.getAccumulationPoint().getObject().getClazz().getClassLoaderId());
                objectsForTroubleTicketInfo.add(suspect.getAccumulationPoint().getObject());
                classloaderName = this.getClassLoaderName(accPointClassloader, keywords);
                builder.append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_ReferencedFromInstance, (Object[])new Object[]{HTMLUtils.escapeText((String)className), classloaderName, this.formatRetainedHeap(suspect.getAccumulationPoint().getRetainedHeapSize(), this.totalHeap)}));
                boolean isThreadRelated = this.isThread(suspect.getAccumulationPoint().getObject().getObjectId());
                if (this.skipPattern.matcher(className).matches() && !isThreadRelated && (referrerId = this.findReferrer(accumulationPointId)) != -1) {
                    String referrerClassloaderName;
                    IObject referrer = this.snapshot.getObject(referrerId);
                    IObject referrerClassloader = null;
                    if (this.snapshot.isClassLoader(referrerId)) {
                        referrerClassloader = referrer;
                        objectsForTroubleTicketInfo.add(referrerClassloader);
                        referrerClassloaderName = this.getClassLoaderName(referrerClassloader, keywords);
                        builder.append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_ReferencedBy, (Object[])new Object[]{referrerClassloaderName}));
                    } else if (this.snapshot.isClass(referrerId)) {
                        className = ((IClass)referrer).getName();
                        keywords.add(className);
                        referrerClassloader = this.snapshot.getObject(((IClass)referrer).getClassLoaderId());
                        objectsForTroubleTicketInfo.add(referrer);
                        referrerClassloaderName = this.getClassLoaderName(referrerClassloader, keywords);
                        builder.append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_ReferencedByClass, (Object[])new Object[]{HTMLUtils.escapeText((String)className), referrerClassloaderName}));
                    } else {
                        FindLeaksQuery.SuspectRecord suspect2 = null;
                        if (this.isThread(referrerId)) {
                            isThreadRelated = true;
                            int suspectId = referrerId;
                            IObject suspectObject = this.snapshot.getObject(suspectId);
                            suspect2 = new FindLeaksQuery.SuspectRecord(suspectObject, suspectObject.getRetainedHeapSize(), suspect.getAccumulationPoint());
                        }
                        className = referrer.getClazz().getName();
                        keywords.add(className);
                        referrerClassloader = this.snapshot.getObject(referrer.getClazz().getClassLoaderId());
                        objectsForTroubleTicketInfo.add(referrer);
                        String referrerClassloaderName2 = this.getClassLoaderName(referrerClassloader, keywords);
                        builder.append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_ReferencedByInstance, (Object[])new Object[]{HTMLUtils.escapeText((String)referrer.getDisplayName()), referrerClassloaderName2}));
                        if (isThreadRelated) {
                            builder.append("<p>");
                            builder.append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_Thread, (Object[])new Object[]{HTMLUtils.escapeText((String)suspect2.getSuspect().getDisplayName()), this.formatRetainedHeap(suspect2.getSuspectRetained(), this.totalHeap)}));
                            builder.append("</p>");
                        }
                    }
                }
            }
            builder.append("</p>");
        }
        ThreadInfoQuery.Result threadDetails = null;
        IObject threadObj = null;
        CompositeResult composite = new CompositeResult(new IResult[0]);
        TextResult overviewResult = new TextResult();
        composite.addResult(Messages.LeakHunterQuery_Description, (IResult)overviewResult);
        if (bigSuspectInstances.size() > 0) {
            PieFactory pie = new PieFactory(this.snapshot, this.totalHeap);
            int[] big = new int[bigSuspectInstances.size()];
            long totalBig = 0L;
            long usedBig = 0L;
            int i = 0;
            while (i < bigSuspectInstances.size()) {
                iObject = (IObject)bigSuspectInstances.get(i);
                big[i] = iObject.getObjectId();
                pie.addSlice(big[i], iObject.getDisplayName(), iObject.getUsedHeapSize(), iObject.getRetainedHeapSize());
                totalBig += iObject.getRetainedHeapSize();
                usedBig += iObject.getUsedHeapSize();
                ++i;
            }
            long totalSuspects = 0L;
            long usedSuspects = 0L;
            int[] nArray = suspectInstances;
            int n = suspectInstances.length;
            int n2 = 0;
            while (n2 < n) {
                int s = nArray[n2];
                IObject inst = this.snapshot.getObject(s);
                totalSuspects += inst.getRetainedHeapSize();
                usedSuspects += inst.getUsedHeapSize();
                ++n2;
            }
            pie.addSlice(-1, Messages.LeakHunterQuery_OtherSuspectInstances, usedSuspects - usedBig, totalSuspects - totalBig);
            QuerySpec specPie = new QuerySpec(Messages.LeakHunterQuery_BiggestInstancesOverview, (IResult)pie.build());
            specPie.set("html.collapsed", Boolean.TRUE.toString());
            composite.addResult((IResult)specPie);
            QuerySpec spec = new QuerySpec(Messages.LeakHunterQuery_BiggestInstancesHeading, (IResult)new ObjectListResult.Outbound(this.snapshot, big));
            try {
                StringBuilder sb = new StringBuilder("list_objects");
                int[] nArray2 = big;
                int n3 = big.length;
                int n4 = 0;
                while (n4 < n3) {
                    int i2 = nArray2[n4];
                    sb.append(" 0x").append(Long.toHexString(this.snapshot.mapIdToAddress(i2)));
                    ++n4;
                }
                spec.setCommand(sb.toString());
            }
            catch (SnapshotException snapshotException) {
                // empty catch block
            }
            spec.set("html.collapsed", Boolean.TRUE.toString());
            composite.addResult((IResult)spec);
        }
        IObject io = suspect.getSuspect();
        String oql = null;
        if (io instanceof IClass) {
            String cn = this.OQLclassName((IClass)io);
            oql = "SELECT * FROM " + cn + " s WHERE dominatorof(s) = null";
        }
        RefinedResultBuilder rbuilder = SnapshotQuery.lookup("histogram", this.snapshot).setArgument("objects", suspectInstances).refine(monitor.nextMonitor());
        rbuilder.setInlineRetainedSizeCalculation(true);
        rbuilder.addDefaultContextDerivedColumn(RetainedSizeDerivedData.PRECISE);
        RefinedStructuredResult result = rbuilder.build();
        QuerySpec qs2 = new QuerySpec(Messages.LeakHunterQuery_SuspectObjectsByClass, (IResult)result);
        this.addCommand(qs2, "histogram", suspectInstances);
        if (qs2.getCommand() == null) {
            qs2.setCommand("histogram " + oql + ";");
        }
        qs2.set("html.collapsed", Boolean.TRUE.toString());
        composite.addResult((IResult)qs2);
        rbuilder = SnapshotQuery.lookup("show_retained_set", this.snapshot).setArgument("objects", suspectInstances).refine(monitor.nextMonitor());
        rbuilder.setInlineRetainedSizeCalculation(true);
        rbuilder.addDefaultContextDerivedColumn(RetainedSizeDerivedData.APPROXIMATE);
        result = rbuilder.build();
        qs2 = new QuerySpec(Messages.LeakHunterQuery_AllObjectsByClassRetained, (IResult)result);
        this.addCommand(qs2, "show_retained_set", suspectInstances);
        if (qs2.getCommand() == null) {
            qs2.setCommand("show_retained_set " + oql + ';');
        }
        qs2.set("html.collapsed", Boolean.TRUE.toString());
        composite.addResult((IResult)qs2);
        FindLeaksQuery.AccumulationPoint accPoint = suspect.getAccumulationPoint();
        if (accPoint != null) {
            qs = new QuerySpec(Messages.LeakHunterQuery_CommonPath, (IResult)MultiplePath2GCRootsQuery.create(this.snapshot, suspect.getPathsComputer(), suspect.getCommonPath(), monitor.nextMonitor()));
            int[] paths = suspect.suspectInstances.length <= 25 ? suspect.suspectInstances : (suspect.getCommonPath().length > 0 ? new int[]{suspect.getCommonPath()[suspect.getCommonPath().length - 1]} : new int[]{});
            if (paths.length > 0) {
                StringBuilder sb = new StringBuilder("merge_shortest_paths");
                iObject = paths;
                int totalSuspects = paths.length;
                int n = 0;
                while (n < totalSuspects) {
                    Object objId = iObject[n];
                    long addr = this.snapshot.mapIdToAddress((int)objId);
                    sb.append(" 0x").append(Long.toHexString(addr));
                    ++n;
                }
                this.addExcludes(sb);
                qs.setCommand(sb.toString());
            }
            composite.addResult((IResult)qs);
            int[] path = suspect.getCommonPath();
            if (path.length > 0 && this.isThread(path[0])) {
                FindLeaksQuery.AccumulationPoint ap = path.length > 2 && this.isStackFrame(path[1]) && this.isStackFrameLocal(path[1], path[2]) ? new FindLeaksQuery.AccumulationPoint(this.snapshot.getObject(path[2])) : (path.length > 1 ? new FindLeaksQuery.AccumulationPoint(this.snapshot.getObject(path[1])) : null);
                IObject suspectObject = this.snapshot.getObject(path[0]);
                FindLeaksQuery.SuspectRecord suspect2 = new FindLeaksQuery.SuspectRecord(suspectObject, suspectObject.getRetainedHeapSize(), ap);
                objectsForTroubleTicketInfo.add(suspect2.getSuspect());
                builder.append("<p>");
                if (ap != null) {
                    builder.append(MessageUtil.format((String)Messages.LeakHunterQuery_ThreadLocalVariable, (Object[])new Object[]{HTMLUtils.escapeText((String)suspect2.getSuspect().getDisplayName()), HTMLUtils.escapeText((String)ap.getObject().getDisplayName()), HTMLUtils.escapeText((String)accPoint.getObject().getDisplayName())}));
                } else {
                    builder.append(MessageUtil.format((String)Messages.LeakHunterQuery_ThreadShortestPath, (Object[])new Object[]{HTMLUtils.escapeText((String)suspect2.getSuspect().getDisplayName()), HTMLUtils.escapeText((String)accPoint.getObject().getDisplayName())}));
                }
                builder.append(" ");
                builder.append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_Thread, (Object[])new Object[]{HTMLUtils.escapeText((String)suspect2.getSuspect().getDisplayName()), this.formatRetainedHeap(suspect2.getSuspectRetained(), this.totalHeap)}));
                builder.append("</p>");
                threadDetails = this.extractThreadData(suspect2, keywords, objectsForTroubleTicketInfo, builder, overviewResult, monitor.nextMonitor());
                threadObj = suspect2.getSuspect();
            }
            IObject describedObject = accPoint.getObject();
            IResult objectInDominatorTree = this.showInDominatorTree(describedObject.getObjectId());
            QuerySpec qs22 = new QuerySpec(Messages.LeakHunterQuery_AccumulatedObjects, objectInDominatorTree);
            qs22.setCommand("show_dominator_tree 0x" + Long.toHexString(describedObject.getObjectAddress()));
            composite.addResult((IResult)qs22);
            IResult histogramOfDominated = this.getHistogramOfDominated(describedObject.getObjectId(), monitor.nextMonitor());
            if (histogramOfDominated != null) {
                qs = new QuerySpec(Messages.LeakHunterQuery_AccumulatedObjectsByClass, histogramOfDominated);
                qs.setCommand("show_dominator_tree 0x" + Long.toHexString(describedObject.getObjectAddress()) + " -groupby BY_CLASS");
                composite.addResult((IResult)qs);
                IResult result2 = SnapshotQuery.lookup("show_retained_set", this.snapshot).setArgument("objects", describedObject).execute(monitor.nextMonitor());
                qs = new QuerySpec(Messages.LeakHunterQuery_AllAccumulatedObjectsByClass, result2);
                qs.setCommand("show_retained_set 0x" + Long.toHexString(describedObject.getObjectAddress()));
                composite.addResult((IResult)qs);
            }
        } else {
            IResult result3 = this.findReferencePattern(suspect, monitor.nextMonitor());
            if (result3 != null) {
                String msg = suspect.getSuspectInstances().length > this.max_paths ? MessageUtil.format((String)Messages.LeakHunterQuery_ReferencePatternFor, (Object[])new Object[]{this.max_paths}) : Messages.LeakHunterQuery_ReferencePattern;
                QuerySpec qs3 = new QuerySpec(msg, result3);
                IObject io2 = suspect.getSuspect();
                if (io2 instanceof IClass) {
                    String cn = this.OQLclassName((IClass)io2);
                    StringBuilder sb = new StringBuilder("merge_shortest_paths SELECT * FROM ");
                    sb.append(cn).append(" s WHERE dominatorof(s) = null; -groupby FROM_GC_ROOTS_BY_CLASS");
                    this.addExcludes(sb);
                    qs3.setCommand(sb.toString());
                }
                composite.addResult((IResult)qs3);
            }
        }
        this.appendKeywords(keywords, builder);
        this.appendTroubleTicketInformation(objectsForTroubleTicketInfo, builder, monitor.nextMonitor());
        overviewResult.setText(builder.toString());
        if (threadDetails != null) {
            qs = new QuerySpec(Messages.LeakHunterQuery_ThreadDetails, threadDetails);
            qs.setCommand("thread_details 0x" + Long.toHexString(threadObj.getObjectAddress()));
            composite.addResult((IResult)qs);
        }
        listener.done();
        return composite;
    }

    void addExcludes(StringBuilder sb) {
        boolean hasDefault = true;
        if (this.excludes != null && !this.excludes.isEmpty() || hasDefault) {
            sb.append(" -excludes");
            if (this.excludes != null && !this.excludes.isEmpty()) {
                for (String ex : this.excludes) {
                    sb.append(' ').append(Converters.convertAndEscape(String.class, (Object)ex));
                }
            } else {
                sb.append(' ');
            }
            sb.append(';');
        }
    }

    private String escapeHTMLAttribute(String msg) {
        return HTMLUtils.escapeText((String)msg).replaceAll("\"", "&quote;").replaceAll("'", "&apos;");
    }

    private int[] findEndTree(IResultTree tree, ISelectionProvider sel, Object row, int prev, int prev2) {
        IContextObject x;
        if (sel.isSelected(row) && (x = tree.getContext(row)) != null && x.getObjectId() >= 0) {
            return new int[]{x.getObjectId(), prev, prev2};
        }
        if (sel.isExpanded(row)) {
            List children;
            x = tree.getContext(row);
            if (x != null) {
                prev2 = prev;
                prev = x.getObjectId();
            }
            if ((children = tree.getChildren(row)) != null) {
                for (Object r2 : children) {
                    int[] ret = this.findEndTree(tree, sel, r2, prev, prev2);
                    if (ret == null) continue;
                    return ret;
                }
            }
        }
        return null;
    }

    private String OQLclassName(IClass ic) {
        String className = ic.getName();
        try {
            Collection<IClass> classesByName = ic.getSnapshot().getClassesByName(className, false);
            if (className.matches("\\p{javaJavaIdentifierStart}[\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}.]*") && classesByName != null && classesByName.size() == 1) {
                return className;
            }
        }
        catch (SnapshotException snapshotException) {
            // empty catch block
        }
        return "0x" + Long.toHexString(ic.getObjectAddress());
    }

    private String formatRetainedHeap(long retained, long totalHeap) {
        return String.valueOf(this.bytesFormatter.format((Object)retained)) + " (" + this.percentFormatter.format((double)retained / (double)totalHeap) + ")";
    }

    private Map<String, String> getTroubleTicketMapping(ITroubleTicketResolver resolver, List<IObject> classloaders, IProgressListener listener) throws SnapshotException {
        HashMap<String, String> mapping = new HashMap<String, String>();
        for (IObject suspect : classloaders) {
            String old;
            String ticket = null;
            String key = null;
            if (suspect instanceof IClassLoader) {
                ticket = resolver.resolveByClassLoader((IClassLoader)suspect, listener);
                if (ticket != null && !"".equals(ticket.trim()) && (key = suspect.getClassSpecificName()) == null) {
                    key = suspect.getTechnicalName();
                }
            } else {
                IClass clazz = suspect instanceof IClass ? (IClass)suspect : suspect.getClazz();
                ticket = resolver.resolveByClass(clazz, listener);
                key = clazz.getName();
            }
            if (ticket == null || (old = (String)mapping.put(ticket, key)) == null) continue;
            mapping.put(ticket, String.valueOf(key) + ", " + old);
        }
        return mapping;
    }

    private String getName(IObject object) {
        String name = object.getClassSpecificName();
        if (name == null) {
            name = object.getTechnicalName();
        }
        return name;
    }

    private String getClassLoaderName(IObject classloader, Set<String> keywords) {
        if (classloader.getObjectAddress() == 0L) {
            return SYSTEM_CLASSLOADER;
        }
        String classloaderName = this.getName(classloader);
        if (keywords != null) {
            String keywordName = classloader.getClassSpecificName();
            if (keywordName == null) {
                keywordName = classloader.getClazz().getName();
            }
            keywords.add(keywordName);
        }
        return HTMLUtils.escapeText((String)classloaderName);
    }

    private IResult showInDominatorTree(int objectId) throws SnapshotException {
        Stack<Integer> tmp = new Stack<Integer>();
        int e = objectId;
        while (e != -1) {
            tmp.push(e);
            e = this.snapshot.getImmediateDominatorId(e);
        }
        ObjectTreeFactory.TreePathBuilder treeBuilder = new ObjectTreeFactory.TreePathBuilder(this.snapshot.getSnapshotInfo().getUsedHeapSize());
        treeBuilder.setIsOutgoing();
        treeBuilder.addBranch((Integer)tmp.pop());
        while (tmp.size() > 0) {
            treeBuilder.addChild(e, (e = ((Integer)tmp.pop()).intValue()) == objectId);
        }
        int[] dominatedByAccPoint = this.snapshot.getImmediateDominatedIds(objectId);
        int i = 0;
        while (i < 20 && i < dominatedByAccPoint.length) {
            treeBuilder.addSibling(dominatedByAccPoint[i], false);
            ++i;
        }
        return treeBuilder.build(this.snapshot);
    }

    private IResult getHistogramOfDominated(final int objectId, IProgressListener listener) throws SnapshotException {
        ClassHistogramRecord[] records;
        int[] dominatedByAccPoint = this.snapshot.getImmediateDominatedIds(objectId);
        Histogram h = this.snapshot.getHistogram(dominatedByAccPoint, listener);
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        ClassHistogramRecord[] classHistogramRecordArray = records = h.getClassHistogramRecords().toArray(new ClassHistogramRecord[0]);
        int n = records.length;
        int n2 = 0;
        while (n2 < n) {
            ClassHistogramRecord record = classHistogramRecordArray[n2];
            record.setRetainedHeapSize(this.snapshot.getMinRetainedSize(record.getObjectIds(), listener));
            ++n2;
        }
        Arrays.sort(records, Histogram.reverseComparator(Histogram.COMPARATOR_FOR_RETAINEDHEAPSIZE));
        ArrayList<ClassHistogramRecord> suspects = new ArrayList<ClassHistogramRecord>();
        int limit = 0;
        ClassHistogramRecord[] classHistogramRecordArray2 = records;
        int n3 = records.length;
        int n4 = 0;
        while (n4 < n3) {
            ClassHistogramRecord record = classHistogramRecordArray2[n4];
            if (limit >= 20) break;
            suspects.add(record);
            ++limit;
            ++n4;
        }
        ListResult result = new ListResult(ClassHistogramRecord.class, suspects, new String[]{"label", "numberOfObjects", "usedHeapSize", "retainedHeapSize"}){

            public URL getIcon(Object row) {
                return Icons.forObject(LeakHunterQuery.this.snapshot, ((ClassHistogramRecord)row).getClassId());
            }

            public IContextObject getContext(final Object row) {
                return new IContextObjectSet(){

                    public int getObjectId() {
                        return ((ClassHistogramRecord)row).getClassId();
                    }

                    public int[] getObjectIds() {
                        return ((ClassHistogramRecord)row).getObjectIds();
                    }

                    public String getOQL() {
                        int clsid = ((ClassHistogramRecord)row).getClassId();
                        return "SELECT OBJECTS s FROM OBJECTS (dominators(" + objectId + ")) s where classof(s).@objectId = " + clsid;
                    }
                };
            }
        };
        return result;
    }

    private void appendKeywords(Set<String> keywords, StringBuilder builder) {
        String title = Messages.LeakHunterQuery_Keywords;
        builder.append("<p><strong>").append(title).append("</strong>");
        builder.append("</p>");
        builder.append("<ul style=\"list-style-type:none;\" title=\"").append(this.escapeHTMLAttribute(title)).append("\">");
        for (String s : keywords) {
            builder.append("<li>").append(HTMLUtils.escapeText((String)s)).append("</li>");
        }
        builder.append("</ul>");
    }

    private void appendTroubleTicketInformation(List<IObject> classloaders, StringBuilder builder, IProgressListener listener) throws SnapshotException {
        for (ITroubleTicketResolver resolver : TroubleTicketResolverRegistry.instance().delegates()) {
            Map<String, String> mapping = this.getTroubleTicketMapping(resolver, classloaders, listener);
            if (mapping.isEmpty()) continue;
            String title = resolver.getTicketSystem();
            builder.append("<p><strong>").append(HTMLUtils.escapeText((String)title)).append("</strong>");
            builder.append("</p>");
            builder.append("<ul style=\"list-style-type:none;\" title=\"").append(this.escapeHTMLAttribute(title)).append("\">");
            for (Map.Entry<String, String> entry : mapping.entrySet()) {
                builder.append("<li>").append(MessageUtil.format((String)Messages.LeakHunterQuery_TicketForSuspect, (Object[])new Object[]{HTMLUtils.escapeText((String)entry.getKey()), HTMLUtils.escapeText((String)entry.getValue())})).append("</li>");
            }
            builder.append("</ul>");
        }
    }

    private ThreadInfoQuery.Result extractThreadData(FindLeaksQuery.SuspectRecord suspect, Set<String> keywords, List<IObject> involvedClassloaders, StringBuilder builder, TextResult textResult, IProgressListener listener) {
        final int threadId = suspect.getSuspect().getObjectId();
        ThreadInfoQuery.Result threadDetails = null;
        try {
            int contextClassloaderId;
            IThreadStack stack;
            threadDetails = (ThreadInfoQuery.Result)SnapshotQuery.lookup("thread_details", this.snapshot).setArgument("threadIds", threadId).execute(listener);
            IThreadInfo threadInfo = threadDetails.getThreads().get(0);
            keywords.addAll(threadInfo.getKeywords());
            CompositeResult requestInfos = threadInfo.getRequests();
            if (requestInfos != null && !requestInfos.isEmpty()) {
                builder.append("<p>");
                builder.append("</p>");
                builder.append("<ul style=\"list-style-type:none;\">");
                for (CompositeResult.Entry requestInfo : requestInfos.getResultEntries()) {
                    builder.append("<li>").append(HTMLUtils.escapeText((String)requestInfo.getName())).append(" ").append(textResult.linkTo(Messages.LeakHunterQuery_RequestDetails, requestInfo.getResult())).append("</li>");
                }
                builder.append("</ul>");
            }
            if ((stack = this.snapshot.getThreadStack(threadId)) != null) {
                Object object;
                int o3;
                IObject acc;
                final SetInt locals = new SetInt();
                IObject iObject = acc = suspect.getAccumulationPoint() != null ? suspect.getAccumulationPoint().getObject() : null;
                if (acc != null) {
                    IResultTree tree = (IResultTree)SnapshotQuery.lookup("merge_shortest_paths", this.snapshot).setArgument("objects", acc).setArgument("excludes", this.excludes).execute(listener);
                    for (Object row : tree.getElements()) {
                        IContextObject co = tree.getContext(row);
                        if (co.getObjectId() != threadId) continue;
                        for (Object row2 : tree.getChildren(row)) {
                            IContextObject co2 = tree.getContext(row2);
                            int o2 = co2.getObjectId();
                            if (o2 < 0) continue;
                            if (this.isStackFrame(o2)) {
                                for (Object row3 : tree.getChildren(row2)) {
                                    IContextObject co3 = tree.getContext(row3);
                                    o3 = co3.getObjectId();
                                    if (o3 < 0) continue;
                                    locals.add(o3);
                                }
                                if (o2 != acc.getObjectId()) continue;
                                locals.add(o2);
                                continue;
                            }
                            locals.add(o2);
                        }
                    }
                }
                StringBuilder stackBuilder = new StringBuilder();
                IObject threadObject = this.snapshot.getObject(threadId);
                String threadName = threadObject.getClassSpecificName();
                if (threadName == null) {
                    threadName = threadObject.getTechnicalName();
                }
                stackBuilder.append(threadName).append("\r\n");
                boolean foundLocals = !locals.isEmpty();
                long significantLocal = (long)(0.1 * (double)suspect.getSuspectRetained());
                long significantFrame = (long)(0.25 * (double)suspect.getSuspectRetained());
                ArrayList involvedFrames = new ArrayList();
                IStackFrame[] iStackFrameArray = stack.getStackFrames();
                o3 = iStackFrameArray.length;
                int co3 = 0;
                while (co3 < o3) {
                    IStackFrame frame = iStackFrameArray[co3];
                    boolean involved = false;
                    SetInt frameLocals = new SetInt();
                    object = frame.getLocalObjectsIds();
                    int n = ((int[])object).length;
                    int n2 = 0;
                    while (n2 < n) {
                        int l = object[n2];
                        if (!foundLocals) {
                            int dom;
                            if (this.snapshot.getRetainedHeapSize(l) > significantLocal && ((dom = this.snapshot.getImmediateDominatorId(l)) == threadId || dom >= 0 && this.snapshot.getImmediateDominatorId(dom) == threadId)) {
                                locals.add(l);
                                frameLocals.add(l);
                                involved = true;
                            }
                        } else if (locals.contains(l)) {
                            frameLocals.add(l);
                            involved = true;
                        }
                        ++n2;
                    }
                    if (!involved && !foundLocals) {
                        SetInt dominated = new SetInt();
                        int[] dom = frame.getLocalObjectsIds();
                        int n3 = dom.length;
                        n = 0;
                        while (n < n3) {
                            int l = dom[n];
                            int dom2 = this.snapshot.getImmediateDominatorId(l);
                            if (dom2 == threadId || dom2 >= 0 && this.snapshot.getImmediateDominatorId(dom2) == threadId) {
                                dominated.add(l);
                            }
                            ++n;
                        }
                        int[] doms = dominated.toArray();
                        long domsize = this.snapshot.getMinRetainedSize(doms, listener);
                        if (domsize > significantFrame) {
                            int[] doms1 = doms;
                            long significantFrame1 = (long)(0.8 * (double)domsize);
                            do {
                                doms = doms1;
                                long dombest = 0L;
                                doms1 = null;
                                int i = 0;
                                while (i < doms.length) {
                                    int[] doms2 = new int[doms.length - 1];
                                    int j = 0;
                                    while (j < doms2.length) {
                                        doms2[j] = doms[j >= i ? j + 1 : j];
                                        ++j;
                                    }
                                    long domsize1 = this.snapshot.getMinRetainedSize(doms2, listener);
                                    if (domsize1 > dombest && domsize1 > significantFrame1) {
                                        doms1 = doms2;
                                        dombest = domsize1;
                                    }
                                    ++i;
                                }
                            } while (doms1 != null);
                            int[] nArray = doms;
                            int n4 = doms.length;
                            int n5 = 0;
                            while (n5 < n4) {
                                int l = nArray[n5];
                                locals.add(l);
                                frameLocals.add(l);
                                ++n5;
                            }
                            involved = true;
                        }
                    }
                    stackBuilder.append("  ").append(frame.getText()).append("\r\n");
                    if (involved) {
                        String frameText = frame.getText();
                        String[] p = frameText.split("\\s+", 2);
                        HashMap<String, SetInt> m = new HashMap<String, SetInt>();
                        m.put(p.length > 1 ? p[1] : "", frameLocals);
                        involvedFrames.add(m);
                    }
                    ++co3;
                }
                if (involvedFrames.size() > 0) {
                    int skipped = 0;
                    skipped = 0;
                    while (skipped < involvedFrames.size()) {
                        String frameName = (String)((Map)involvedFrames.get(skipped)).keySet().iterator().next();
                        if (!this.skipPattern.matcher(frameName).matches()) break;
                        ++skipped;
                    }
                    int i = skipped;
                    while (i < involvedFrames.size()) {
                        SetInt vars = (SetInt)((Map)involvedFrames.get(i)).values().iterator().next();
                        int j = 0;
                        while (j < skipped) {
                            SetInt vars2 = (SetInt)((Map)involvedFrames.get(j)).values().iterator().next();
                            int[] m = vars.toArray();
                            int p = m.length;
                            int frameText = 0;
                            while (frameText < p) {
                                int v = m[frameText];
                                vars2.remove(v);
                                ++frameText;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    builder.append("<p>").append(Messages.LeakHunterQuery_SignificantStackFrames).append("</p><ul>");
                    i = 0;
                    while (i < involvedFrames.size()) {
                        SetInt frameLocals = (SetInt)((Map)involvedFrames.get(i)).values().iterator().next();
                        if (!frameLocals.isEmpty()) {
                            Collection<IClass> clss;
                            String frameName = (String)((Map)involvedFrames.get(i)).keySet().iterator().next();
                            String[] p = frameName.split("\\s+", 2);
                            keywords.add(p[0]);
                            String className = p[0];
                            int firstParen = className.indexOf(40);
                            int lastDot = className.lastIndexOf(46, firstParen >= 0 ? firstParen : Integer.MAX_VALUE);
                            if (lastDot > 0 && (clss = this.snapshot.getClassesByName(className = className.substring(0, lastDot), false)) != null && clss.size() == 1) {
                                involvedClassloaders.add(clss.iterator().next());
                            }
                            if (p.length > 1) {
                                int end = p[1].indexOf(40, 1);
                                if (end < 0) {
                                    end = p[1].length() - 1;
                                }
                                keywords.add(p[1].substring(1, end));
                            }
                            builder.append("<li>");
                            builder.append(HTMLUtils.escapeText((String)p[0]));
                            if (p.length > 1) {
                                builder.append(' ').append(HTMLUtils.escapeText((String)p[1]));
                            }
                            builder.append("<ul>");
                            int[] nArray = frameLocals.toArray();
                            int n = nArray.length;
                            int n6 = 0;
                            while (n6 < n) {
                                int v = nArray[n6];
                                IObject obj = this.snapshot.getObject(v);
                                builder.append("<li>").append(MessageUtil.format((String)Messages.LeakHunterQuery_Retains, (Object[])new Object[]{HTMLUtils.escapeText((String)obj.getDisplayName()), this.formatRetainedHeap(this.snapshot.getRetainedHeapSize(v), this.totalHeap)})).append("</li>");
                                ++n6;
                            }
                            builder.append("</ul>");
                            builder.append("</li>");
                        }
                        ++i;
                    }
                    builder.append("</ul>");
                }
                QuerySpec stackResult = new QuerySpec(Messages.LeakHunterQuery_ThreadStack, (IResult)new TextResult(stackBuilder.toString()));
                stackResult.setCommand("thread_details 0x" + Long.toHexString(threadObject.getObjectAddress()));
                builder.append("<p>");
                builder.append(Messages.LeakHunterQuery_StackTraceAvailable).append(" ").append(textResult.linkTo(Messages.LeakHunterQuery_SeeStackstrace, (IResult)stackResult)).append('.');
                if (!locals.isEmpty()) {
                    RefinedResultBuilder rbuilder = SnapshotQuery.lookup("thread_overview", this.snapshot).setArgument("objects", suspect.getSuspect()).refine(listener);
                    final RefinedTree rt = (RefinedTree)rbuilder.build();
                    rt.setSelectionProvider(new ISelectionProvider(){

                        public boolean isSelected(Object row) {
                            IContextObject co = rt.getContext(row);
                            if (co != null && (locals.contains(co.getObjectId()) || co.getObjectId() == threadId)) {
                                return true;
                            }
                            return this.isExpanded(row);
                        }

                        public boolean isExpanded(Object row) {
                            if (rt.getElements().contains(row)) {
                                return true;
                            }
                            for (Object r2 : rt.getChildren(row)) {
                                IContextObject co = rt.getContext(r2);
                                if (co == null || !locals.contains(co.getObjectId())) continue;
                                for (Object r3 : rt.getElements()) {
                                    if (!rt.getChildren(r3).contains(row)) continue;
                                    return true;
                                }
                            }
                            return false;
                        }
                    });
                    QuerySpec threadResult = new QuerySpec(Messages.LeakHunterQuery_ThreadStackAndLocals, (IResult)rt);
                    List lThreads = rt.getElements();
                    if (lThreads.size() >= 1 && rt.hasChildren(lThreads.get(0))) {
                        RefinedTree sel = rt;
                        List lFrames = rt.getChildren(lThreads.get(0));
                        int limit = lFrames.size();
                        object = lFrames.iterator();
                        while (object.hasNext()) {
                            Object row = object.next();
                            if (!sel.isExpanded(row)) continue;
                            limit = Math.max(limit, rt.getChildren(row).size());
                        }
                        threadResult.set("limit", String.valueOf(limit));
                    }
                    threadResult.setCommand("thread_overview 0x" + Long.toHexString(suspect.getSuspect().getObjectAddress()));
                    builder.append(" ").append(textResult.linkTo(Messages.LeakHunterQuery_SeeStackstraceVars, (IResult)threadResult)).append('.');
                }
                builder.append("</p>");
            }
            if ((contextClassloaderId = threadInfo.getContextClassLoaderId()) != 0) {
                involvedClassloaders.add((IClassLoader)this.snapshot.getObject(contextClassloaderId));
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, Messages.LeakHunterQuery_ErrorRetrievingRequestDetails, e);
        }
        return threadDetails;
    }

    private IResult findReferencePattern(FindLeaksQuery.SuspectRecordGroupOfObjects suspect, IProgressListener listener) throws SnapshotException {
        Object[] allPaths;
        MultiplePathsFromGCRootsClassRecord dummy = new MultiplePathsFromGCRootsClassRecord(null, -1, true, this.snapshot);
        Object[] objectArray = allPaths = suspect.getPathsComputer().getAllPaths(listener);
        int n = allPaths.length;
        int n2 = 0;
        while (n2 < n) {
            Object path = objectArray[n2];
            dummy.addPath((int[])path);
            ++n2;
        }
        MultiplePathsFromGCRootsClassRecord[] classRecords = dummy.nextLevel();
        int numPaths = allPaths.length;
        double factor = 0.8;
        double threshold = (double)numPaths * factor;
        ArrayList<IClass> referencePattern = new ArrayList<IClass>();
        if (classRecords.length > 0) {
            Arrays.sort(classRecords, MultiplePathsFromGCRootsClassRecord.getComparatorByNumberOfReferencedObjects());
            MultiplePathsFromGCRootsClassRecord r = classRecords[0];
            while ((double)r.getCount() > threshold) {
                threshold = (double)r.getCount() * factor;
                referencePattern.add(r.getClazz());
                classRecords = r.nextLevel();
                if (classRecords == null || classRecords.length == 0) break;
                Arrays.sort(classRecords, MultiplePathsFromGCRootsClassRecord.getComparatorByNumberOfReferencedObjects());
                r = classRecords[0];
            }
        }
        int[] expandedClasses = new int[referencePattern.size()];
        int i = 0;
        while (i < referencePattern.size()) {
            expandedClasses[i] = ((IClass)referencePattern.get(i)).getObjectId();
            ++i;
        }
        return MultiplePath2GCRootsQuery.create(this.snapshot, suspect.getPathsComputer(), expandedClasses, true, listener);
    }

    private List<CompositeResult> findCommonPathForSuspects(HashMap<Integer, List<Integer>> accPoint2ProblemNr, IProgressListener listener) throws SnapshotException {
        ArrayList<CompositeResult> result = new ArrayList<CompositeResult>(2);
        int[] objectIds = new int[accPoint2ProblemNr.size()];
        int j = 0;
        for (Integer accPointId : accPoint2ProblemNr.keySet()) {
            objectIds[j++] = accPointId;
        }
        Map<IClass, Set<String>> excludeMap = FindLeaksQuery.ExcludesConverter.convert(this.snapshot, this.excludes);
        IMultiplePathsFromGCRootsComputer comp = this.snapshot.getMultiplePathsFromGCRoots(objectIds, excludeMap);
        MultiplePathsFromGCRootsRecord[] records = comp.getPathsByGCRoot(listener);
        Arrays.sort(records, MultiplePathsFromGCRootsRecord.getComparatorByNumberOfReferencedObjects());
        MultiplePathsFromGCRootsRecord[] multiplePathsFromGCRootsRecordArray = records;
        int n = records.length;
        int n2 = 0;
        while (n2 < n) {
            int[] referencedAccumulationPoints;
            MultiplePathsFromGCRootsRecord rec = multiplePathsFromGCRootsRecordArray[n2];
            if (rec.getCount() < 2) break;
            CompositeResult composite = new CompositeResult(new IResult[0]);
            ArrayList<Integer> problemIds = new ArrayList<Integer>(4);
            int[] nArray = referencedAccumulationPoints = rec.getReferencedObjects();
            int n3 = referencedAccumulationPoints.length;
            int n4 = 0;
            while (n4 < n3) {
                int accPointId = nArray[n4];
                for (Integer problemId : accPoint2ProblemNr.get(accPointId)) {
                    problemIds.add(problemId);
                }
                ++n4;
            }
            Collections.sort(problemIds);
            StringBuilder overview = new StringBuilder(256);
            StringBuilder left = new StringBuilder();
            int k = 0;
            while (k < problemIds.size() - 1) {
                if (left.length() > 0) {
                    left.append(", ");
                }
                left.append(problemIds.get(k));
                ++k;
            }
            overview.append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_SuspectsRelated, (Object[])new Object[]{left.toString(), problemIds.get(problemIds.size() - 1)}));
            composite.addResult(Messages.LeakHunterQuery_Overview, (IResult)new TextResult(overview.toString(), true));
            MultiplePathsFromGCRootsRecord parentRecord = rec;
            ArrayIntBig commonPath = new ArrayIntBig();
            while (parentRecord.getCount() == rec.getCount()) {
                commonPath.add(parentRecord.getObjectId());
                MultiplePathsFromGCRootsRecord[] children = parentRecord.nextLevel();
                if (children == null || children.length == 0) break;
                Arrays.sort(children, MultiplePathsFromGCRootsRecord.getComparatorByNumberOfReferencedObjects());
                parentRecord = children[0];
            }
            IMultiplePathsFromGCRootsComputer comp2 = this.snapshot.getMultiplePathsFromGCRoots(referencedAccumulationPoints, excludeMap);
            QuerySpec qs = new QuerySpec(Messages.LeakHunterQuery_CommonPath, (IResult)MultiplePath2GCRootsQuery.create(this.snapshot, comp2, commonPath.toArray(), listener));
            StringBuilder sb = new StringBuilder("merge_shortest_paths");
            int[] nArray2 = referencedAccumulationPoints;
            int n5 = referencedAccumulationPoints.length;
            int n6 = 0;
            while (n6 < n5) {
                int objId = nArray2[n6];
                long addr = this.snapshot.mapIdToAddress(objId);
                sb.append(" 0x").append(Long.toHexString(addr));
                ++n6;
            }
            this.addExcludes(sb);
            sb.append(" -groupby FROM_GC_ROOTS");
            qs.setCommand(sb.toString());
            composite.addResult((IResult)qs);
            result.add(composite);
            ++n2;
        }
        return result;
    }

    private int findReferrer(int objectId) throws SnapshotException {
        int n;
        BitField skipped = new BitField(this.snapshot.getSnapshotInfo().getNumberOfObjects());
        Collection<IClass> classes = this.snapshot.getClassesByName(this.skipPattern, false);
        for (IClass clazz : classes) {
            int[] nArray = clazz.getObjectIds();
            n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int instance = nArray[n2];
                skipped.set(instance);
                ++n2;
            }
        }
        BitField visited = new BitField(this.snapshot.getSnapshotInfo().getNumberOfObjects());
        LinkedList<int[]> fifo = new LinkedList<int[]>();
        fifo.add(new int[]{objectId});
        while (fifo.size() > 0) {
            int[] e;
            int[] nArray = e = (int[])fifo.removeFirst();
            int n3 = e.length;
            n = 0;
            while (n < n3) {
                int referrer = nArray[n];
                if (!visited.get(referrer)) {
                    if (skipped.get(referrer) && !this.isThread(referrer)) {
                        int[] referrers = this.snapshot.getInboundRefererIds(referrer);
                        fifo.add(referrers);
                        visited.set(referrer);
                    } else {
                        return referrer;
                    }
                }
                ++n;
            }
        }
        return -1;
    }
}

