/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.diagnostics.actions;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.internal.diagnostics.DiagnosticsAction;
import org.eclipse.mat.ui.internal.diagnostics.DiagnosticsProgress;
import org.eclipse.mat.util.MessageUtil;

public class HotSpotJVMHeapDump
implements DiagnosticsAction {
    @Override
    public void run(DiagnosticsProgress progress) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
            String fileName = "matdump_" + sdf.format(new Date()) + ".hprof";
            Class<?> dumpcls = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            Object beanProxy = ManagementFactory.newPlatformMXBeanProxy(ManagementFactory.getPlatformMBeanServer(), "com.sun.management:type=HotSpotDiagnostic", dumpcls);
            Method m = dumpcls.getMethod("dumpHeap", String.class, Boolean.TYPE);
            m.invoke(beanProxy, fileName, false);
            progress.appendText(MessageUtil.format((String)Messages.DiagnosticsAction_Dump_Completed, (Object[])new Object[]{new File(fileName).getAbsolutePath()}));
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            progress.handleException(e);
        }
    }
}

