/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import java.net.URL;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.snapshot.Histogram;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.Icons;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.SimpleMonitor;

@CommandName(value="histogram")
@Icon(value="/META-INF/icons/show_histogram.gif")
@HelpUrl(value="/org.eclipse.mat.ui.help/reference/querymatrix.html#ref_querymatrix__histogram")
public class HistogramQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none", isMandatory=false)
    public IHeapObjectArgument objects;
    @Argument(isMandatory=false)
    public Grouping groupBy = Grouping.BY_CLASS;

    public IResult execute(IProgressListener listener) throws Exception {
        Histogram histogram;
        if (this.objects == null) {
            histogram = this.snapshot.getHistogram(listener);
        } else {
            SimpleMonitor monitor = new SimpleMonitor(MessageUtil.format((String)Messages.HistogramQuery_ProgressName, (Object[])new Object[]{this.objects.getLabel()}), listener, new int[]{100, 200});
            histogram = this.snapshot.getHistogram(this.objects.getIds(monitor.nextMonitor()), monitor.nextMonitor());
        }
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        if (this.objects != null) {
            histogram.setLabel(MessageUtil.format((String)Messages.HistogramQuery_HistogramOf, (Object[])new Object[]{this.objects.getLabel()}));
        }
        listener.done();
        switch (this.groupBy) {
            case BY_CLASS: {
                return histogram;
            }
            case BY_SUPERCLASS: {
                return histogram.groupBySuperclass(this.snapshot);
            }
            case BY_CLASSLOADER: {
                return histogram.groupByClassLoader();
            }
            case BY_PACKAGE: {
                return histogram.groupByPackage();
            }
        }
        throw new RuntimeException(MessageUtil.format((String)Messages.HistogramQuery_IllegalArgument, (Object[])new Object[]{this.groupBy}));
    }

    public static enum Grouping {
        BY_CLASS(Messages.HistogramQuery_GroupByClass, Icons.CLASS),
        BY_SUPERCLASS(Messages.HistogramQuery_GroupBySuperclass, Icons.SUPERCLASS),
        BY_CLASSLOADER(Messages.HistogramQuery_GroupByClassLoader, Icons.CLASSLOADER_INSTANCE),
        BY_PACKAGE(Messages.HistogramQuery_GroupByPackage, Icons.PACKAGE);

        String label;
        URL icon;

        private Grouping(String label, URL icon) {
            this.label = label;
            this.icon = icon;
        }

        public URL getIcon() {
            return this.icon;
        }

        public String toString() {
            return this.label;
        }
    }
}

