/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.bulkhead;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.awaitility.Awaitility;
import org.eclipse.microprofile.fault.tolerance.tck.asynchronous.CompletableFutureHelper;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead10ClassAsynchronousBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead10MethodAsynchronousBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead3ClassAsynchronousBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead3MethodAsynchronousBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadClassAsynchronousDefaultBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadClassAsynchronousQueueingBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadCompletionStageBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadMethodAsynchronousDefaultBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadMethodAsynchronousQueueingBean;
import org.eclipse.microprofile.fault.tolerance.tck.util.AsyncTaskManager;
import org.eclipse.microprofile.fault.tolerance.tck.util.Barrier;
import org.eclipse.microprofile.fault.tolerance.tck.util.Exceptions;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.eclipse.microprofile.fault.tolerance.tck.util.TCKConfig;
import org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BulkheadAsynchTest
extends Arquillian {
    @Inject
    private BulkheadClassAsynchronousDefaultBean bhBeanClassAsynchronousDefault;
    @Inject
    private BulkheadMethodAsynchronousDefaultBean bhBeanMethodAsynchronousDefault;
    @Inject
    private Bulkhead3ClassAsynchronousBean bhBeanClassAsynchronous3;
    @Inject
    private Bulkhead3MethodAsynchronousBean bhBeanMethodAsynchronous3;
    @Inject
    private Bulkhead10ClassAsynchronousBean bhBeanClassAsynchronous10;
    @Inject
    private Bulkhead10MethodAsynchronousBean bhBeanMethodAsynchronous10;
    @Inject
    private BulkheadClassAsynchronousQueueingBean bhBeanClassAsynchronousQueueing;
    @Inject
    private BulkheadMethodAsynchronousQueueingBean bhBeanMethodAsynchronousQueueing;
    @Inject
    private BulkheadCompletionStageBean bhBeanCompletionStage;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftBulkheadAsynchTest.jar")).addPackage(BulkheadClassAsynchronousDefaultBean.class.getPackage())).addClass(CompletableFutureHelper.class)).addPackage(Packages.UTILS)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftBulkheadAsynchTest.war")).addAsLibrary((Archive)testJar);
    }

    @Test
    public void testBulkheadClassAsynchronous10() {
        BulkheadAsynchTest.testBulkhead(10, 10, this.bhBeanClassAsynchronous10::test);
    }

    @Test
    public void testBulkheadMethodAsynchronous10() {
        BulkheadAsynchTest.testBulkhead(10, 10, this.bhBeanMethodAsynchronous10::test);
    }

    @Test
    public void testBulkheadClassAsynchronous3() {
        BulkheadAsynchTest.testBulkhead(3, 10, this.bhBeanClassAsynchronous3::test);
    }

    @Test
    public void testBulkheadMethodAsynchronous3() {
        BulkheadAsynchTest.testBulkhead(3, 10, this.bhBeanMethodAsynchronous3::test);
    }

    @Test
    public void testBulkheadClassAsynchronousDefault() {
        BulkheadAsynchTest.testBulkhead(10, 10, this.bhBeanClassAsynchronousDefault::test);
    }

    @Test
    public void testBulkheadMethodAsynchronousDefault() {
        BulkheadAsynchTest.testBulkhead(10, 10, this.bhBeanMethodAsynchronousDefault::test);
    }

    @Test
    public void testBulkheadClassAsynchronousQueueing5() {
        BulkheadAsynchTest.testBulkhead(5, 5, this.bhBeanClassAsynchronousQueueing::test);
    }

    @Test
    public void testBulkheadMethodAsynchronousQueueing5() {
        BulkheadAsynchTest.testBulkhead(5, 5, this.bhBeanMethodAsynchronousQueueing::test);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBulkheadCompletionStage() throws InterruptedException, ExecutionException, TimeoutException {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        try {
            CompletableFuture<Void> future1 = CompletableFutureHelper.toCompletableFuture(this.bhBeanCompletionStage.serviceCS(result));
            CompletableFuture<Void> future2 = CompletableFutureHelper.toCompletableFuture(this.bhBeanCompletionStage.serviceCS(result));
            Thread.sleep(TCKConfig.getConfig().getTimeoutInMillis(200L));
            CompletableFuture<Void> future3 = CompletableFutureHelper.toCompletableFuture(this.bhBeanCompletionStage.serviceCS(result));
            CompletableFuture<Void> future4 = CompletableFutureHelper.toCompletableFuture(this.bhBeanCompletionStage.serviceCS(result));
            Thread.sleep(TCKConfig.getConfig().getTimeoutInMillis(200L));
            CompletableFuture<Void> future5 = CompletableFutureHelper.toCompletableFuture(this.bhBeanCompletionStage.serviceCS(result));
            Assert.assertFalse((boolean)future1.isDone(), (String)"Future1 reported done");
            Assert.assertFalse((boolean)future2.isDone(), (String)"Future2 reported done");
            Exceptions.expectBulkheadException(future5);
            result.complete(null);
            future1.get(TCKConfig.getConfig().getTimeoutInMillis(1000L), TimeUnit.MILLISECONDS);
            future2.get(TCKConfig.getConfig().getTimeoutInMillis(1000L), TimeUnit.MILLISECONDS);
            future3.get(TCKConfig.getConfig().getTimeoutInMillis(1000L), TimeUnit.MILLISECONDS);
            future4.get(TCKConfig.getConfig().getTimeoutInMillis(1000L), TimeUnit.MILLISECONDS);
        }
        finally {
            result.complete(null);
        }
    }

    public static void testBulkhead(int maxRunning, int maxQueued, Function<Barrier, Future<?>> bulkheadMethod) {
        try (AsyncTaskManager taskManager = new AsyncTaskManager();){
            int i;
            ArrayList runningTasks = new ArrayList();
            for (i = 0; i < maxRunning; ++i) {
                AsyncTaskManager.BarrierTask task = taskManager.runAsyncBarrierTask(bulkheadMethod);
                runningTasks.add(task);
            }
            for (i = 0; i < maxRunning; ++i) {
                ((AsyncTaskManager.BarrierTask)runningTasks.get(i)).assertAwaits();
            }
            ArrayList queuedTasks = new ArrayList();
            for (int i2 = 0; i2 < maxQueued; ++i2) {
                AsyncTaskManager.BarrierTask task = taskManager.runAsyncBarrierTask(bulkheadMethod);
                queuedTasks.add(task);
            }
            AsyncTaskManager.assertAllNotAwaiting(queuedTasks);
            AsyncTaskManager.BarrierTask overflowTask = taskManager.runAsyncBarrierTask(bulkheadMethod);
            overflowTask.assertThrows(BulkheadException.class);
            AsyncTaskManager.BarrierTask releasedTask = (AsyncTaskManager.BarrierTask)runningTasks.get(7 % maxRunning);
            releasedTask.openBarrier();
            releasedTask.assertSuccess();
            Awaitility.await().until(() -> queuedTasks.stream().filter(task -> task.isAwaiting()).count() == 1L);
            AsyncTaskManager.BarrierTask extraTask = taskManager.runAsyncBarrierTask(bulkheadMethod);
            extraTask.assertNotAwaiting();
            AsyncTaskManager.BarrierTask overflowTask2 = taskManager.runAsyncBarrierTask(bulkheadMethod);
            overflowTask2.assertThrows(BulkheadException.class);
        }
    }
}

