/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.telemetry.metrics.tck.jvm;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.input.Tailer;
import org.apache.commons.io.input.TailerListener;
import org.apache.commons.io.input.TailerListenerAdapter;
import org.awaitility.Awaitility;
import org.testng.Assert;

public class MetricsReader {
    private static final String logFilePath = System.getProperty("mptelemetry.tck.log.file.path");

    public static void assertLogMessage(String metricName, String metricDescription, String metricUnit, String metricType) {
        Tailer tailer;
        String searchString = "name=" + metricName + ", description=" + metricDescription + ", unit=" + metricUnit + ", type=" + metricType;
        ExecutorService es = Executors.newFixedThreadPool(1);
        LogFileTailerAdaptor logFileTailerAdaptor = new LogFileTailerAdaptor(searchString);
        try (Tailer tailer2 = tailer = ((Tailer.Builder)Tailer.builder().setStartThread(true).setPath(logFilePath)).setExecutorService(es).setReOpen(false).setTailerListener((TailerListener)logFileTailerAdaptor).setTailFromEnd(false).get();){
            Awaitility.await().atMost(15L, TimeUnit.SECONDS).untilAsserted(() -> Assert.assertTrue((boolean)logFileTailerAdaptor.foundMetric(), (String)("Did not find " + searchString + " in logfile: " + logFilePath)));
        }
    }

    public static void assertLogMessagePattern(String searchPattern) {
        Tailer tailer;
        ExecutorService es = Executors.newFixedThreadPool(1);
        LogFileTailerMatcherAdaptor logFileTailerAdaptor = new LogFileTailerMatcherAdaptor(searchPattern);
        try (Tailer tailer2 = tailer = ((Tailer.Builder)Tailer.builder().setStartThread(true).setPath(logFilePath)).setExecutorService(es).setReOpen(false).setTailerListener((TailerListener)logFileTailerAdaptor).setTailFromEnd(false).get();){
            Awaitility.await().atMost(15L, TimeUnit.SECONDS).untilAsserted(() -> Assert.assertTrue((boolean)logFileTailerAdaptor.foundMetric(), (String)("Did not find " + searchPattern + " in logfile: " + logFilePath)));
        }
    }

    private static class LogFileTailerAdaptor
    extends TailerListenerAdapter {
        private final String searchString;
        private boolean foundMetric = false;
        private Tailer tailer = null;

        public LogFileTailerAdaptor(String searchString) {
            this.searchString = searchString;
        }

        public void init(Tailer tailer) {
            this.tailer = tailer;
        }

        public void handle(String line) {
            if (line.contains(this.searchString)) {
                this.foundMetric = true;
                this.tailer.close();
            }
        }

        public boolean foundMetric() {
            return this.foundMetric;
        }
    }

    private static class LogFileTailerMatcherAdaptor
    extends TailerListenerAdapter {
        private final Pattern pattern;
        private boolean foundMetric = false;
        private Tailer tailer = null;

        public LogFileTailerMatcherAdaptor(String searchString) {
            this.pattern = Pattern.compile(searchString);
        }

        public void init(Tailer tailer) {
            this.tailer = tailer;
        }

        public void handle(String line) {
            Matcher matcher = this.pattern.matcher(line);
            if (matcher.find()) {
                this.foundMetric = true;
                this.tailer.close();
            }
        }

        public boolean foundMetric() {
            return this.foundMetric;
        }
    }
}

