/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.stdlib;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QVTOEnvironment;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstance;
import org.eclipse.m2m.internal.qvt.oml.stdlib.AbstractContextualOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.AbstractQVTStdlib;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandler;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandlerAdapter;
import org.eclipse.m2m.qvt.oml.util.MutableList;
import org.eclipse.m2m.qvt.oml.util.Utils;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.util.CollectionUtil;
import org.eclipse.ocl.util.TypeUtil;

public class SetTypeOperations
extends AbstractContextualOperations {
    static final CallHandler UNION = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof Collection && args.length > 0 && args[0] instanceof Collection) {
                MutableList result = CollectionUtil.union((Collection)((Collection)source), (Collection)((Collection)args[0]));
                if (source instanceof MutableList && !(result instanceof MutableList)) {
                    result = Utils.createList(result);
                }
                return result;
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    static final CallHandler INTERSECTION = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof Collection && args.length > 0 && args[0] instanceof Collection) {
                return CollectionUtil.intersection((Collection)((Collection)source), (Collection)((Collection)args[0]));
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    private static final CallHandler MINUS = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof Set && args.length > 0 && args[0] instanceof Set) {
                return CollectionUtil.minus((Set)((Set)source), (Set)((Set)args[0]));
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    static final CallHandler INCLUDING = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof Collection && args.length > 0) {
                if (args[0] == CallHandlerAdapter.getInvalidResult(evalEnv)) {
                    return CallHandlerAdapter.getInvalidResult(evalEnv);
                }
                if (source instanceof LinkedHashSet) {
                    source = CollectionUtil.createNewSet((Collection)((Collection)source));
                }
                MutableList result = CollectionUtil.including((Collection)((Collection)source), (Object)args[0]);
                if (source instanceof MutableList && !(result instanceof MutableList)) {
                    result = Utils.createList(result);
                }
                return result;
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    static final CallHandler EXCLUDING = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof Collection && args.length > 0) {
                if (args[0] == CallHandlerAdapter.getInvalidResult(evalEnv)) {
                    return CallHandlerAdapter.getInvalidResult(evalEnv);
                }
                if (source instanceof LinkedHashSet) {
                    source = CollectionUtil.createNewSet((Collection)((Collection)source));
                }
                MutableList result = CollectionUtil.excluding((Collection)((Collection)source), (Object)args[0]);
                if (source instanceof MutableList && !(result instanceof MutableList)) {
                    result = Utils.createList(result);
                }
                return result;
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    private static final CallHandler SYMMETRIC_DIFFERENCE = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof Set && args.length > 0 && args[0] instanceof Set) {
                return CollectionUtil.symmetricDifference((Set)((Set)source), (Set)((Set)args[0]));
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };

    private SetTypeOperations(AbstractQVTStdlib library, EClassifier contextType) {
        super(library, contextType);
    }

    public static AbstractContextualOperations[] getAllOperations(AbstractQVTStdlib library) {
        QVTOEnvironment environment = library.getEnvironment();
        return new AbstractContextualOperations[]{new SetTypeOperations(library, (EClassifier)environment.getOCLStandardLibrary().getSet())};
    }

    protected AbstractContextualOperations.OperationProvider[] getOperations() {
        OCLStandardLibrary oclStdlib = this.getStdlib().getEnvironment().getOCLStandardLibrary();
        EClassifier setOfT2 = (EClassifier)TypeUtil.resolveSetType((Environment)this.getStdlib().getEnvironment(), (Object)((EClassifier)oclStdlib.getT2()));
        EClassifier bagOfT2 = (EClassifier)TypeUtil.resolveBagType((Environment)this.getStdlib().getEnvironment(), (Object)((EClassifier)oclStdlib.getT2()));
        EClassifier setOfCommonT = (EClassifier)TypeUtil.resolveSetType((Environment)this.getStdlib().getEnvironment(), (Object)this.getStdlib().getCommonT());
        EClassifier bagOfCommonT = (EClassifier)TypeUtil.resolveBagType((Environment)this.getStdlib().getEnvironment(), (Object)this.getStdlib().getCommonT());
        return new AbstractContextualOperations.OperationProvider[]{(AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(UNION, "union", new String[]{"set"}, setOfCommonT, setOfT2), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(UNION, "union", new String[]{"bag"}, bagOfCommonT, bagOfT2), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(INTERSECTION, "intersection", new String[]{"set"}, (EClassifier)oclStdlib.getSet(), setOfT2), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(INTERSECTION, "intersection", new String[]{"bag"}, (EClassifier)oclStdlib.getSet(), bagOfT2), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(MINUS, "-", new String[]{"set"}, (EClassifier)oclStdlib.getSet(), setOfT2), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(INCLUDING, "including", new String[]{"object"}, setOfCommonT, (EClassifier)oclStdlib.getT2()), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(EXCLUDING, "excluding", new String[]{"object"}, (EClassifier)oclStdlib.getSet(), (EClassifier)oclStdlib.getT2()), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(SYMMETRIC_DIFFERENCE, "symmetricDifference", new String[]{"set"}, setOfCommonT, setOfT2)};
    }
}

