/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.annotations.xml;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.emf.teneo.annotations.StoreAnnotationsException;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlElementToEStructuralFeatureMapper
implements ExtensionPoint {
    private Map<String, String> eStructuralFeatureNamesByXmlElementName = new HashMap<String, String>();
    private String xmlElementName;
    private boolean appInfoValue;

    public void parseSchema(InputStream schema) {
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setNamespaceAware(true);
            SAXParser saxParser = saxParserFactory.newSAXParser();
            saxParser.parse(this.getClass().getResourceAsStream("persistence-mapping.xsd"), (DefaultHandler)new XmlContentHandler());
        }
        catch (Exception e) {
            throw new StoreAnnotationsException("Exception while parsing xsd", e);
        }
    }

    public String getEStructuralFeatureName(String xmlElementName) {
        return this.eStructuralFeatureNamesByXmlElementName.get(xmlElementName);
    }

    public class XmlContentHandler
    extends DefaultHandler {
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (localName.equals("attribute") || localName.equals("element")) {
                XmlElementToEStructuralFeatureMapper.this.xmlElementName = attributes.getValue("name");
            } else if (localName.equals("appinfo") && "teneo/internal/EStructuralFeatureName".equals(attributes.getValue("source"))) {
                XmlElementToEStructuralFeatureMapper.this.appInfoValue = true;
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            String eStructuralFeatureName;
            if (XmlElementToEStructuralFeatureMapper.this.appInfoValue && XmlElementToEStructuralFeatureMapper.this.xmlElementName != null && (eStructuralFeatureName = new String(ch, start, length).trim()).length() > 0 && !XmlElementToEStructuralFeatureMapper.this.eStructuralFeatureNamesByXmlElementName.containsKey(XmlElementToEStructuralFeatureMapper.this.xmlElementName)) {
                XmlElementToEStructuralFeatureMapper.this.eStructuralFeatureNamesByXmlElementName.put(XmlElementToEStructuralFeatureMapper.this.xmlElementName, eStructuralFeatureName);
                XmlElementToEStructuralFeatureMapper.this.appInfoValue = false;
                XmlElementToEStructuralFeatureMapper.this.xmlElementName = null;
            }
        }
    }
}

