/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.samples.issues.library;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.teneo.samples.issues.library.Book;
import org.eclipse.emf.teneo.samples.issues.library.BookCategory;
import org.eclipse.emf.teneo.samples.issues.library.Library;
import org.eclipse.emf.teneo.samples.issues.library.LibraryFactory;
import org.eclipse.emf.teneo.samples.issues.library.Writer;

public class LibraryPackage
extends EPackageImpl {
    public static final String eNAME = "library";
    public static final String eNS_URI = "http://www.eclipse.org/emf/teneo/samples/issues/supinterfaces";
    public static final String eNS_PREFIX = "library";
    public static final LibraryPackage eINSTANCE = LibraryPackage.init();
    public static final int BOOK = 0;
    public static final int BOOK__TITLE = 0;
    public static final int BOOK__PAGES = 1;
    public static final int BOOK__CATEGORY = 2;
    public static final int BOOK__AUTHOR = 3;
    public static final int BOOK_FEATURE_COUNT = 4;
    public static final int LIBRARY = 1;
    public static final int LIBRARY__NAME = 0;
    public static final int LIBRARY__WRITERS = 1;
    public static final int LIBRARY__BOOKS = 2;
    public static final int LIBRARY_FEATURE_COUNT = 3;
    public static final int WRITER = 2;
    public static final int WRITER__NAME = 0;
    public static final int WRITER__BOOKS = 1;
    public static final int WRITER_FEATURE_COUNT = 2;
    public static final int BOOK_CATEGORY = 3;
    public static final int BOOK_CATEGORY_OBJECT = 4;
    private EClass bookEClass = null;
    private EClass libraryEClass = null;
    private EClass writerEClass = null;
    private EEnum bookCategoryEEnum = null;
    private EDataType bookCategoryObjectEDataType = null;
    private static boolean isInited = false;
    private boolean isCreated = false;
    private boolean isInitialized = false;

    private LibraryPackage() {
        super(eNS_URI, (EFactory)LibraryFactory.eINSTANCE);
    }

    public static LibraryPackage init() {
        if (isInited) {
            return (LibraryPackage)EPackage.Registry.INSTANCE.getEPackage(eNS_URI);
        }
        LibraryPackage theLibraryPackage = EPackage.Registry.INSTANCE.getEPackage(eNS_URI) instanceof LibraryPackage ? EPackage.Registry.INSTANCE.getEPackage(eNS_URI) : new LibraryPackage();
        isInited = true;
        XMLTypePackage.eINSTANCE.eClass();
        theLibraryPackage.createPackageContents();
        theLibraryPackage.initializePackageContents();
        theLibraryPackage.freeze();
        return theLibraryPackage;
    }

    public EClass getBook() {
        return this.bookEClass;
    }

    public EAttribute getBook_Title() {
        return (EAttribute)this.bookEClass.getEStructuralFeatures().get(0);
    }

    public EAttribute getBook_Pages() {
        return (EAttribute)this.bookEClass.getEStructuralFeatures().get(1);
    }

    public EAttribute getBook_Category() {
        return (EAttribute)this.bookEClass.getEStructuralFeatures().get(2);
    }

    public EReference getBook_Author() {
        return (EReference)this.bookEClass.getEStructuralFeatures().get(3);
    }

    public EClass getLibrary() {
        return this.libraryEClass;
    }

    public EAttribute getLibrary_Name() {
        return (EAttribute)this.libraryEClass.getEStructuralFeatures().get(0);
    }

    public EReference getLibrary_Writers() {
        return (EReference)this.libraryEClass.getEStructuralFeatures().get(1);
    }

    public EReference getLibrary_Books() {
        return (EReference)this.libraryEClass.getEStructuralFeatures().get(2);
    }

    public EClass getWriter() {
        return this.writerEClass;
    }

    public EAttribute getWriter_Name() {
        return (EAttribute)this.writerEClass.getEStructuralFeatures().get(0);
    }

    public EReference getWriter_Books() {
        return (EReference)this.writerEClass.getEStructuralFeatures().get(1);
    }

    public EEnum getBookCategory() {
        return this.bookCategoryEEnum;
    }

    public EDataType getBookCategoryObject() {
        return this.bookCategoryObjectEDataType;
    }

    public LibraryFactory getLibraryFactory() {
        return (LibraryFactory)this.getEFactoryInstance();
    }

    public void createPackageContents() {
        if (this.isCreated) {
            return;
        }
        this.isCreated = true;
        this.bookEClass = this.createEClass(0);
        this.createEAttribute(this.bookEClass, 0);
        this.createEAttribute(this.bookEClass, 1);
        this.createEAttribute(this.bookEClass, 2);
        this.createEReference(this.bookEClass, 3);
        this.libraryEClass = this.createEClass(1);
        this.createEAttribute(this.libraryEClass, 0);
        this.createEReference(this.libraryEClass, 1);
        this.createEReference(this.libraryEClass, 2);
        this.writerEClass = this.createEClass(2);
        this.createEAttribute(this.writerEClass, 0);
        this.createEReference(this.writerEClass, 1);
        this.bookCategoryEEnum = this.createEEnum(3);
        this.bookCategoryObjectEDataType = this.createEDataType(4);
    }

    public void initializePackageContents() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        this.setName("library");
        this.setNsPrefix("library");
        this.setNsURI(eNS_URI);
        XMLTypePackage theXMLTypePackage = (XMLTypePackage)EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/emf/2003/XMLType");
        this.initEClass(this.bookEClass, Book.class, "Book", false, false, true);
        this.initEAttribute(this.getBook_Title(), (EClassifier)theXMLTypePackage.getString(), "title", null, 1, 1, Book.class, false, false, true, false, false, false, false, true);
        this.initEAttribute(this.getBook_Pages(), (EClassifier)theXMLTypePackage.getInt(), "pages", null, 1, 1, Book.class, false, false, true, true, false, false, false, true);
        this.initEAttribute(this.getBook_Category(), (EClassifier)this.getBookCategory(), "category", "Mystery", 1, 1, Book.class, false, false, true, true, false, false, false, true);
        this.initEReference(this.getBook_Author(), (EClassifier)this.getWriter(), this.getWriter_Books(), "author", null, 1, 1, Book.class, false, false, true, false, true, false, true, false, true);
        this.initEClass(this.libraryEClass, Library.class, "Library", false, false, true);
        this.initEAttribute(this.getLibrary_Name(), (EClassifier)theXMLTypePackage.getString(), "name", null, 1, 1, Library.class, false, false, true, false, false, false, false, true);
        this.initEReference(this.getLibrary_Writers(), (EClassifier)this.getWriter(), null, "writers", null, 0, -1, Library.class, false, false, true, true, false, false, true, false, true);
        this.initEReference(this.getLibrary_Books(), (EClassifier)this.getBook(), null, "books", null, 0, -1, Library.class, false, false, true, true, false, false, true, false, true);
        this.initEClass(this.writerEClass, Writer.class, "Writer", false, false, true);
        this.initEAttribute(this.getWriter_Name(), (EClassifier)theXMLTypePackage.getString(), "name", null, 1, 1, Writer.class, false, false, true, false, false, false, false, true);
        this.initEReference(this.getWriter_Books(), (EClassifier)this.getBook(), this.getBook_Author(), "books", null, 0, -1, Writer.class, false, false, true, false, true, false, true, false, true);
        this.initEEnum(this.bookCategoryEEnum, BookCategory.class, "BookCategory");
        this.addEEnumLiteral(this.bookCategoryEEnum, BookCategory.MYSTERY);
        this.addEEnumLiteral(this.bookCategoryEEnum, BookCategory.SCIENCE_FICTION);
        this.addEEnumLiteral(this.bookCategoryEEnum, BookCategory.BIOGRAPHY);
        this.initEDataType(this.bookCategoryObjectEDataType, BookCategory.class, "BookCategoryObject", true, true);
        this.createResource(eNS_URI);
        this.createExtendedMetaDataAnnotations();
        this.createTeneoAnnotations();
        this.createTeneo_1Annotations();
    }

    protected void createExtendedMetaDataAnnotations() {
        String source = "http:///org/eclipse/emf/ecore/util/ExtendedMetaData";
        this.addAnnotation((ENamedElement)this.bookEClass, source, new String[]{"name", "Book", "kind", "elementOnly"});
        this.addAnnotation((ENamedElement)this.getBook_Title(), source, new String[]{"kind", "element", "name", "title"});
        this.addAnnotation((ENamedElement)this.getBook_Pages(), source, new String[]{"kind", "element", "name", "pages"});
        this.addAnnotation((ENamedElement)this.getBook_Category(), source, new String[]{"kind", "element", "name", "category"});
        this.addAnnotation((ENamedElement)this.getBook_Author(), source, new String[]{"kind", "element", "name", "author"});
        this.addAnnotation((ENamedElement)this.bookCategoryEEnum, source, new String[]{"name", "BookCategory"});
        this.addAnnotation((ENamedElement)this.bookCategoryObjectEDataType, source, new String[]{"name", "BookCategory:Object", "baseType", "BookCategory"});
        this.addAnnotation((ENamedElement)this.libraryEClass, source, new String[]{"name", "Library", "kind", "elementOnly"});
        this.addAnnotation((ENamedElement)this.getLibrary_Name(), source, new String[]{"kind", "element", "name", "name"});
        this.addAnnotation((ENamedElement)this.getLibrary_Writers(), source, new String[]{"kind", "element", "name", "writers"});
        this.addAnnotation((ENamedElement)this.getLibrary_Books(), source, new String[]{"kind", "element", "name", "books"});
        this.addAnnotation((ENamedElement)this.writerEClass, source, new String[]{"name", "Writer", "kind", "elementOnly"});
        this.addAnnotation((ENamedElement)this.getWriter_Name(), source, new String[]{"kind", "element", "name", "name"});
        this.addAnnotation((ENamedElement)this.getWriter_Books(), source, new String[]{"kind", "element", "name", "books"});
    }

    protected void createTeneoAnnotations() {
        String source = "teneo.jpa";
        this.addAnnotation((ENamedElement)this.getBook_Category(), source, new String[]{"appinfo", "@Enumerated(ORDINAL)"});
    }

    protected void createTeneo_1Annotations() {
        String source = "teneo.hibernate";
        this.addAnnotation((ENamedElement)this.getLibrary_Writers(), source, new String[]{"appinfo", "@Fetch(SUBSELECT)\n@ForeignKey(name=\"schrijvers\")"});
    }

    public static interface Literals {
        public static final EClass BOOK = eINSTANCE.getBook();
        public static final EAttribute BOOK__TITLE = eINSTANCE.getBook_Title();
        public static final EAttribute BOOK__PAGES = eINSTANCE.getBook_Pages();
        public static final EAttribute BOOK__CATEGORY = eINSTANCE.getBook_Category();
        public static final EReference BOOK__AUTHOR = eINSTANCE.getBook_Author();
        public static final EClass LIBRARY = eINSTANCE.getLibrary();
        public static final EAttribute LIBRARY__NAME = eINSTANCE.getLibrary_Name();
        public static final EReference LIBRARY__WRITERS = eINSTANCE.getLibrary_Writers();
        public static final EReference LIBRARY__BOOKS = eINSTANCE.getLibrary_Books();
        public static final EClass WRITER = eINSTANCE.getWriter();
        public static final EAttribute WRITER__NAME = eINSTANCE.getWriter_Name();
        public static final EReference WRITER__BOOKS = eINSTANCE.getWriter_Books();
        public static final EEnum BOOK_CATEGORY = eINSTANCE.getBookCategory();
        public static final EDataType BOOK_CATEGORY_OBJECT = eINSTANCE.getBookCategoryObject();
    }
}

