/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.ecore;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.teneo.ERuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EModelResolver {
    private static EModelResolver instance = null;

    public static EModelResolver instance() {
        if (instance == null) {
            instance = ERuntime.INSTANCE;
        }
        return instance;
    }

    public static void setInstance(EModelResolver modelResolver) {
        instance = modelResolver;
    }

    public abstract void clear();

    public abstract EClass getEClass(Class<?> var1);

    public abstract boolean isRegistered(EPackage var1);

    public abstract void register(EPackage[] var1);

    public abstract List<Class<?>> getAllClassesAndInterfaces();

    public abstract Class<?> getJavaClass(EClassifier var1);

    public abstract Class<?> getJavaInterfaceClass(EClass var1);

    public abstract boolean hasImplementationClass(EClassifier var1);

    public abstract EPackage[] getEPackages();

    public abstract Object create(EClass var1);

    public Object create(EPackage epackage, String eclassName) {
        EClass eclass = (EClass)epackage.getEClassifier(eclassName);
        if (eclass == null) {
            throw new IllegalArgumentException("No EClass " + eclassName + " found in epackage " + epackage.getName());
        }
        return this.create(eclass);
    }

    public Object create(String eclassName) {
        EPackage[] ePackageArray = this.getEPackages();
        int n = ePackageArray.length;
        int n2 = 0;
        while (n2 < n) {
            EPackage epackage = ePackageArray[n2];
            EClass eclass = (EClass)epackage.getEClassifier(eclassName);
            if (eclass != null) {
                return this.create(eclass);
            }
            ++n2;
        }
        throw new IllegalArgumentException("No EClass " + eclassName + " found.");
    }
}

