/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapping.elist;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.hibernate.SessionWrapper;
import org.eclipse.emf.teneo.hibernate.resource.HbResource;
import org.eclipse.emf.teneo.mapping.elist.MapPersistableEMap;
import org.eclipse.emf.teneo.resource.StoreResource;
import org.hibernate.Session;
import org.hibernate.collection.AbstractPersistentCollection;
import org.hibernate.collection.PersistentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapHibernatePersistableEMap<K, V>
extends MapPersistableEMap<K, V>
implements ExtensionPoint {
    private static final long serialVersionUID = -4553160393592497834L;
    private static Log log = LogFactory.getLog(MapHibernatePersistableEMap.class);

    public MapHibernatePersistableEMap(InternalEObject owner, EReference eref, Map<K, V> map) {
        super(eref.getEReferenceType(), owner, (EStructuralFeature)eref, map);
    }

    public MapHibernatePersistableEMap(InternalEObject owner, EReference eref, List<BasicEMap.Entry<K, V>> list) {
        super(eref.getEReferenceType(), owner, (EStructuralFeature)eref, list);
    }

    public boolean isInitialized() {
        return this.isORMMapDelegateLoaded();
    }

    public boolean isLoaded() {
        if (this.ormMapDelegate == null) {
            return true;
        }
        if (!super.isLoaded() && !this.isLoading() && this.isORMMapDelegateLoaded()) {
            log.debug((Object)("Persistentlist already initialized, probably eagerly loaded: " + this.getLogString()));
            try {
                this.setLoading(true);
                this.doLoad();
                this.setLoading(true);
            }
            finally {
                this.setLoading(false);
            }
        }
        return super.isLoaded();
    }

    public int size() {
        if (this.size != 0) {
            return this.size;
        }
        if (!this.isMapValueIsEAttribute() && this.getORMMapDelegate() != null && !this.isORMMapDelegateLoaded() && this.getORMMapDelegate() instanceof AbstractPersistentCollection) {
            try {
                Field field = AbstractPersistentCollection.class.getDeclaredField("session");
                field.setAccessible(true);
                Session s = (Session)field.get(this.getORMMapDelegate());
                this.size = ((Long)s.createFilter((Object)this.getORMMapDelegate(), "select count(*)").list().get(0)).intValue();
                return this.size;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return super.size();
    }

    protected boolean isORMMapDelegateLoaded() {
        if (this.getORMMapDelegate() == null) {
            return false;
        }
        return this.ormMapDelegate instanceof PersistentMap && ((PersistentMap)this.ormMapDelegate).wasInitialized();
    }

    protected void doLoad() {
        SessionWrapper sessionWrapper = null;
        boolean controlsTransaction = false;
        boolean err = true;
        Resource res = null;
        Map delegate = this.getORMMapDelegate();
        try {
            res = this.getEObject().eResource();
            if (res != null && res instanceof HbResource) {
                sessionWrapper = ((HbResource)res).getSessionWrapper();
                if (res.isLoaded()) {
                    boolean isDelegateLoaded;
                    boolean bl = isDelegateLoaded = delegate instanceof AbstractPersistentCollection && ((AbstractPersistentCollection)delegate).wasInitialized();
                    if (!isDelegateLoaded && !sessionWrapper.isTransactionActive()) {
                        log.debug((Object)("Reconnecting session to read a lazy collection, elist: " + this.logString));
                        controlsTransaction = true;
                        sessionWrapper.beginTransaction();
                        sessionWrapper.setFlushModeManual();
                    } else {
                        log.debug((Object)"Delegate loaded or resource session is still active, using it");
                    }
                } else {
                    log.debug((Object)("EMap uses session from resource, " + this.logString));
                }
            } else {
                log.debug((Object)"EMap is not loaded in session context");
            }
            if (controlsTransaction) {
                assert (res instanceof HbResource);
                ((StoreResource)res).setIsLoading(true);
            }
            try {
                Iterator iterator = this.getORMMapDelegate().entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry o;
                    Map.Entry entry = o = iterator.next();
                    this.put(entry.getKey(), entry.getValue());
                }
                if (res != null && res instanceof StoreResource) {
                    for (Map.Entry o : this.entrySet()) {
                        if (!(o instanceof EObject)) continue;
                        ((StoreResource)res).addToContentOrAttach((InternalEObject)o, (EReference)this.getEStructuralFeature());
                    }
                }
                log.debug((Object)("Loaded " + delegate.size() + " from backend store for " + this.logString));
            }
            finally {
                if (controlsTransaction) {
                    ((StoreResource)res).setIsLoading(false);
                }
            }
            err = false;
        }
        finally {
            if (controlsTransaction) {
                if (err) {
                    sessionWrapper.rollbackTransaction();
                    sessionWrapper.restorePreviousFlushMode();
                } else {
                    sessionWrapper.commitTransaction();
                    sessionWrapper.restorePreviousFlushMode();
                }
                ((HbResource)res).returnSessionWrapper(sessionWrapper);
            }
        }
        log.debug((Object)("Finished loading emap " + this.logString));
    }

    public Object getDelegate() {
        return this.getORMMapDelegate();
    }
}

