/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction.tests;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.examples.extlibrary.Book;
import org.eclipse.emf.examples.extlibrary.BookCategory;
import org.eclipse.emf.examples.extlibrary.EXTLibraryFactory;
import org.eclipse.emf.examples.extlibrary.Library;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.tests.AbstractTest;
import org.eclipse.emf.transaction.tests.fixtures.TestCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformanceTest
extends AbstractTest {
    static final int RUNS = 10;
    static final int OUTLIERS = 2;
    private List<Long> timings;
    private long clock;
    private final int count = 12;
    private static Map<Object, Object> allNotifications = Collections.emptyMap();
    private static Map<Object, Object> noTriggers = Collections.singletonMap("no_triggers", Boolean.TRUE);
    private static Map<Object, Object> validationOnly = new HashMap<Object, Object>(noTriggers);
    private static Map<Object, Object> noNotifications;

    static {
        validationOnly.put("silent", Boolean.TRUE);
        noNotifications = new HashMap<Object, Object>(validationOnly);
        noNotifications.put("no_validation", Boolean.TRUE);
    }

    public PerformanceTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(PerformanceTest.class, "Performance Tests");
    }

    public void test_ReadWriteValidator_findTree_132590() {
        int i = 0;
        while (i < 12) {
            this.startClock();
            this.createDeeplyNestedTransaction(5, 10);
            long timing = this.stopClock();
            System.out.println("Raw timing: " + timing);
            ++i;
        }
    }

    public void test_loadLargishModelWithoutRecording() {
        this.addStuffToTestResourceAndClose();
        final Transaction[] originalTransaction = new Transaction[1];
        final int[] precommitEvents = new int[1];
        final int[] postcommitEvents = new int[1];
        ResourceSetListenerImpl listener = new ResourceSetListenerImpl(){

            public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
                CompoundCommand result = null;
                if (originalTransaction[0] == null) {
                    originalTransaction[0] = event.getTransaction();
                }
                if (event.getTransaction() == originalTransaction[0]) {
                    result = new CompoundCommand();
                    Iterator iter = event.getNotifications().iterator();
                    while (iter.hasNext()) {
                        iter.next();
                        precommitEvents[0] = precommitEvents[0] + 1;
                        result.append((Command)new TestCommand(){

                            public void execute() {
                            }
                        });
                    }
                }
                return result;
            }

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                Iterator iter = event.getNotifications().iterator();
                while (iter.hasNext()) {
                    iter.next();
                    postcommitEvents[0] = postcommitEvents[0] + 1;
                    PerformanceTest.assertNotNull((Object)event.getTransaction());
                }
            }
        };
        this.domain.addResourceSetListener((ResourceSetListener)listener);
        HashMap options = new HashMap();
        try {
            try {
                int i = 0;
                while (i < 12) {
                    originalTransaction[0] = null;
                    precommitEvents[0] = 0;
                    postcommitEvents[0] = 0;
                    this.startClock();
                    this.startWriting(options);
                    this.testResource.load(Collections.EMPTY_MAP);
                    this.commit();
                    this.startWriting(options);
                    this.testResource.unload();
                    this.commit();
                    long timing = this.stopClock();
                    System.out.println("Raw timing: " + timing);
                    ++i;
                }
                System.out.println("Number of pre-commit events : " + precommitEvents[0]);
                System.out.println("Number of post-commit events: " + postcommitEvents[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                PerformanceTest.fail((String)("Failed to load test resource: " + e.getLocalizedMessage()));
                this.domain.removeResourceSetListener((ResourceSetListener)listener);
            }
        }
        finally {
            this.domain.removeResourceSetListener((ResourceSetListener)listener);
        }
    }

    public void test_validatorTransactionTreeOptimizations_152332() {
        Transaction[] originalTransaction = new Transaction[1];
        int[] totalNotifications = new int[1];
        int[] expectedPrecommitNotifications = new int[1];
        int[] expectedPostcommitNotifications = new int[1];
        int[] expectedValidationNotifications = new int[1];
        final int[] receivedPrecommitNotifications = new int[1];
        final int[] receivedPostcommitNotifications = new int[1];
        final int[] receivedValidationNotifications = new int[1];
        ResourceSetListenerImpl prePostCommitCollector = new ResourceSetListenerImpl(){

            public NotificationFilter getFilter() {
                return NotificationFilter.ANY;
            }

            public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
                receivedPrecommitNotifications[0] = receivedPrecommitNotifications[0] + event.getNotifications().size();
                return null;
            }

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                receivedPostcommitNotifications[0] = event.getNotifications().size();
            }
        };
        this.domain.addResourceSetListener((ResourceSetListener)prePostCommitCollector);
        ResourceSetListenerImpl validationCollector = new ResourceSetListenerImpl(){

            public NotificationFilter getFilter() {
                return NotificationFilter.ANY;
            }

            public boolean isPrecommitOnly() {
                return true;
            }

            public boolean isAggregatePrecommitListener() {
                return true;
            }

            public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
                receivedValidationNotifications[0] = ((InternalTransactionalEditingDomain)PerformanceTest.this.domain).getValidator().getNotificationsForValidation(event.getTransaction()).size();
                return null;
            }
        };
        this.domain.addResourceSetListener((ResourceSetListener)validationCollector);
        try {
            int i = 0;
            while (i < 12) {
                originalTransaction[0] = null;
                totalNotifications[0] = 0;
                expectedPrecommitNotifications[0] = 0;
                expectedPostcommitNotifications[0] = 0;
                expectedValidationNotifications[0] = 0;
                receivedPrecommitNotifications[0] = 0;
                receivedPostcommitNotifications[0] = 0;
                receivedValidationNotifications[0] = 0;
                this.startClock();
                this.createTreeOfMixedTransactions(5, 10, totalNotifications, expectedPrecommitNotifications, expectedPostcommitNotifications, expectedValidationNotifications);
                long timing = this.stopClock();
                System.out.println("Raw timing: " + timing);
                ++i;
            }
            System.out.println("Total number of notifications: " + totalNotifications[0]);
            System.out.println("Number of pre-commit notifications sent: " + receivedPrecommitNotifications[0]);
            System.out.println("Number of post-commit notifications sent: " + receivedPostcommitNotifications[0]);
            System.out.println("Number of validation notifications sent: " + receivedValidationNotifications[0]);
            PerformanceTest.assertEquals((String)"Wrong number of pre-commit notifications", (int)expectedPrecommitNotifications[0], (int)receivedPrecommitNotifications[0]);
            PerformanceTest.assertEquals((String)"Wrong number of post-commit notifications", (int)expectedPostcommitNotifications[0], (int)receivedPostcommitNotifications[0]);
            PerformanceTest.assertEquals((String)"Wrong number of validation notifications", (int)expectedValidationNotifications[0], (int)receivedValidationNotifications[0]);
        }
        finally {
            this.domain.removeResourceSetListener((ResourceSetListener)validationCollector);
            this.domain.removeResourceSetListener((ResourceSetListener)prePostCommitCollector);
        }
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        System.out.println("Performance test: " + this.getName());
        System.out.println("===============================");
        this.timings = new ArrayList<Long>();
    }

    @Override
    protected void doTearDown() throws Exception {
        this.removeOutliers();
        System.out.println("Mean time for 10 runs: " + this.meanTiming());
        System.out.println("Standard deviation: " + this.stddevTiming());
        System.out.println("===============================");
        this.timings = null;
        super.doTearDown();
    }

    protected void createDeeplyNestedTransaction(int depth, int breadth) {
        if (depth-- > 0) {
            this.startWriting();
            if (depth > 0) {
                int i = 0;
                while (i < breadth) {
                    this.createDeeplyNestedTransaction(depth, breadth);
                    ++i;
                }
            }
            this.commit();
        }
    }

    protected void addStuffToTestResourceAndClose() {
        this.startWriting();
        Date today = new Date();
        int i = 0;
        while (i < 50) {
            this.addLibraryWithBooks(today);
            ++i;
        }
        this.commit();
        this.startReading();
        try {
            this.testResource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            e.printStackTrace();
            PerformanceTest.fail((String)("Failed to save test resource: " + e.getLocalizedMessage()));
        }
        this.testResource.unload();
        this.commit();
    }

    protected void addLibraryWithBooks(Date today) {
        Library lib = EXTLibraryFactory.eINSTANCE.createLibrary();
        EList branches = lib.getBranches();
        int j = 0;
        while (j < 20) {
            Library branch = EXTLibraryFactory.eINSTANCE.createLibrary();
            EList books = branch.getBooks();
            int i = 0;
            while (i < 10) {
                Book book = EXTLibraryFactory.eINSTANCE.createBook();
                book.setTitle("Foo");
                book.setPages(30);
                book.setCategory(BookCategory.BIOGRAPHY_LITERAL);
                book.setCopies(7);
                book.setPublicationDate(today);
                books.add((Object)book);
                ++i;
            }
            branches.add((Object)branch);
            ++j;
        }
        this.testResource.getContents().add((Object)lib);
    }

    protected void createTreeOfMixedTransactions(int depth, int breadth, int[] totalNotifications, int[] expectedPrecommitNotifications, int[] expectedPostcommitNotifications, int[] expectedValidationNotifications) {
        this.createTreeOfMixedTransactions(depth, breadth, true, true, true, totalNotifications, expectedPrecommitNotifications, expectedPostcommitNotifications, expectedValidationNotifications);
    }

    protected void createTreeOfMixedTransactions(int depth, int breadth, boolean trigger, boolean notify, boolean validate, int[] totalNotifications, int[] expectedPrecommitNotifications, int[] expectedPostcommitNotifications, int[] expectedValidationNotifications) {
        if (depth-- > 0) {
            this.startWriting(this.getOptions(trigger, notify, validate));
            this.pokeRoot();
            totalNotifications[0] = totalNotifications[0] + 1;
            if (trigger) {
                expectedPrecommitNotifications[0] = expectedPrecommitNotifications[0] + 1;
            }
            if (notify) {
                expectedPostcommitNotifications[0] = expectedPostcommitNotifications[0] + 1;
            }
            if (validate) {
                expectedValidationNotifications[0] = expectedValidationNotifications[0] + 1;
            }
            if (depth > 0) {
                int i = 0;
                while (i < breadth) {
                    this.createTreeOfMixedTransactions(depth, breadth, trigger && depth >= 3, notify && depth >= 2, validate && depth >= 1, totalNotifications, expectedPrecommitNotifications, expectedPostcommitNotifications, expectedValidationNotifications);
                    this.pokeRoot();
                    totalNotifications[0] = totalNotifications[0] + 1;
                    if (trigger) {
                        expectedPrecommitNotifications[0] = expectedPrecommitNotifications[0] + 1;
                    }
                    if (notify) {
                        expectedPostcommitNotifications[0] = expectedPostcommitNotifications[0] + 1;
                    }
                    if (validate) {
                        expectedValidationNotifications[0] = expectedValidationNotifications[0] + 1;
                    }
                    ++i;
                }
            }
            this.commit();
        }
    }

    private void pokeRoot() {
        this.root.setName(Long.toString(System.currentTimeMillis() ^ (long)this.root.getName().hashCode()));
    }

    private Map<Object, Object> getOptions(boolean trigger, boolean notify, boolean validate) {
        if (!trigger) {
            if (!notify) {
                if (!validate) {
                    return noNotifications;
                }
                return validationOnly;
            }
            return noTriggers;
        }
        return allNotifications;
    }

    final void startClock() {
        this.clock = System.currentTimeMillis();
    }

    final long stopClock() {
        long result = System.currentTimeMillis() - this.clock;
        this.timings.add(result);
        return result;
    }

    final void removeOutliers() {
        Collections.sort(this.timings);
        int i = 0;
        while (i < 1) {
            if (this.timings.size() > 1) {
                System.out.println("Remove high timing: " + this.timings.remove(this.timings.size() - 1));
                System.out.println("Remove low timing : " + this.timings.remove(0));
            }
            ++i;
        }
    }

    final double meanTiming() {
        double result = 0.0;
        int count = this.timings.size();
        int i = 0;
        while (i < count) {
            result += this.timings.get(i).doubleValue();
            ++i;
        }
        return result /= (double)count;
    }

    final double stddevTiming() {
        double result = 0.0;
        double mean = this.meanTiming();
        double dev = 0.0;
        int count = this.timings.size();
        int i = 0;
        while (i < count) {
            dev = this.timings.get(i).doubleValue() - mean;
            result += dev * dev;
            ++i;
        }
        result = Math.sqrt(result / (double)count);
        return result;
    }
}

