/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.ext.widgets.reference.internal;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.ide.ui.ext.widgets.reference.api.IEEFExtReferenceViewerFilterProvider;
import org.eclipse.eef.ide.ui.ext.widgets.reference.internal.EEFExtReferenceUIPlugin;
import org.eclipse.eef.ide.ui.ext.widgets.reference.internal.Messages;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class EEFExtEObjectSelectionPage
extends WizardPage {
    private EObject target;
    private EReference eReference;
    private EditingContextAdapter editingContextAdapter;
    private ComposedAdapterFactory composedAdapterFactory;
    private TreeViewer eObjectTreeViewer;
    private ISelectionChangedListener eObjectTreeViewerListener;

    public EEFExtEObjectSelectionPage(EObject target, EReference eReference, EditingContextAdapter editingContextAdapter) {
        super(Messages.ReferenceSelectionWizardPage_title);
        this.target = target;
        this.eReference = eReference;
        this.editingContextAdapter = editingContextAdapter;
        this.setTitle(Messages.ReferenceSelectionWizardPage_title);
        this.setDescription(Messages.ReferenceSelectionWizardPage_description);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite control = new Composite(parent, 0);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setControl((Control)control);
        GridLayout gridLayout = new GridLayout(2, false);
        control.setLayout((Layout)gridLayout);
        this.composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.composedAdapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.createSelectionTreeViewer(control);
        this.initializeInput();
        this.determinePageCompletion();
    }

    private void createSelectionTreeViewer(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.ReferenceCreationWizardPage_eContainerSelectionLabel);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.eObjectTreeViewer = new TreeViewer(new Tree(parent, 67588));
        this.eObjectTreeViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new AdapterFactoryLabelProvider.StyledLabelProvider((AdapterFactory)this.composedAdapterFactory, (Viewer)this.eObjectTreeViewer)));
        this.eObjectTreeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.composedAdapterFactory));
        this.eObjectTreeViewer.setAutoExpandLevel(2);
        GridData gridData = new GridData(4, 4, true, true, 2, 1);
        this.eObjectTreeViewer.getTree().setLayoutData((Object)gridData);
        List<ViewerFilter> viewFilters = EEFExtReferenceUIPlugin.getPlugin().getViewFilters(IEEFExtReferenceViewerFilterProvider.ContextKind.EOBJECT_SELECTION);
        this.eObjectTreeViewer.setFilters(viewFilters.toArray(new ViewerFilter[viewFilters.size()]));
        this.eObjectTreeViewerListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EEFExtEObjectSelectionPage.this.determinePageCompletion();
            }
        };
        this.eObjectTreeViewer.addSelectionChangedListener(this.eObjectTreeViewerListener);
    }

    protected void handleEObjectSelectionChanged() {
        this.determinePageCompletion();
    }

    private void initializeInput() {
        this.eObjectTreeViewer.setInput((Object)this.editingContextAdapter.getEditingDomain().getResourceSet());
    }

    private void determinePageCompletion() {
        this.setMessage(null);
        ISelection selection = this.eObjectTreeViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object object = structuredSelection.getFirstElement();
            if (object instanceof EObject) {
                EObject eObject = (EObject)object;
                if (this.eReference.getEReferenceType().isInstance((Object)eObject)) {
                    this.setPageComplete(true);
                } else {
                    String type = this.eReference.getEReferenceType().getName();
                    this.setMessage(MessageFormat.format(Messages.ReferenceSelectionWizardPage_missingEObject, type), 3);
                    this.setPageComplete(false);
                }
            } else {
                String type = this.eReference.getEReferenceType().getName();
                this.setMessage(MessageFormat.format(Messages.ReferenceSelectionWizardPage_missingEObject, type), 3);
                this.setPageComplete(false);
            }
        }
    }

    public void performFinish(IProgressMonitor monitor) {
        IStructuredSelection structuredSelection;
        Object object;
        ISelection selection = this.eObjectTreeViewer.getSelection();
        if (selection instanceof IStructuredSelection && (object = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof EObject) {
            EObject eObject = (EObject)object;
            if (this.eReference.getEReferenceType().isInstance((Object)eObject)) {
                this.target.eSet((EStructuralFeature)this.eReference, (Object)eObject);
            }
        }
    }
}

