/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.explorer.jobs;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpaceManager;
import org.eclipse.emf.henshin.statespace.explorer.StateSpaceExplorerPlugin;
import org.eclipse.emf.henshin.statespace.explorer.commands.ExploreStatesCommand;
import org.eclipse.emf.henshin.statespace.explorer.jobs.ExploreStateSpaceJob;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.widgets.Display;

public class ExploreStateSpaceJobWithDisplay
extends ExploreStateSpaceJob {
    private boolean executing;
    private int delay = 750;

    public ExploreStateSpaceJobWithDisplay(StateSpaceManager manager, EditDomain editDomain) {
        super(manager, editDomain);
        this.setUser(false);
        this.logInfo = false;
        this.setSaveInterval(-1);
        this.setNumStatesAtOnce(5);
    }

    @Override
    protected ExploreStatesCommand createExploreCommand(List<State> states, int start, int count) {
        ExploreStatesCommand command = super.createExploreCommand(states, start, count);
        command.setGenerateLocations(true);
        return command;
    }

    @Override
    protected void executeExploreCommand(final Command command, IProgressMonitor monitor) {
        this.executing = true;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        ExploreStateSpaceJobWithDisplay.this.editDomain.getCommandStack().execute(command);
                    }
                    catch (Throwable t) {
                        StateSpaceExplorerPlugin.getInstance().logError("Error exploring state", t);
                        ExploreStateSpaceJobWithDisplay.this.executing = false;
                    }
                }
                finally {
                    ExploreStateSpaceJobWithDisplay.this.executing = false;
                }
            }
        });
        block2: do {
            int steps;
            if ((steps = this.delay / 25) < 1) {
                steps = 1;
            }
            int j = 0;
            while (j < steps) {
                try {
                    Thread.sleep(25L);
                }
                catch (InterruptedException interruptedException) {}
                if (monitor.isCanceled()) continue block2;
                ++j;
            }
        } while (this.executing);
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }
}

