/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.explorer.parts;

import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.explorer.StateSpaceExplorerPlugin;
import org.eclipse.emf.henshin.statespace.impl.StateSpaceManagerImpl;
import org.eclipse.emf.henshin.statespace.resource.StateSpaceResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;

public class StateSpacePropertyPage
extends PropertyPage {
    private Label statesLabel;
    private Label transitionsLabel;
    private Label rulesLabel;

    private void addSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        Label label = new Label(composite, 0);
        label.setText("States:");
        this.statesLabel = new Label(composite, 0);
        label = new Label(composite, 0);
        label.setText("Transitions:");
        this.transitionsLabel = new Label(composite, 0);
        label = new Label(composite, 0);
        label.setText("Rules:");
        this.rulesLabel = new Label(composite, 0);
        StateSpace stateSpace = this.loadStateSpace();
        this.statesLabel.setText(String.valueOf(stateSpace.getStates().size()) + " (" + stateSpace.getOpenStates().size() + " open)");
        this.transitionsLabel.setText(String.valueOf(stateSpace.getTransitionCount()));
        this.rulesLabel.setText(String.valueOf(stateSpace.getRules().size()));
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        this.addSection(composite);
        return composite;
    }

    private Composite createDefaultComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    private StateSpace loadStateSpace() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI uri = URI.createPlatformResourceURI((String)((IResource)this.getElement()).getFullPath().toString(), (boolean)false);
        StateSpaceResource resource = null;
        StateSpaceManagerImpl manager = null;
        try {
            resource = (StateSpaceResource)resourceSet.getResource(uri, true);
            manager = new StateSpaceManagerImpl(resource.getStateSpace());
        }
        catch (Throwable e) {
            StateSpaceExplorerPlugin.getInstance().logError("Error loading state space", e);
            MessageDialog.openError((Shell)this.getShell(), (String)"Load State Space", (String)"Error loading state space. See the error log for mor information.");
        }
        return manager.getStateSpace();
    }
}

