/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.examples.ecore2genmodel;

import java.io.File;
import java.io.IOException;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.codegen.ecore.genmodel.impl.GenModelPackageImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.henshin.common.util.EmfGraph;
import org.eclipse.emf.henshin.interpreter.EmfEngine;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.emf.henshin.interpreter.interfaces.InterpreterEngine;
import org.eclipse.emf.henshin.model.SequentialUnit;
import org.eclipse.emf.henshin.model.TransformationSystem;
import org.eclipse.emf.henshin.model.TransformationUnit;
import org.eclipse.emf.henshin.model.impl.HenshinPackageImpl;
import org.eclipse.emf.henshin.model.resource.HenshinResourceFactory;

public class Ecore2GenmodelTrafo {
    private static final String BASE = "src/org/eclipse/emf/henshin/examples/ecore2genmodel/model/";
    private static final String ECORE_E2G = "ecore2gen.ecore";
    private static final String ECORE_E2G_FULL = "src/org/eclipse/emf/henshin/examples/ecore2genmodel/model/ecore2gen.ecore";
    private static final String HENSHIN_E2G_FULL = "src/org/eclipse/emf/henshin/examples/ecore2genmodel/model/Ecore2Genmodel.henshin";
    private static final String ECORE_SOURCE = "flowchartdsl.ecore";
    private static final String ECORE_SOURCE_FULL = "src/org/eclipse/emf/henshin/examples/ecore2genmodel/model/flowchartdsl.ecore";
    private static final String GENMODEL_TARGET_FULL = "src/org/eclipse/emf/henshin/examples/ecore2genmodel/model/flowchartdsl2.genmodel";
    ResourceSet resourceSet = new ResourceSetImpl();

    public void generateEcore2Genmodel() {
        this.initializeResourceFactories();
        TransformationSystem ts = (TransformationSystem)this.loadModel(HENSHIN_E2G_FULL);
        EPackage mappingModel = (EPackage)this.loadModel(ECORE_E2G_FULL);
        EPackage ecoreModel = (EPackage)this.loadModel(ECORE_SOURCE_FULL);
        EmfGraph graphM = new EmfGraph();
        graphM.addRoot((EObject)ecoreModel);
        EmfEngine engineM = new EmfEngine(graphM);
        TransformationUnit unit1 = ts.findUnitByName("translateGenModel");
        UnitApplication unitApp1 = new UnitApplication((InterpreterEngine)engineM, unit1);
        unitApp1.setParameterValue("modelFileName", (Object)ECORE_SOURCE);
        unitApp1.setParameterValue("pluginName", (Object)ecoreModel.getName());
        boolean result = unitApp1.execute();
        graphM.addRoot((EObject)ts);
        graphM.addRoot((EObject)GenModelPackage.eINSTANCE);
        graphM.addRoot((EObject)mappingModel);
        TransformationUnit unit2 = ts.findUnitByName("prepareCustomizationUnit");
        UnitApplication unitApp2 = new UnitApplication((InterpreterEngine)engineM, unit2);
        unitApp2.execute();
        SequentialUnit customizationUnit = (SequentialUnit)unitApp2.getParameterValue("seqUnit");
        UnitApplication unitApp3 = new UnitApplication((InterpreterEngine)engineM, (TransformationUnit)customizationUnit);
        unitApp3.execute();
        if (result) {
            System.out.println("Successful");
            GenModel gm = (GenModel)unitApp1.getParameterValue("genModel");
            this.saveGenModel(gm);
        } else {
            System.out.println("Not successful");
        }
    }

    private void saveGenModel(GenModel gen) {
        URI modelUri = URI.createFileURI((String)new File(GENMODEL_TARGET_FULL).getAbsolutePath());
        Resource res = this.resourceSet.createResource(modelUri, "genmodel");
        try {
            res.getContents().add((Object)gen);
            res.save(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private EObject loadModel(String modelPath) {
        URI modelUri = URI.createFileURI((String)new File(modelPath).getAbsolutePath());
        Resource resourceModel = this.resourceSet.getResource(modelUri, true);
        return (EObject)resourceModel.getContents().get(0);
    }

    private void initializeResourceFactories() {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("genmodel", new XMIResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("henshin", new HenshinResourceFactory());
        GenModelPackageImpl.init();
        HenshinPackageImpl.init();
    }

    public static void main(String[] args) {
        Ecore2GenmodelTrafo s = new Ecore2GenmodelTrafo();
        s.generateEcore2Genmodel();
    }
}

