/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.commands.dnd;

import java.util.Collection;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.DragAndDropFeedback;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.henshin.model.TransformationUnit;

public class NonContainmentTransientIPDragAndDropCommand
extends AbstractCommand
implements DragAndDropFeedback {
    protected EditingDomain domain;
    protected TransformationUnit trafoUnit;
    protected EReference reference;
    protected Command dragCommand;
    protected Command dropCommand;
    protected Collection<?> collection;

    public NonContainmentTransientIPDragAndDropCommand(EditingDomain domain, TransformationUnit trafoUnit, EReference reference, Collection<?> collection) {
        this.domain = domain;
        this.trafoUnit = trafoUnit;
        this.collection = collection;
        this.dragCommand = UnexecutableCommand.INSTANCE;
        this.dropCommand = UnexecutableCommand.INSTANCE;
        this.reference = reference;
    }

    protected boolean prepare() {
        this.dragCommand = IdentityCommand.INSTANCE;
        this.dropCommand = UnexecutableCommand.INSTANCE;
        if (this.checkValidInstanceVariables()) {
            for (Object o : this.collection) {
                if (!(o instanceof IWrapperItemProvider)) continue;
                IWrapperItemProvider wrapper = (IWrapperItemProvider)o;
                this.dragCommand = this.dragCommand.chain(RemoveCommand.create((EditingDomain)this.domain, (Object)wrapper.getOwner(), (Object)wrapper.getFeature(), (Object)wrapper.getValue()));
            }
            if (this.reference.isMany()) {
                this.dropCommand = AddCommand.create((EditingDomain)this.domain, (Object)this.trafoUnit, (Object)this.reference, this.collection);
            } else {
                Object o;
                o = this.collection.toArray()[0];
                this.dropCommand = SetCommand.create((EditingDomain)this.domain, (Object)this.trafoUnit, (Object)this.reference, o);
            }
        }
        return this.dragCommand.canExecute() && this.dropCommand.canExecute();
    }

    private boolean checkValidInstanceVariables() {
        boolean result;
        boolean bl = result = this.domain != null && this.trafoUnit != null && this.collection != null;
        result = result && (this.reference.isMany() ? !this.collection.isEmpty() : this.collection.size() == 1);
        return result;
    }

    public void execute() {
        this.dragCommand.execute();
        this.dropCommand.execute();
    }

    public void undo() {
        this.dropCommand.undo();
        this.dragCommand.undo();
    }

    public void redo() {
        this.execute();
    }

    public Collection<?> getResult() {
        return this.dropCommand != null ? this.dropCommand.getResult() : super.getResult();
    }

    public boolean validate(Object owner, float location, int operations, int operation, Collection<?> collection) {
        return false;
    }

    public int getFeedback() {
        return this.isExecutable ? 1 : 0;
    }

    public int getOperation() {
        return this.isExecutable ? 4 : 0;
    }

    public Collection<?> getAffectedObjects() {
        return this.dropCommand != null ? this.dropCommand.getAffectedObjects() : super.getAffectedObjects();
    }

    public void dispose() {
        if (this.dragCommand != null) {
            this.dragCommand.dispose();
        }
        if (this.dropCommand != null) {
            this.dropCommand.dispose();
        }
    }
}

