/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.matching.constraints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.matching.conditions.AttributeConditionHandler;
import org.eclipse.emf.henshin.interpreter.matching.constraints.AttributeConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.BinaryConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.ContainmentConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.DanglingConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.DomainChange;
import org.eclipse.emf.henshin.interpreter.matching.constraints.ParameterConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.ReferenceConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.Variable;

public class DomainSlot {
    Variable owner;
    boolean initialized = false;
    boolean locked = false;
    EObject value;
    List<EObject> domain;
    List<EObject> temporaryDomain;
    final Map<BinaryConstraint, DomainChange> remoteChangeMap;
    final List<String> initializedParameters;
    final AttributeConditionHandler conditionHandler;
    final Set<Variable> checkedVariables;
    final Set<EObject> usedObjects;
    final boolean injective;
    final boolean dangling;
    final boolean deterministic;

    public DomainSlot(AttributeConditionHandler conditionHandler, Set<EObject> usedObjects, boolean injective, boolean dangling, boolean deterministic) {
        this.conditionHandler = conditionHandler;
        this.usedObjects = usedObjects;
        this.remoteChangeMap = new HashMap<BinaryConstraint, DomainChange>();
        this.initializedParameters = new ArrayList<String>();
        this.checkedVariables = new HashSet<Variable>();
        this.injective = injective;
        this.dangling = dangling;
        this.deterministic = deterministic;
    }

    public boolean instantiate(Variable variable, Map<Variable, DomainSlot> domainMap, EGraph graph) {
        if (!this.initialized) {
            this.initialized = true;
            this.owner = variable;
            if (this.temporaryDomain != null) {
                this.domain = new ArrayList<EObject>(this.temporaryDomain);
            }
            variable.typeConstraint.initDomain(this, graph);
            if (this.domain.isEmpty()) {
                return false;
            }
            if (!this.deterministic) {
                Collections.shuffle(this.domain);
            }
            if (this.injective) {
                this.domain.removeAll(this.usedObjects);
            }
        }
        if (!this.locked) {
            if (this.domain.isEmpty()) {
                return false;
            }
            this.value = this.domain.remove(this.domain.size() - 1);
            this.usedObjects.add(this.value);
            this.locked = true;
        }
        if (!this.checkedVariables.contains(variable)) {
            if (!variable.typeConstraint.check(this)) {
                return false;
            }
            for (AttributeConstraint attributeConstraint : variable.attributeConstraints) {
                if (attributeConstraint.check(this)) continue;
                return false;
            }
            if (this.dangling) {
                for (DanglingConstraint danglingConstraint : variable.danglingConstraints) {
                    if (danglingConstraint.check(this.value, graph)) continue;
                    return false;
                }
            }
            for (ParameterConstraint parameterConstraint : variable.parameterConstraints) {
                if (!this.conditionHandler.isSet(parameterConstraint.parameterName)) {
                    this.initializedParameters.add(parameterConstraint.parameterName);
                }
                if (parameterConstraint.check(this)) continue;
                return false;
            }
            for (ContainmentConstraint containmentConstraint : variable.containmentConstraints) {
                DomainSlot targetSlot;
                if (containmentConstraint.check(this, targetSlot = domainMap.get(containmentConstraint.targetVariable))) continue;
                return false;
            }
            for (ReferenceConstraint referenceConstraint : variable.referenceConstraints) {
                DomainSlot target;
                if (referenceConstraint.check(this, target = domainMap.get(referenceConstraint.targetVariable))) continue;
                return false;
            }
            this.checkedVariables.add(variable);
        }
        return true;
    }

    public boolean unlock(Variable sender) {
        int refCount = sender.referenceConstraints.size();
        int conCount = sender.containmentConstraints.size();
        int i = refCount + conCount - 1;
        while (i >= 0) {
            BinaryConstraint constraint = i >= refCount ? (BinaryConstraint)sender.containmentConstraints.get(i - refCount) : (BinaryConstraint)sender.referenceConstraints.get(i);
            DomainChange change = this.remoteChangeMap.get(constraint);
            if (change != null) {
                change.slot.temporaryDomain = change.originalValues;
                this.remoteChangeMap.remove(constraint);
            }
            --i;
        }
        if (this.locked && sender == this.owner) {
            this.locked = false;
            this.usedObjects.remove(this.value);
            for (String parameterName : this.initializedParameters) {
                this.conditionHandler.unsetParameter(parameterName);
            }
            this.initializedParameters.clear();
            this.checkedVariables.clear();
            return this.domain != null && !this.domain.isEmpty();
        }
        this.checkedVariables.remove(sender);
        return false;
    }

    public void clear(Variable sender) {
        this.unlock(sender);
        if (sender == this.owner) {
            this.initialized = false;
            this.remoteChangeMap.clear();
            this.owner = null;
            this.value = null;
            this.domain = null;
        }
    }

    public void reset(Variable sender) {
        if (sender == this.owner) {
            this.temporaryDomain = null;
        }
        this.clear(sender);
    }

    public boolean instantiationPossible() {
        if (this.domain == null) {
            return false;
        }
        if (!this.locked) {
            return this.domain.size() > 0;
        }
        return false;
    }

    public void fixInstantiation(EObject value) {
        this.locked = true;
        this.value = value;
        this.initialized = true;
        this.usedObjects.add(value);
        this.owner = null;
    }
}

