/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.ocl2ac.ocl2gc.util;

import graph.Attribute;
import graph.Edge;
import graph.Graph;
import graph.Node;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import morphisms.Mapping;
import morphisms.Morphism;
import morphisms.MorphismsPackage;
import morphisms.Pair;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class JointPairs {
    private static Pair pushout = null;

    public static Pair getPushout() {
        return pushout;
    }

    public static Set<Pair> getCommutingPairs(Pair span) {
        HashMap<Node, Node> nodeMap = new HashMap<Node, Node>();
        for (Mapping mA : span.getA().getMappings()) {
            for (Mapping mB : span.getB().getMappings()) {
                if (mA.getOrigin() != mB.getOrigin()) continue;
                nodeMap.put(mA.getImage(), mB.getImage());
            }
        }
        return JointPairs.getJointPairs(span.getA().getCodomain(), span.getB().getCodomain(), nodeMap);
    }

    public static Set<Pair> getJointInclusions(Graph graphA, Graph graphB) {
        HashMap<Node, Node> nodeMap = new HashMap<Node, Node>();
        for (Node a : graphA.getNodes()) {
            block1: for (Node b : graphB.getNodes()) {
                for (String name : a.getNames()) {
                    if (!b.getNames().contains(name)) continue;
                    nodeMap.put(a, b);
                    continue block1;
                }
            }
        }
        return JointPairs.getJointPairs(graphA, graphB, nodeMap);
    }

    private static Set<Pair> getJointPairs(Graph graphA, Graph graphB, Map<Node, Node> jointNodes) {
        Node image;
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        Graph graph = (Graph)copier.copy((EObject)graphA);
        copier.copyReferences();
        HashMap<Node, Node> nodeMap = new HashMap<Node, Node>();
        for (Map.Entry<Node, Node> e : jointNodes.entrySet()) {
            nodeMap.put(e.getValue(), (Node)copier.get((Object)e.getKey()));
        }
        for (Node node : graphB.getNodes()) {
            image = (Node)nodeMap.get(node);
            if (image == null) {
                image = (Node)EcoreUtil.copy((EObject)node);
                nodeMap.put(node, image);
                graph.getNodes().add((Object)image);
                continue;
            }
            Iterator jointType = JointPairs.getCommonSubtype(node.getType(), image.getType());
            if (jointType == null) {
                return Collections.emptySet();
            }
            image.setType((EClass)jointType);
            for (Attribute a : node.getAttributes()) {
                Attribute copy = (Attribute)EcoreUtil.copy((EObject)a);
                copy.setValue(a.getValue());
                copy.setOp(a.getOp());
                copy.setType(a.getType());
                image.getAttributes().add((Object)copy);
            }
            image.addNames(node.getNames());
        }
        block3: for (Edge edge : graphB.getEdges()) {
            for (Edge e : graph.getEdges()) {
                if (edge.getType() == e.getType() && nodeMap.get(edge.getSource()) == e.getSource() && nodeMap.get(edge.getTarget()) == e.getTarget()) continue block3;
            }
            image = (Edge)EcoreUtil.copy((EObject)edge);
            image.setSource((Node)nodeMap.get(edge.getSource()));
            image.setTarget((Node)nodeMap.get(edge.getTarget()));
            graph.getEdges().add((Object)image);
        }
        Pair initial = MorphismsPackage.eINSTANCE.getMorphismsFactory().createPair();
        Morphism morphA = MorphismsPackage.eINSTANCE.getMorphismsFactory().createMorphism();
        morphA.setDomain(graphA);
        morphA.setCodomain(graph);
        for (Node node : graphA.getNodes()) {
            Mapping mapping = MorphismsPackage.eINSTANCE.getMorphismsFactory().createMapping();
            mapping.setOrigin(node);
            mapping.setImage((Node)copier.get((Object)node));
            morphA.getMappings().add((Object)mapping);
        }
        initial.setA(morphA);
        Morphism morphB = MorphismsPackage.eINSTANCE.getMorphismsFactory().createMorphism();
        morphB.setDomain(graphB);
        morphB.setCodomain(graph);
        for (Node node : graphB.getNodes()) {
            Mapping mapping = MorphismsPackage.eINSTANCE.getMorphismsFactory().createMapping();
            mapping.setOrigin(node);
            mapping.setImage((Node)nodeMap.get(node));
            morphB.getMappings().add((Object)mapping);
        }
        initial.setB(morphB);
        pushout = initial;
        HashSet<Pair> result = new HashSet<Pair>();
        result.add(initial);
        JointPairs.collectJointPairs(initial, result, 0);
        return result;
    }

    private static void collectJointPairs(Pair initial, Set<Pair> result, int nodeIndex) {
        initial.getA().getDomain().getNodes();
        EList nodes = initial.getA().getDomain().getNodes();
        if (nodeIndex >= nodes.size()) {
            return;
        }
        Node a = (Node)nodes.get(nodeIndex);
        for (Node b : initial.getB().getDomain().getNodes()) {
            for (Pair joined : JointPairs.join(initial, a, b)) {
                if (joined == null) continue;
                result.add(joined);
                JointPairs.collectJointPairs(joined, result, nodeIndex + 1);
            }
        }
        JointPairs.collectJointPairs(initial, result, nodeIndex + 1);
    }

    private static boolean isAttributeValueIn(Attribute attA, Node image) {
        for (Attribute attB : image.getAttributes()) {
            if (!attA.getType().getName().equals(attB.getType().getName()) || !attA.getValue().equals(attB.getValue()) && attA.getValue() != null && attB.getValue() != null) continue;
            return true;
        }
        return false;
    }

    private static Collection<Pair> join(Pair pair, Node nodeA, Node nodeB) {
        EClass jt = JointPairs.getCommonSubtype(nodeA.getType(), nodeB.getType());
        if (jt != null) {
            for (Attribute attA : nodeA.getAttributes()) {
                if (JointPairs.isAttributeValueIn(attA, nodeB)) continue;
                return Collections.emptySet();
            }
        }
        Mapping mappingA = JointPairs.getOutgoingMapping(pair.getA(), nodeA);
        Mapping mappingB = JointPairs.getOutgoingMapping(pair.getB(), nodeB);
        if (JointPairs.getIncomingMapping(pair.getB(), mappingA.getImage()) != null || JointPairs.getIncomingMapping(pair.getA(), mappingB.getImage()) != null) {
            return Collections.emptySet();
        }
        LinkedList<Pair> pairs = new LinkedList<Pair>();
        for (EClass jointType : JointPairs.getCommonSubtypes(nodeA.getType(), nodeB.getType(), pair.getA().getCodomain().getTypegraph())) {
            Edge edge;
            EcoreUtil.Copier copier = new EcoreUtil.Copier();
            Pair result = (Pair)copier.copy((EObject)pair);
            Graph graph = (Graph)copier.copy((EObject)pair.getA().getCodomain());
            copier.copyReferences();
            mappingA = (Mapping)copier.get((Object)mappingA);
            mappingB = (Mapping)copier.get((Object)mappingB);
            Node remaining = mappingA.getImage();
            Node removed = mappingB.getImage();
            remaining.setType(jointType);
            remaining.getAttributes().addAll((Collection)removed.getAttributes());
            remaining.addNames(removed.getNames());
            mappingB.setImage(remaining);
            Iterator edgeIterator = removed.getIncoming().iterator();
            block2: while (edgeIterator.hasNext()) {
                edge = (Edge)edgeIterator.next();
                for (Edge e : remaining.getIncoming()) {
                    if (edge.getType() != e.getType() || edge.getSource() != e.getSource()) continue;
                    edge.setSource(null);
                    graph.getEdges().remove((Object)edge);
                    continue block2;
                }
                edgeIterator.remove();
                edge.setTarget(remaining);
            }
            edgeIterator = removed.getOutgoing().iterator();
            block4: while (edgeIterator.hasNext()) {
                edge = (Edge)edgeIterator.next();
                for (Edge e : remaining.getOutgoing()) {
                    if (edge.getType() != e.getType() || edge.getTarget() != e.getTarget()) continue;
                    edge.setTarget(null);
                    graph.getEdges().remove((Object)edge);
                    continue block4;
                }
                edgeIterator.remove();
                edge.setSource(remaining);
            }
            graph.getNodes().remove((Object)removed);
            pairs.add(result);
        }
        return pairs;
    }

    private static Mapping getOutgoingMapping(Morphism morphism, Node node) {
        for (Mapping mapping : morphism.getMappings()) {
            if (mapping.getOrigin() != node) continue;
            return mapping;
        }
        return null;
    }

    private static Mapping getIncomingMapping(Morphism morphism, Node node) {
        for (Mapping mapping : morphism.getMappings()) {
            if (mapping.getImage() != node) continue;
            return mapping;
        }
        return null;
    }

    private static EClass getCommonSubtype(EClass a, EClass b) {
        if (a == b) {
            return a;
        }
        if (a.getEAllSuperTypes().contains((Object)b)) {
            return a;
        }
        if (b.getEAllSuperTypes().contains((Object)a)) {
            return b;
        }
        return null;
    }

    private static List<EClass> getCommonSubtypes(EClass a, EClass b, EPackage typeGraph) {
        if (a == b) {
            return Collections.singletonList(a);
        }
        if (a.getEAllSuperTypes().contains((Object)b)) {
            return Collections.singletonList(a);
        }
        if (b.getEAllSuperTypes().contains((Object)a)) {
            return Collections.singletonList(b);
        }
        BasicEList result = new BasicEList();
        for (EClassifier e : typeGraph.getEClassifiers()) {
            EList superTypes;
            if (!(e instanceof EClass) || !(superTypes = ((EClass)e).getEAllSuperTypes()).contains(a) || !superTypes.contains(b)) continue;
            result.add((EClass)e);
        }
        return result;
    }
}

