/*******************************************************************************
 * Copyright (c) 2009 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.internal.ui.actions;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;

public class GenModelPropertyTester extends PropertyTester {

	public boolean test(Object receiver, String property, Object[] args,
			Object expectedValue) {
		boolean result = false;
		if (receiver instanceof GenModel) {
			GenModel genModel = (GenModel) receiver;
			EList<String> paths = genModel.getForeignModel();
			if (!paths.isEmpty()) {
				result = true;
				for (String path : paths) {
					URI uri = URI.createURI(path).resolve(
							genModel.eResource().getURI());
					if (!uri.isPlatformResource())
						result = false;
				}
			}
		}

		return Boolean.valueOf(result).equals(expectedValue);
	}
}
