/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.textedit.representation.architecture.commands;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.textedit.representation.TextDocumentRepresentation;
import org.eclipse.papyrus.infra.textedit.representation.architecture.commands.AbstractCreateTextDocumentViewCommand;
import org.eclipse.papyrus.infra.textedit.representation.architecture.internal.messages.Messages;
import org.eclipse.papyrus.infra.textedit.textdocument.TextDocument;
import org.eclipse.papyrus.infra.textedit.textdocument.TextDocumentFactory;

public class CreateTextDocumentViewCommand
extends AbstractCreateTextDocumentViewCommand<TextDocument> {
    private final TextDocumentRepresentation textDocumentRepresentation;

    public CreateTextDocumentViewCommand(TransactionalEditingDomain domain, TextDocumentRepresentation textDocumentRepresentation, String textName, EObject semanticContext, EObject graphicalContext, boolean openAfterCreation) {
        super(domain, Messages.CreateTextDocumentViewCommand_CreateNewTextDocument, textName, semanticContext, graphicalContext, openAfterCreation);
        this.textDocumentRepresentation = textDocumentRepresentation;
    }

    public CreateTextDocumentViewCommand(TransactionalEditingDomain domain, TextDocumentRepresentation textDocumentRepresentation, String textName, EObject semanticContext, boolean openAfterCreation) {
        this(domain, textDocumentRepresentation, textName, semanticContext, null, openAfterCreation);
    }

    protected void doExecute() {
        TextDocument newInstance = TextDocumentFactory.eINSTANCE.createTextDocument();
        newInstance.setName(this.editorViewName);
        newInstance.setSemanticContext(this.semanticContext);
        if (this.graphicalContext != null) {
            newInstance.setGraphicalContext(this.graphicalContext);
        } else {
            newInstance.setGraphicalContext(this.semanticContext);
        }
        newInstance.setType(this.textDocumentRepresentation.getImplementationID());
        newInstance.setKindId(this.textDocumentRepresentation.getId());
        this.attachToResource(this.semanticContext, newInstance);
        if (this.openAfterCreation) {
            this.openEditor(newInstance);
        }
        if (newInstance.eResource() != null) {
            this.createdEditorView = newInstance;
        }
    }
}

