/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.copy.command;

import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.copy.InternalCellClipboard;
import org.eclipse.nebula.widgets.nattable.copy.command.InternalPasteDataCommandHandler;
import org.eclipse.nebula.widgets.nattable.copy.command.PasteDataCommand;
import org.eclipse.nebula.widgets.nattable.edit.command.UpdateDataCommand;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class RowSpanningPasteDataCommandHandler
extends InternalPasteDataCommandHandler {
    public RowSpanningPasteDataCommandHandler(SelectionLayer selectionLayer, InternalCellClipboard clipboard) {
        super(selectionLayer, clipboard);
    }

    @Override
    protected boolean doCommand(PasteDataCommand command) {
        if (this.clipboard.getCopiedCells() != null) {
            this.preInternalPaste();
            PositionCoordinate coord = this.selectionLayer.getSelectionAnchor();
            int pasteColumn = coord.getColumnPosition();
            int pasteRow = coord.getRowPosition();
            IUniqueIndexLayer pasteLayer = this.getPasteLayer(this.clipboard.getCopiedCells());
            if (pasteLayer != this.selectionLayer) {
                pasteColumn = LayerUtil.convertColumnPosition(this.selectionLayer, pasteColumn, pasteLayer);
                pasteRow = LayerUtil.convertRowPosition(this.selectionLayer, pasteRow, pasteLayer);
                coord = new PositionCoordinate(pasteLayer, pasteColumn, pasteRow);
            }
            ILayerCell[][] iLayerCellArray = this.clipboard.getCopiedCells();
            int n = iLayerCellArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILayerCell[] cells;
                ILayerCell[] iLayerCellArray2 = cells = iLayerCellArray[n2];
                int n3 = cells.length;
                int n4 = 0;
                while (n4 < n3) {
                    ILayerCell cell = iLayerCellArray2[n4];
                    ILayerCell targetCell = pasteLayer.getCellByPosition(pasteColumn, pasteRow);
                    if (this.isPasteAllowed(cell, targetCell, command.configRegistry)) {
                        pasteLayer.doCommand(new UpdateDataCommand(pasteLayer, pasteColumn, pasteRow, this.getPasteValue(cell, pasteColumn, pasteRow)));
                    }
                    if (++pasteColumn >= pasteLayer.getColumnCount()) break;
                    ++n4;
                }
                ILayerCell targetCell = pasteLayer.getCellByPosition(coord.getColumnPosition(), pasteRow);
                pasteRow += targetCell.getRowSpan();
                pasteColumn = coord.getColumnPosition();
                ++n2;
            }
            this.postInternalPaste();
        }
        return true;
    }
}

