/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection.preserve;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowIdAccessor;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.ResizeStructuralRefreshEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;
import org.eclipse.nebula.widgets.nattable.reorder.event.ColumnReorderEvent;
import org.eclipse.nebula.widgets.nattable.resize.event.ColumnResizeEvent;
import org.eclipse.nebula.widgets.nattable.resize.event.RowResizeEvent;
import org.eclipse.nebula.widgets.nattable.selection.IMarkerSelectionModel;
import org.eclipse.nebula.widgets.nattable.selection.SelectionUtils;
import org.eclipse.nebula.widgets.nattable.selection.preserve.Selections;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class PreserveSelectionModel<T>
implements IMarkerSelectionModel {
    protected final IUniqueIndexLayer selectionLayer;
    private final IRowDataProvider<T> rowDataProvider;
    private final IRowIdAccessor<T> rowIdAccessor;
    private boolean allowMultiSelection;
    private Selections<T> selections = new Selections();
    private final ReadWriteLock selectionsLock;
    Selections.CellPosition<T> selectionAnchor;
    Point selectionAnchorPoint;
    Selections.CellPosition<T> lastSelectedCell;
    Rectangle lastSelectedRegion;
    T lastSelectedRegionOriginRowObject;

    public PreserveSelectionModel(IUniqueIndexLayer selectionLayer, IRowDataProvider<T> rowDataProvider, IRowIdAccessor<T> rowIdAccessor) {
        this.selectionLayer = selectionLayer;
        this.rowDataProvider = rowDataProvider;
        this.rowIdAccessor = rowIdAccessor;
        this.allowMultiSelection = true;
        this.selectionsLock = new ReentrantReadWriteLock();
    }

    @Override
    public boolean isMultipleSelectionAllowed() {
        return this.allowMultiSelection;
    }

    @Override
    public void setMultipleSelectionAllowed(boolean multipleSelectionAllowed) {
        this.allowMultiSelection = multipleSelectionAllowed;
    }

    @Override
    public void addSelection(int columnPosition, int rowPosition) {
        this.selectionsLock.writeLock().lock();
        try {
            Serializable rowId;
            if (!this.allowMultiSelection) {
                this.clearSelection();
            }
            if ((rowId = this.getRowIdByPosition(rowPosition)) != null) {
                T rowObject = this.getRowObjectByPosition(rowPosition);
                this.selections.select(rowId, rowObject, columnPosition);
            }
        }
        finally {
            this.selectionsLock.writeLock().unlock();
        }
    }

    @Override
    public void addSelection(Rectangle range) {
        this.selectionsLock.writeLock().lock();
        try {
            if (!this.allowMultiSelection) {
                this.clearSelection();
            }
            int startColumnPosition = range.x;
            int startRowPosition = range.y;
            if (startColumnPosition < this.selectionLayer.getColumnCount() && startRowPosition < this.selectionLayer.getRowCount()) {
                int numberOfVisibleColumnsToBeSelected = this.getNumberOfColumnsToBeSelected(range);
                int numberOfVisibleRowsToBeSelected = this.getNumberOfRowsToBeSelected(range);
                int rowPosition = startRowPosition;
                while (rowPosition < startRowPosition + numberOfVisibleRowsToBeSelected) {
                    Serializable rowId = this.getRowIdByPosition(rowPosition);
                    if (rowId != null) {
                        T rowObject = this.getRowObjectByPosition(rowPosition);
                        int columnPosition = startColumnPosition;
                        while (columnPosition < startColumnPosition + numberOfVisibleColumnsToBeSelected) {
                            this.selections.select(rowId, rowObject, columnPosition);
                            ++columnPosition;
                        }
                    }
                    ++rowPosition;
                }
            }
        }
        finally {
            this.selectionsLock.writeLock().unlock();
        }
    }

    @Override
    public void clearSelection() {
        this.selectionsLock.writeLock().lock();
        try {
            this.selections.clear();
        }
        finally {
            this.selectionsLock.writeLock().unlock();
        }
    }

    @Override
    public void clearSelection(int columnPosition, int rowPosition) {
        this.selectionsLock.writeLock().lock();
        try {
            Serializable rowId = this.getRowIdByPosition(rowPosition);
            if (rowId != null) {
                this.selections.deselect(rowId, columnPosition);
            }
        }
        finally {
            this.selectionsLock.writeLock().unlock();
        }
    }

    @Override
    public void clearSelection(Rectangle removedSelection) {
        this.selectionsLock.writeLock().lock();
        try {
            int startColumnPosition = removedSelection.x;
            int startRowPosition = removedSelection.y;
            if (startColumnPosition < this.selectionLayer.getColumnCount() && startRowPosition < this.selectionLayer.getRowCount()) {
                int numberOfVisibleColumnsToBeSelected = this.getNumberOfColumnsToBeSelected(removedSelection);
                int numberOfVisibleRowsToBeSelected = this.getNumberOfRowsToBeSelected(removedSelection);
                int rowPosition = startRowPosition;
                while (rowPosition < startRowPosition + numberOfVisibleRowsToBeSelected) {
                    Serializable rowId = this.getRowIdByPosition(rowPosition);
                    if (rowId != null) {
                        int columnPosition = startColumnPosition;
                        while (columnPosition < startColumnPosition + numberOfVisibleColumnsToBeSelected) {
                            this.selections.deselect(rowId, columnPosition);
                            ++columnPosition;
                        }
                    }
                    ++rowPosition;
                }
            }
        }
        finally {
            this.selectionsLock.writeLock().unlock();
        }
    }

    private int getNumberOfColumnsToBeSelected(Rectangle selection) {
        int columnCount = this.selectionLayer.getColumnCount();
        return selection.x + selection.width <= columnCount ? selection.width : columnCount;
    }

    private int getNumberOfRowsToBeSelected(Rectangle selection) {
        int rowCount = this.selectionLayer.getRowCount();
        return selection.y + selection.height <= rowCount ? selection.height : rowCount;
    }

    @Override
    public boolean isEmpty() {
        this.selectionsLock.readLock().lock();
        try {
            boolean bl = this.selections.isEmpty();
            return bl;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    @Override
    public List<Rectangle> getSelections() {
        ArrayList<Rectangle> selectedCells = null;
        this.selectionsLock.readLock().lock();
        try {
            Collection<Selections.CellPosition<T>> selectedPositions = this.selections.getSelections();
            selectedCells = new ArrayList<Rectangle>(selectedPositions.size());
            for (Selections.CellPosition<T> cellPosition : selectedPositions) {
                int rowPosition = this.getRowPositionByRowObject(cellPosition.getRowObject());
                if (!this.isRowVisible(rowPosition)) continue;
                Integer columnPosition = cellPosition.getColumnPosition();
                Rectangle selectedCell = new Rectangle(columnPosition.intValue(), rowPosition, 1, 1);
                selectedCells.add(selectedCell);
            }
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
        return selectedCells;
    }

    private boolean isRowVisible(int rowPosition) {
        return rowPosition != -1;
    }

    @Override
    public boolean isCellPositionSelected(int columnPosition, int rowPosition) {
        this.selectionsLock.readLock().lock();
        try {
            int cellOriginRowPosition;
            ILayerCell cell = this.selectionLayer.getCellByPosition(columnPosition, rowPosition);
            int candidateRowPosition = cellOriginRowPosition = cell.getOriginRowPosition();
            while (candidateRowPosition < cellOriginRowPosition + cell.getRowSpan()) {
                int cellOriginColumnPosition;
                Serializable rowId = this.getRowIdByPosition(candidateRowPosition);
                int candidateColumnPosition = cellOriginColumnPosition = cell.getOriginColumnPosition();
                while (candidateColumnPosition < cellOriginColumnPosition + cell.getColumnSpan()) {
                    if (this.selections.isSelected(rowId, candidateColumnPosition)) {
                        return true;
                    }
                    ++candidateColumnPosition;
                }
                ++candidateRowPosition;
            }
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
        return false;
    }

    @Override
    public int[] getSelectedColumnPositions() {
        this.selectionsLock.readLock().lock();
        try {
            int[] nArray = this.selections.getColumnPositions();
            return nArray;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    @Override
    public boolean isColumnPositionSelected(int columnPosition) {
        this.selectionsLock.readLock().lock();
        try {
            for (Selections.Row<T> row : this.selections.getRows()) {
                if (!row.contains(columnPosition)) continue;
                return true;
            }
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
        return false;
    }

    @Override
    public int[] getFullySelectedColumnPositions(int columnHeight) {
        this.selectionsLock.readLock().lock();
        try {
            int[] nArray = Arrays.stream(this.selections.getColumnPositions()).filter(selectedColumn -> this.isColumnPositionFullySelected(selectedColumn, columnHeight)).toArray();
            return nArray;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    @Override
    public boolean isColumnPositionFullySelected(int columnPosition, int columnHeight) {
        this.selectionsLock.readLock().lock();
        try {
            Selections.Column selectedRowsInColumn = this.selections.getSelectedRows(columnPosition);
            if (this.hasColumnsSelectedRows(selectedRowsInColumn)) {
                boolean bl = selectedRowsInColumn.getItems().size() >= columnHeight;
                return bl;
            }
            return false;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    private boolean hasColumnsSelectedRows(Selections.Column column) {
        return column != null;
    }

    @Override
    public int getSelectedRowCount() {
        this.selectionsLock.readLock().lock();
        try {
            int n = this.selections.getRows().size();
            return n;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    @Override
    public Set<Range> getSelectedRowPositions() {
        HashSet<Range> visiblySelectedRowPositions = new HashSet<Range>();
        this.selectionsLock.readLock().lock();
        try {
            for (Selections.Row<T> row : this.selections.getRows()) {
                int rowPosition = this.getRowPositionByRowObject(row.getRowObject());
                if (!this.isRowVisible(rowPosition)) continue;
                visiblySelectedRowPositions.add(new Range(rowPosition, rowPosition + 1));
            }
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
        return visiblySelectedRowPositions;
    }

    @Override
    public boolean isRowPositionSelected(int rowPosition) {
        this.selectionsLock.readLock().lock();
        try {
            Serializable rowId = this.getRowIdByPosition(rowPosition);
            boolean bl = this.selections.isRowSelected(rowId);
            return bl;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    @Override
    public int[] getFullySelectedRowPositions(int rowWidth) {
        this.selectionsLock.readLock().lock();
        try {
            int[] nArray = this.selections.getRows().stream().map(Selections.Row::getRowObject).mapToInt(this::getRowPositionByRowObject).filter(rowPosition -> this.isRowVisible(rowPosition) && this.isRowPositionFullySelected(rowPosition, rowWidth)).sorted().toArray();
            return nArray;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    @Override
    public boolean isRowPositionFullySelected(int rowPosition, int rowWidth) {
        int[] selectedColumnPositions = null;
        this.selectionsLock.readLock().lock();
        try {
            Selections.Row<T> selectedColumnsInRow;
            Serializable rowId = this.getRowIdByPosition(rowPosition);
            if (rowId != null && this.hasRowSelectedColumns(selectedColumnsInRow = this.selections.getSelectedColumns(rowId))) {
                selectedColumnPositions = selectedColumnsInRow.getItems().stream().mapToInt(Integer::intValue).toArray();
            }
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
        return selectedColumnPositions == null || selectedColumnPositions.length < rowWidth ? false : SelectionUtils.isConsecutive(selectedColumnPositions);
    }

    private boolean hasRowSelectedColumns(Selections.Row<T> row) {
        return row != null;
    }

    protected Serializable getRowIdByPosition(int rowPosition) {
        T rowObject = this.getRowObjectByPosition(rowPosition);
        if (rowObject != null) {
            return this.rowIdAccessor.getRowId(rowObject);
        }
        return null;
    }

    private T getRowObjectByPosition(int rowPosition) {
        int rowIndex = this.selectionLayer.getRowIndexByPosition(rowPosition);
        if (rowIndex >= 0) {
            try {
                return this.rowDataProvider.getRowObject(rowIndex);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected int getRowPositionByRowObject(T rowObject) {
        int rowIndex = this.rowDataProvider.indexOfRowObject(rowObject);
        if (rowIndex == -1) {
            return -1;
        }
        return this.selectionLayer.getRowPositionByIndex(rowIndex);
    }

    @Override
    public Point getSelectionAnchor() {
        if (this.selectionAnchorPoint == null) {
            this.selectionsLock.readLock().lock();
            try {
                this.selectionAnchorPoint = this.createMarkerPoint(this.selectionAnchor);
            }
            finally {
                this.selectionsLock.readLock().unlock();
            }
        }
        return this.selectionAnchorPoint;
    }

    @Override
    public Point getLastSelectedCell() {
        this.selectionsLock.readLock().lock();
        try {
            Point point = this.createMarkerPoint(this.lastSelectedCell);
            return point;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    private Point createMarkerPoint(Selections.CellPosition<T> cellPosition) {
        if (cellPosition == null || cellPosition.getColumnPosition() == -1 && cellPosition.getRowObject() == null) {
            return this.createUndefinedPoint();
        }
        int rowPosition = this.getRowPositionByRowObject(cellPosition.getRowObject());
        return new Point(cellPosition.getColumnPosition().intValue(), rowPosition);
    }

    private Point createUndefinedPoint() {
        return new Point(-1, -1);
    }

    @Override
    public Rectangle getLastSelectedRegion() {
        this.selectionsLock.readLock().lock();
        try {
            if (this.lastSelectedRegion == null) {
                return null;
            }
            this.correctLastSelectedRegion();
            Rectangle rectangle = this.lastSelectedRegion;
            return rectangle;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    private void correctLastSelectedRegion() {
        this.lastSelectedRegion.y = this.getRowPositionByRowObject(this.lastSelectedRegionOriginRowObject);
    }

    @Override
    public void setSelectionAnchor(Point coordinate) {
        this.selectionsLock.writeLock().lock();
        try {
            this.selectionAnchor = coordinate.x == -1 && coordinate.y == -1 ? null : new Selections.CellPosition<T>(this.getRowObjectByPosition(coordinate.y), coordinate.x);
        }
        finally {
            this.selectionsLock.writeLock().unlock();
            this.selectionAnchorPoint = null;
        }
    }

    @Override
    public void setLastSelectedCell(Point coordinate) {
        this.selectionsLock.writeLock().lock();
        try {
            this.lastSelectedCell = coordinate.x == -1 && coordinate.y == -1 ? null : new Selections.CellPosition<T>(this.getRowObjectByPosition(coordinate.y), coordinate.x);
        }
        finally {
            this.selectionsLock.writeLock().unlock();
        }
    }

    @Override
    public void setLastSelectedRegion(Rectangle region) {
        if (region != null && this.lastSelectedRegion != null) {
            this.clearSelection(this.lastSelectedRegion);
        }
        this.selectionsLock.writeLock().lock();
        try {
            this.lastSelectedRegion = region;
            if (region != null) {
                this.lastSelectedRegionOriginRowObject = this.getRowObjectByPosition(region.y);
            }
        }
        finally {
            this.selectionsLock.writeLock().unlock();
        }
    }

    @Override
    public void setLastSelectedRegion(int x, int y, int width, int height) {
        this.selectionsLock.writeLock().lock();
        try {
            this.lastSelectedRegion.x = x;
            this.lastSelectedRegion.y = y;
            this.lastSelectedRegion.width = width;
            this.lastSelectedRegion.height = height;
            this.lastSelectedRegionOriginRowObject = this.getRowObjectByPosition(y);
        }
        finally {
            this.selectionsLock.writeLock().unlock();
        }
    }

    @Override
    public void handleLayerEvent(IStructuralChangeEvent event) {
        Collection<StructuralDiff> diffs;
        if (event instanceof ResizeStructuralRefreshEvent || event instanceof ColumnResizeEvent || event instanceof RowResizeEvent) {
            return;
        }
        this.selectionAnchorPoint = null;
        if (event.isHorizontalStructureChanged() && (diffs = event.getColumnDiffs()) != null) {
            ArrayList<Integer> removed = new ArrayList<Integer>();
            for (StructuralDiff columnDiff : diffs) {
                if (columnDiff.getDiffType() == null || !columnDiff.getDiffType().equals((Object)StructuralDiff.DiffTypeEnum.DELETE)) continue;
                Range beforePositionRange = columnDiff.getBeforePositionRange();
                int i = beforePositionRange.start;
                while (i < beforePositionRange.end) {
                    if (!(event instanceof ColumnReorderEvent)) {
                        this.selections.deselectColumn(i);
                    }
                    removed.add(i);
                    ++i;
                }
            }
            Collections.sort(removed);
            int mod = 0;
            Iterator<Object> iterator = removed.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                this.selections.updateColumnsForRemoval(i - mod);
                ++mod;
            }
            for (StructuralDiff columnDiff : diffs) {
                if (columnDiff.getDiffType() == null || !columnDiff.getDiffType().equals((Object)StructuralDiff.DiffTypeEnum.ADD)) continue;
                Range afterPositionRange = columnDiff.getAfterPositionRange();
                int i = afterPositionRange.start;
                while (i < afterPositionRange.end) {
                    this.selections.updateColumnsForAddition(i);
                    ++i;
                }
            }
        }
        if (event.isVerticalStructureChanged()) {
            ArrayList<Serializable> keysToRemove = new ArrayList<Serializable>();
            for (Selections.Row<T> row : this.selections.getRows()) {
                int rowIndex;
                if (this.ignoreVerticalChange(row) || (rowIndex = this.rowDataProvider.indexOfRowObject(row.getRowObject())) != -1 && this.selectionLayer.getRowPositionByIndex(rowIndex) != -1) continue;
                keysToRemove.add((Serializable)row.getId());
            }
            for (Serializable toRemove : keysToRemove) {
                this.selections.deselectRow(toRemove);
            }
        }
    }

    protected boolean ignoreVerticalChange(Selections.Row<T> row) {
        return false;
    }

    @Override
    public Class<IStructuralChangeEvent> getLayerEventClass() {
        return IStructuralChangeEvent.class;
    }
}

