/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.runtime.internal.evaluation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.utilities.LabelUtil;
import org.eclipse.qvtd.runtime.evaluation.AbstractConnection;
import org.eclipse.qvtd.runtime.evaluation.AbstractTransformer;
import org.eclipse.qvtd.runtime.evaluation.Connection;
import org.eclipse.qvtd.runtime.evaluation.Interval;
import org.eclipse.qvtd.runtime.evaluation.Invocation;
import org.eclipse.qvtd.runtime.evaluation.InvocationConstructor;

public abstract class AbstractIncrementalConnectionInternal
extends AbstractConnection
implements Connection.Incremental {
    protected static final int VALUE_INDEX = 0;
    protected static final int INDEX_INDEX = 1;
    protected static final int COUNT_INDEX = 2;
    protected final boolean debugConsumes = AbstractTransformer.CONSUMES.isActive();
    protected final @NonNull List<@NonNull InvocationConstructor> appenders = new ArrayList<InvocationConstructor>();
    protected final @NonNull List<@Nullable List<@NonNull Object>> listOfValueAndConsumingInvocations = new ArrayList<List<Object>>();

    protected AbstractIncrementalConnectionInternal(@NonNull Interval interval, @NonNull String name, @NonNull TypeId typeId) {
        super(interval, name, typeId);
    }

    @Override
    public void addAppender(@NonNull InvocationConstructor appender) {
        if (!this.appenders.contains(appender)) {
            this.appenders.add(appender);
        }
    }

    @Override
    public boolean addConsumer(@NonNull InvocationConstructor consumer) {
        if (!super.addConsumer(consumer)) {
            return false;
        }
        if (!this.listOfValueAndConsumingInvocations.isEmpty()) {
            this.queue();
        }
        return true;
    }

    @Override
    public synchronized void cleanup() {
        int iWrite = 0;
        int iRead = 0;
        while (iRead < this.listOfValueAndConsumingInvocations.size()) {
            List<@NonNull Object> valueAndConsumingInvocations = this.listOfValueAndConsumingInvocations.get(iRead);
            if (valueAndConsumingInvocations != null) {
                if (iWrite != iRead) {
                    this.listOfValueAndConsumingInvocations.set(iWrite, valueAndConsumingInvocations);
                }
                valueAndConsumingInvocations.set(1, iWrite);
                ++iWrite;
            }
            ++iRead;
        }
    }

    @Override
    public void consume(int elementIndex, @NonNull Invocation invocation) {
        List<@NonNull Object> valueAndConsumingInvocations = this.listOfValueAndConsumingInvocations.get(elementIndex);
        assert (valueAndConsumingInvocations != null);
        valueAndConsumingInvocations.add(invocation);
        if (this.debugConsumes) {
            AbstractTransformer.CONSUMES.println(this + " => " + LabelUtil.getLabel((Object)valueAndConsumingInvocations.get(0)));
        }
    }

    @Override
    public int debugGetSize() {
        int size = 0;
        for (List<Object> valueAndConsumingInvocations : this.listOfValueAndConsumingInvocations) {
            if (valueAndConsumingInvocations == null) continue;
            ++size;
        }
        return size;
    }

    @Override
    public @NonNull Iterable<@NonNull InvocationConstructor> getAppenders() {
        return this.appenders;
    }

    @Override
    public int getCapacity() {
        return this.listOfValueAndConsumingInvocations.size();
    }

    @Override
    public @Nullable Object getValue(int i) {
        List<@NonNull Object> valueAndConsumingInvocations = this.listOfValueAndConsumingInvocations.get(i);
        return valueAndConsumingInvocations != null ? valueAndConsumingInvocations.get(0) : null;
    }

    @Override
    public int getValues() {
        return this.listOfValueAndConsumingInvocations.size();
    }

    @Override
    public <T> @NonNull Iterable<T> typedIterable(Class<T> elementClass) {
        return new Iterable<T>(){

            @Override
            public @NonNull Iterator<@NonNull T> iterator() {
                return new ValueIterator();
            }
        };
    }

    protected final class ValueIterator<T>
    implements Iterator<T> {
        private final int size;
        private int cursor;

        protected ValueIterator() {
            this.size = AbstractIncrementalConnectionInternal.this.listOfValueAndConsumingInvocations.size();
            this.cursor = this.next(0);
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.size;
        }

        @Override
        public @NonNull T next() {
            List<@NonNull Object> valueAndConsumingInvocations = AbstractIncrementalConnectionInternal.this.listOfValueAndConsumingInvocations.get(this.cursor);
            if (valueAndConsumingInvocations == null) {
                throw new NoSuchElementException();
            }
            this.cursor = this.next(this.cursor + 1);
            Object castValue = valueAndConsumingInvocations.get(0);
            return (T)castValue;
        }

        private int next(int i) {
            while (i < this.size) {
                if (AbstractIncrementalConnectionInternal.this.listOfValueAndConsumingInvocations.get(i) != null) {
                    return i;
                }
                ++i;
            }
            return this.size;
        }
    }
}

