/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.formatting2;

import com.google.common.base.Predicate;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.xtend.core.formatting2.Line;
import org.eclipse.xtend.core.formatting2.RichStringToLineModel;
import org.eclipse.xtend.core.formatting2.SemanticWhitespace;
import org.eclipse.xtend.core.formatting2.TemplateWhitespace;
import org.eclipse.xtend.core.richstring.DefaultIndentationHandler;
import org.eclipse.xtend.core.richstring.RichStringProcessor;
import org.eclipse.xtend.core.xtend.RichString;
import org.eclipse.xtend.core.xtend.RichStringElseIf;
import org.eclipse.xtend.core.xtend.RichStringForLoop;
import org.eclipse.xtend.core.xtend.RichStringIf;
import org.eclipse.xtend.core.xtend.RichStringLiteral;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.FormatterPreferenceKeys;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatting;
import org.eclipse.xtext.formatting2.ITextReplacer;
import org.eclipse.xtext.formatting2.internal.HiddenRegionReplacer;
import org.eclipse.xtext.formatting2.regionaccess.IEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionExtensions;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.formatting2.regionaccess.internal.NodeEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.internal.TextSegment;
import org.eclipse.xtext.nodemodel.BidiTreeIterator;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.preferences.TypedPreferenceKey;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

@FinalFieldsConstructor
public class RichStringFormatter {
    private final Factory factory;
    @Extension
    private final ITextRegionExtensions _iTextRegionExtensions;

    protected void _format(RichString richString, IFormattableDocument doc) {
        boolean _tripleNotEquals;
        RichString _containerOfType = (RichString)EcoreUtil2.getContainerOfType((EObject)richString.eContainer(), RichString.class);
        boolean bl = _tripleNotEquals = _containerOfType != null;
        if (_tripleNotEquals) {
            return;
        }
        boolean _hasSyntaxError = this.hasSyntaxError(this._iTextRegionExtensions.regionForEObject((EObject)richString));
        if (_hasSyntaxError) {
            return;
        }
        ITextRegionAccess _textRegionAccess = this._iTextRegionExtensions.getTextRegionAccess();
        RichStringToLineModel impl = new RichStringToLineModel(_textRegionAccess);
        DefaultIndentationHandler _defaultIndentationHandler = new DefaultIndentationHandler();
        this.factory.richStringProcessor.process(richString, impl, _defaultIndentationHandler);
        impl.finish();
        EList _expressions = richString.getExpressions();
        for (XExpression e : _expressions) {
            this.format((EObject)e, doc);
        }
        List<Line> lines = impl.getModel().getLines();
        boolean canIndent = !lines.isEmpty() && StringExtensions.isNullOrEmpty((String)((Line)IterableExtensions.lastOrNull(lines)).getContent());
        for (Line line : lines) {
            boolean _not;
            boolean _greaterThan;
            int _rootIndentLenght = impl.getModel().getRootIndentLenght();
            boolean bl2 = _greaterThan = _rootIndentLenght > 0;
            if (!_greaterThan) continue;
            int _xifexpression = 0;
            _xifexpression = canIndent && Objects.equals(line, IterableExtensions.head(lines)) ? 1 : 0;
            int increaseIndentationChange = _xifexpression;
            int _xifexpression_1 = 0;
            _xifexpression_1 = canIndent && Objects.equals(line, IterableExtensions.lastOrNull(lines)) ? 1 : 0;
            int decraseIndentationChange = _xifexpression_1;
            int _xifexpression_2 = 0;
            boolean _isLeadingSemanticNewLine = line.isLeadingSemanticNewLine();
            if (_isLeadingSemanticNewLine) {
                int _offset = line.getOffset();
                int _newLineCharCount = line.getNewLineCharCount();
                _xifexpression_2 = _offset + _newLineCharCount;
            } else {
                _xifexpression_2 = line.getOffset();
            }
            int nloffset = _xifexpression_2;
            int i = Math.min(line.getIndentLength(), impl.getModel().getRootIndentLenght());
            int _xifexpression_3 = 0;
            boolean _isLeadingSemanticNewLine_1 = line.isLeadingSemanticNewLine();
            if (_isLeadingSemanticNewLine_1) {
                _xifexpression_3 = i;
            } else {
                int _newLineCharCount_1 = line.getNewLineCharCount();
                _xifexpression_3 = _newLineCharCount_1 + i;
            }
            int nllength = _xifexpression_3;
            boolean _isLeadingSemanticNewLine_2 = line.isLeadingSemanticNewLine();
            if (_isLeadingSemanticNewLine_2) {
                this.setNewLines(doc, nloffset, nllength, increaseIndentationChange, decraseIndentationChange, 0);
            } else {
                this.setNewLines(doc, nloffset, nllength, increaseIndentationChange, decraseIndentationChange, 1);
            }
            boolean _isEmpty = line.getChunks().isEmpty();
            boolean bl3 = _not = !_isEmpty;
            if (!_not) continue;
            int offset = nloffset + nllength;
            int _indentLength = line.getIndentLength();
            int _rootIndentLenght_1 = impl.getModel().getRootIndentLenght();
            int length = _indentLength - _rootIndentLenght_1;
            Functions.Function1 _function = chunk -> {
                CharSequence _switchResult = null;
                boolean _matched = false;
                if (chunk instanceof SemanticWhitespace) {
                    _matched = true;
                    _switchResult = ((SemanticWhitespace)chunk).getText();
                }
                if (!_matched && chunk instanceof TemplateWhitespace) {
                    _matched = true;
                    _switchResult = (CharSequence)doc.getFormatter().getPreference((TypedPreferenceKey)FormatterPreferenceKeys.indentation);
                }
                return _switchResult;
            };
            String text = IterableExtensions.join((Iterable)ListExtensions.map(line.getChunks(), (Functions.Function1)_function));
            if (length >= 0) {
                this.setSpace(doc, offset, length, text);
                continue;
            }
            RuntimeException _runtimeException = new RuntimeException("Programmatic error: length == " + String.valueOf((Object)length));
            EcorePlugin.INSTANCE.log((Object)_runtimeException);
        }
    }

    protected boolean _hasSyntaxError(IEObjectRegion region) {
        return false;
    }

    protected boolean _hasSyntaxError(NodeEObjectRegion region) {
        BidiTreeIterator i = region.getNode().getAsTreeIterable().iterator();
        while (i.hasNext()) {
            boolean _tripleNotEquals;
            SyntaxErrorMessage _syntaxErrorMessage = ((INode)i.next()).getSyntaxErrorMessage();
            boolean bl = _tripleNotEquals = _syntaxErrorMessage != null;
            if (!_tripleNotEquals) continue;
            return true;
        }
        return false;
    }

    protected void setNewLines(IFormattableDocument doc, int offset, int length, int indentationIncrease, int indentationDecrease, int newLines) {
        IHiddenRegionFormatting _createHiddenRegionFormatting = doc.getFormatter().createHiddenRegionFormatting();
        Procedures.Procedure1 _function = it -> {
            it.setIndentationIncrease(Integer.valueOf(indentationIncrease));
            it.setIndentationDecrease(Integer.valueOf(indentationDecrease));
            it.setNewLinesMin(Integer.valueOf(newLines));
            it.setNewLinesDefault(Integer.valueOf(newLines));
            it.setNewLinesMax(Integer.valueOf(newLines));
        };
        IHiddenRegionFormatting fmt = (IHiddenRegionFormatting)ObjectExtensions.operator_doubleArrow((Object)_createHiddenRegionFormatting, (Procedures.Procedure1)_function);
        AbstractFormatter2 _formatter = doc.getFormatter();
        ITextRegionAccess _textRegionAccess = this._iTextRegionExtensions.getTextRegionAccess();
        TextSegment _textSegment = new TextSegment(_textRegionAccess, offset, length);
        ITextReplacer replacer = _formatter.createWhitespaceReplacer((ITextSegment)_textSegment, fmt);
        doc.addReplacer(replacer);
    }

    protected void setSpace(IFormattableDocument doc, int offset, int length, String space) {
        IHiddenRegionFormatting _createHiddenRegionFormatting = doc.getFormatter().createHiddenRegionFormatting();
        Procedures.Procedure1 _function = it -> it.setSpace(space);
        IHiddenRegionFormatting fmt = (IHiddenRegionFormatting)ObjectExtensions.operator_doubleArrow((Object)_createHiddenRegionFormatting, (Procedures.Procedure1)_function);
        AbstractFormatter2 _formatter = doc.getFormatter();
        ITextRegionAccess _textRegionAccess = this._iTextRegionExtensions.getTextRegionAccess();
        TextSegment _textSegment = new TextSegment(_textRegionAccess, offset, length);
        ITextReplacer replacer = _formatter.createWhitespaceReplacer((ITextSegment)_textSegment, fmt);
        doc.addReplacer(replacer);
    }

    protected void _format(RichStringLiteral expr, IFormattableDocument doc) {
    }

    protected void _format(Void expr, IFormattableDocument doc) {
    }

    protected void formatIntoSingleLine(IFormattableDocument doc, EObject obj) {
        Predicate _function = it -> {
            boolean _xblockexpression = false;
            this.suppressLineWraps(it);
            _xblockexpression = true;
            return _xblockexpression;
        };
        doc.getFormatter().format((Object)obj, doc.withReplacerFilter(_function));
    }

    protected void _suppressLineWraps(ITextReplacer it) {
    }

    protected void _suppressLineWraps(HiddenRegionReplacer it) {
        this.suppressLineWraps(it.getFormatting());
    }

    protected void _suppressLineWraps(IHiddenRegionFormatting it) {
        boolean _tripleEquals;
        String _space = it.getSpace();
        boolean bl = _tripleEquals = _space == null;
        if (_tripleEquals) {
            it.setSpace(" ");
        }
        it.setNewLinesMin(null);
        it.setNewLinesDefault(null);
        it.setNewLinesMax(null);
        it.setAutowrap(null);
    }

    protected void _format(XExpression expr, @Extension IFormattableDocument doc) {
        Procedures.Procedure1 _function = it -> it.noSpace();
        doc.surround((EObject)expr, _function);
        this.formatIntoSingleLine(doc, (EObject)expr);
    }

    protected void _format(RichStringIf expr, @Extension IFormattableDocument doc) {
        Procedures.Procedure1 _function = it -> it.noSpace();
        Procedures.Procedure1 _function_1 = it -> it.oneSpace();
        doc.append(doc.prepend(this._iTextRegionExtensions.regionFor((EObject)expr).keyword("IF"), _function), _function_1);
        Procedures.Procedure1 _function_2 = it -> it.noSpace();
        doc.append((EObject)((RichStringElseIf)IterableExtensions.lastOrNull(expr.getElseIfs())), _function_2);
        this.formatIntoSingleLine(doc, (EObject)expr.getIf());
        this.format((EObject)expr.getThen(), doc);
        EList<RichStringElseIf> _elseIfs = expr.getElseIfs();
        for (RichStringElseIf elseif : _elseIfs) {
            this.format(elseif, doc);
        }
        Procedures.Procedure1 _function_3 = it -> it.noSpace();
        doc.surround(this._iTextRegionExtensions.regionFor((EObject)expr).keyword("ELSE"), _function_3);
        this.format((EObject)expr.getElse(), doc);
        Procedures.Procedure1 _function_4 = it -> it.noSpace();
        doc.surround(this._iTextRegionExtensions.regionFor((EObject)expr).keyword("ENDIF"), _function_4);
    }

    protected void _format(RichStringElseIf expr, @Extension IFormattableDocument doc) {
        Procedures.Procedure1 _function = it -> it.noSpace();
        Procedures.Procedure1 _function_1 = it -> it.oneSpace();
        doc.append(doc.prepend(this._iTextRegionExtensions.regionFor((EObject)expr).keyword("ELSEIF"), _function), _function_1);
        Procedures.Procedure1 _function_2 = it -> it.noSpace();
        doc.append((EObject)expr.getIf(), _function_2);
        this.formatIntoSingleLine(doc, (EObject)expr.getIf());
    }

    protected void _format(RichStringForLoop expr, @Extension IFormattableDocument doc) {
        Procedures.Procedure1 _function = it -> it.noSpace();
        Procedures.Procedure1 _function_1 = it -> it.oneSpace();
        doc.append(doc.prepend(this._iTextRegionExtensions.regionFor((EObject)expr).keyword("FOR"), _function), _function_1);
        Procedures.Procedure1 _function_2 = it -> it.oneSpace();
        Procedures.Procedure1 _function_3 = it -> it.oneSpace();
        doc.append(doc.prepend(this._iTextRegionExtensions.regionFor((EObject)expr).keyword(":"), _function_2), _function_3);
        this.formatIntoSingleLine(doc, (EObject)expr.getDeclaredParam());
        this.formatIntoSingleLine(doc, (EObject)expr.getForExpression());
        this.format((EObject)expr.getEachExpression(), doc);
        Procedures.Procedure1 _function_4 = it -> it.oneSpace();
        doc.surround(this._iTextRegionExtensions.regionFor((EObject)expr).keyword("BEFORE"), _function_4);
        this.formatIntoSingleLine(doc, (EObject)expr.getBefore());
        Procedures.Procedure1 _function_5 = it -> it.oneSpace();
        doc.surround(this._iTextRegionExtensions.regionFor((EObject)expr).keyword("SEPARATOR"), _function_5);
        this.formatIntoSingleLine(doc, (EObject)expr.getSeparator());
        Procedures.Procedure1 _function_6 = it -> it.oneSpace();
        doc.surround(this._iTextRegionExtensions.regionFor((EObject)expr).keyword("AFTER"), _function_6);
        this.formatIntoSingleLine(doc, (EObject)expr.getAfter());
        Procedures.Procedure1 _function_7 = it -> it.noSpace();
        doc.prepend((EObject)expr.getEachExpression(), _function_7);
        Procedures.Procedure1 _function_8 = it -> it.noSpace();
        doc.surround(this._iTextRegionExtensions.regionFor((EObject)expr).keyword("ENDFOR"), _function_8);
    }

    @XbaseGenerated
    public void format(EObject richString, IFormattableDocument doc) {
        if (richString instanceof RichString) {
            this._format((RichString)richString, doc);
            return;
        }
        if (richString instanceof RichStringForLoop) {
            this._format((RichStringForLoop)richString, doc);
            return;
        }
        if (richString instanceof RichStringLiteral) {
            this._format((RichStringLiteral)richString, doc);
            return;
        }
        if (richString instanceof RichStringIf) {
            this._format((RichStringIf)richString, doc);
            return;
        }
        if (richString instanceof RichStringElseIf) {
            this._format((RichStringElseIf)richString, doc);
            return;
        }
        if (richString instanceof XExpression) {
            this._format((XExpression)richString, doc);
            return;
        }
        if (richString == null) {
            this._format((Void)null, doc);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(richString, doc).toString());
    }

    @XbaseGenerated
    protected boolean hasSyntaxError(IEObjectRegion region) {
        if (region instanceof NodeEObjectRegion) {
            return this._hasSyntaxError((NodeEObjectRegion)region);
        }
        if (region != null) {
            return this._hasSyntaxError(region);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(region).toString());
    }

    @XbaseGenerated
    protected void suppressLineWraps(Object it) {
        if (it instanceof HiddenRegionReplacer) {
            this._suppressLineWraps((HiddenRegionReplacer)it);
            return;
        }
        if (it instanceof IHiddenRegionFormatting) {
            this._suppressLineWraps((IHiddenRegionFormatting)it);
            return;
        }
        if (it instanceof ITextReplacer) {
            this._suppressLineWraps((ITextReplacer)it);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    public RichStringFormatter(Factory factory, ITextRegionExtensions _iTextRegionExtensions) {
        this.factory = factory;
        this._iTextRegionExtensions = _iTextRegionExtensions;
    }

    public static class Factory {
        @Inject
        private RichStringProcessor richStringProcessor;

        public RichStringFormatter create(ITextRegionAccess regionAccess) {
            ITextRegionExtensions _extensions = regionAccess.getExtensions();
            return new RichStringFormatter(this, _extensions);
        }
    }
}

