/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.interpreter.impl;

import java.lang.reflect.Method;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.interpreter.IEvaluationContext;
import org.eclipse.xtext.xbase.interpreter.IEvaluationResult;
import org.eclipse.xtext.xbase.interpreter.IExpressionInterpreter;
import org.eclipse.xtext.xbase.interpreter.impl.AbstractClosureInvocationHandler;
import org.eclipse.xtext.xbase.interpreter.impl.InterpreterCanceledException;

public class ClosureInvocationHandler
extends AbstractClosureInvocationHandler {
    private final IExpressionInterpreter interpreter;
    private final IEvaluationContext context;
    private final XClosure closure;
    private CancelIndicator indicator;

    public ClosureInvocationHandler(XClosure closure, IEvaluationContext context, IExpressionInterpreter interpreter, CancelIndicator indicator) {
        this.closure = closure;
        this.context = context;
        this.interpreter = interpreter;
        this.indicator = indicator;
    }

    @Override
    protected Object doInvoke(Method method, Object[] args) throws Throwable {
        IEvaluationContext forkedContext = this.context.fork();
        if (args != null) {
            this.initializeClosureParameters(forkedContext, args);
        }
        IEvaluationResult result = this.interpreter.evaluate(this.closure.getExpression(), forkedContext, this.indicator);
        if (this.indicator.isCanceled()) {
            throw new InterpreterCanceledException();
        }
        if (result.getException() != null) {
            throw result.getException();
        }
        return result.getResult();
    }

    protected void initializeClosureParameters(IEvaluationContext context, Object[] args) {
        if (args.length != this.closure.getFormalParameters().size()) {
            throw new IllegalStateException("Number of arguments did not match. Expected: " + this.closure.getFormalParameters().size() + " but was: " + args.length);
        }
        int i = 0;
        for (JvmFormalParameter param : this.closure.getFormalParameters()) {
            context.newValue(QualifiedName.create((String)param.getName()), args[i]);
            ++i;
        }
    }

    @Override
    protected String proxyToString(Object proxy) {
        Class<?> interfaceType = proxy.getClass().getInterfaces()[0];
        return "Proxy for " + interfaceType.getName() + ": " + this.closure.toString();
    }
}

