/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.clustering;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Queue;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.builder.builderState.AbstractBuilderState;
import org.eclipse.xtext.builder.builderState.BuilderStateUtil;
import org.eclipse.xtext.builder.builderState.ResourceDescriptionsData;
import org.eclipse.xtext.builder.builderState.impl.ResourceDescriptionImpl;
import org.eclipse.xtext.builder.clustering.CopiedResourceDescription;
import org.eclipse.xtext.builder.clustering.CurrentDescriptions;
import org.eclipse.xtext.builder.impl.BuildData;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionDelta;
import org.eclipse.xtext.util.CancelIndicator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusteringBuilderState
extends AbstractBuilderState {
    private static final Logger LOGGER = Logger.getLogger(ClusteringBuilderState.class);
    @Inject
    private IResourceServiceProvider.Registry managerRegistry;
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.builder.clustering.ClusteringBuilderState.clusterSize")
    private int clusterSize = 20;

    @Override
    protected Collection<IResourceDescription.Delta> doUpdate(BuildData buildData, ResourceDescriptionsData newData, IProgressMonitor monitor) {
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Set<URI> toBeDeleted = buildData.getAndRemoveToBeDeleted();
        ResourceSet resourceSet = buildData.getResourceSet();
        CurrentDescriptions newState = new CurrentDescriptions(resourceSet, newData);
        this.writeNewResourceDescriptions(buildData, this, newState, (IProgressMonitor)progress.newChild(20));
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        for (URI uri : toBeDeleted) {
            newData.removeDescription(uri);
        }
        LinkedHashSet allRemainingURIs = Sets.newLinkedHashSet(newData.getAllURIs());
        allRemainingURIs.removeAll(buildData.getToBeUpdated());
        for (URI remainingURI : buildData.getAllRemainingURIs()) {
            allRemainingURIs.remove(remainingURI);
        }
        HashSet allDeltas = Sets.newHashSet();
        if (!toBeDeleted.isEmpty()) {
            for (URI uri : toBeDeleted) {
                IResourceDescription oldDescription = this.getResourceDescription(uri);
                if (oldDescription == null) continue;
                allDeltas.add(new DefaultResourceDescriptionDelta(oldDescription, null));
            }
        }
        Collection<IResourceDescription.Delta> pendingDeltas = buildData.getAndRemovePendingDeltas();
        allDeltas.addAll(pendingDeltas);
        this.queueAffectedResources(allRemainingURIs, this, newState, allDeltas, buildData, (IProgressMonitor)progress.newChild(1));
        SubMonitor subProgress = progress.newChild(80);
        CancelIndicator cancelMonitor = new CancelIndicator(){

            public boolean isCanceled() {
                return progress.isCanceled();
            }
        };
        int index = 1;
        Queue<URI> queue = buildData.getURIQueue();
        while (!queue.isEmpty()) {
            subProgress.setWorkRemaining(queue.size() + 2);
            ArrayList<DefaultResourceDescriptionDelta> newDeltas = new ArrayList<DefaultResourceDescriptionDelta>(this.clusterSize);
            ArrayList<IResourceDescription.Delta> changedDeltas = new ArrayList<IResourceDescription.Delta>(this.clusterSize);
            while (!queue.isEmpty() && newDeltas.size() < this.clusterSize) {
                DefaultResourceDescriptionDelta newDelta;
                block15: {
                    URI changedURI = queue.poll();
                    if (subProgress.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    if (toBeDeleted.contains(changedURI)) continue;
                    subProgress.subTask("Updating resource description " + index + " of " + (index + queue.size()));
                    Resource resource = null;
                    newDelta = null;
                    try {
                        IResourceDescription.Manager manager = this.getResourceDescriptionManager(changedURI);
                        if (manager != null) {
                            resource = resourceSet.getResource(changedURI, true);
                            EcoreUtil2.resolveLazyCrossReferences((Resource)resource, (CancelIndicator)cancelMonitor);
                            IResourceDescription description = manager.getResourceDescription(resource);
                            ResourceDescriptionImpl copiedDescription = BuilderStateUtil.create(description);
                            newDelta = manager.createDelta(this.getResourceDescription(changedURI), (IResourceDescription)copiedDescription);
                        }
                    }
                    catch (WrappedException ex) {
                        IResourceDescription oldDescription;
                        if (resourceSet.getURIConverter().exists(changedURI, Collections.emptyMap())) {
                            LOGGER.error((Object)("Error loading resource from: " + changedURI.toString()), (Throwable)ex);
                        }
                        if (resource != null) {
                            resourceSet.getResources().remove((Object)resource);
                        }
                        if ((oldDescription = this.getResourceDescription(changedURI)) == null) break block15;
                        newDelta = new DefaultResourceDescriptionDelta(oldDescription, null);
                    }
                }
                if (newDelta != null) {
                    newDeltas.add(newDelta);
                    if (newDelta.haveEObjectDescriptionsChanged()) {
                        changedDeltas.add((IResourceDescription.Delta)newDelta);
                    }
                    newState.register((IResourceDescription.Delta)newDelta);
                }
                subProgress.worked(1);
                ++index;
            }
            this.queueAffectedResources(allRemainingURIs, this, newState, changedDeltas, buildData, (IProgressMonitor)subProgress.newChild(1));
            this.updateMarkers(resourceSet, (ImmutableList<IResourceDescription.Delta>)ImmutableList.copyOf(newDeltas), (IProgressMonitor)subProgress.newChild(1));
            allDeltas.addAll(newDeltas);
            resourceSet.getResources().clear();
        }
        return allDeltas;
    }

    protected void writeNewResourceDescriptions(BuildData buildData, IResourceDescriptions oldState, CurrentDescriptions newState, IProgressMonitor monitor) {
        int index = 1;
        Set<URI> toBeUpdated = buildData.getToBeUpdated();
        ResourceSet resourceSet = buildData.getResourceSet();
        int n = toBeUpdated.size();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Write new resource descriptions", (int)n);
        for (URI uri : toBeUpdated) {
            block7: {
                if (subMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                subMonitor.subTask("Writing new resource description " + index + " of " + n);
                Resource resource = null;
                try {
                    resource = resourceSet.getResource(uri, true);
                    IResourceDescription.Manager manager = this.getResourceDescriptionManager(uri);
                    if (manager != null) {
                        IResourceDescription description = manager.getResourceDescription(resource);
                        CopiedResourceDescription copiedDescription = new CopiedResourceDescription(description);
                        newState.register((IResourceDescription.Delta)new DefaultResourceDescriptionDelta(oldState.getResourceDescription(uri), (IResourceDescription)copiedDescription));
                        buildData.queueURI(uri);
                    }
                }
                catch (WrappedException ex) {
                    IResourceDescription oldDescription;
                    if (resourceSet.getURIConverter().exists(uri, Collections.emptyMap())) {
                        LOGGER.error((Object)("Error loading resource from: " + uri.toString()), (Throwable)ex);
                    }
                    if (resource != null) {
                        resourceSet.getResources().remove((Object)resource);
                    }
                    if ((oldDescription = oldState.getResourceDescription(uri)) == null) break block7;
                    newState.register((IResourceDescription.Delta)new DefaultResourceDescriptionDelta(oldDescription, null));
                }
            }
            subMonitor.worked(1);
            if (++index % this.clusterSize != 0) continue;
            resourceSet.getResources().clear();
        }
        resourceSet.getResources().clear();
    }

    protected void queueAffectedResources(Set<URI> allRemainingURIs, IResourceDescriptions oldState, CurrentDescriptions newState, Collection<IResourceDescription.Delta> deltas, BuildData buildData, IProgressMonitor monitor) {
        if (deltas.isEmpty()) {
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)allRemainingURIs.size());
        Iterator<URI> iter = allRemainingURIs.iterator();
        while (iter.hasNext()) {
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            URI candidateURI = iter.next();
            IResourceDescription candidateDescription = oldState.getResourceDescription(candidateURI);
            IResourceDescription.Manager manager = this.getResourceDescriptionManager(candidateURI);
            if (candidateDescription == null || manager == null) {
                iter.remove();
            } else if (manager.isAffected(deltas, candidateDescription, (IResourceDescriptions)newState)) {
                buildData.queueURI(candidateURI);
                iter.remove();
            }
            progress.worked(1);
        }
    }

    protected IResourceDescription.Manager getResourceDescriptionManager(URI uri) {
        IResourceServiceProvider resourceServiceProvider = this.managerRegistry.getResourceServiceProvider(uri);
        if (resourceServiceProvider == null) {
            return null;
        }
        return resourceServiceProvider.getResourceDescriptionManager();
    }
}

