/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.typing;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.util.FeatureOverridesService;
import org.eclipse.xtext.common.types.util.SuperTypeCollector;
import org.eclipse.xtext.common.types.util.TypeArgumentContext;
import org.eclipse.xtext.common.types.util.TypeArgumentContextProvider;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xtend2.jvmmodel.IXtend2JvmAssociations;
import org.eclipse.xtext.xtend2.xtend2.XtendFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendOverridesService {
    @Inject
    private IXtend2JvmAssociations xtend2jvmAssociations;
    @Inject
    private FeatureOverridesService featureOverridesService;
    @Inject
    private TypeArgumentContextProvider typeArgumentContextProvider;
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private SuperTypeCollector superTypeCollector;

    public JvmOperation findOverriddenOperation(XtendFunction function) {
        JvmOperation inferredOperation = this.xtend2jvmAssociations.getDirectlyInferredOperation(function);
        if (inferredOperation == null) {
            return null;
        }
        return this.findOverriddenOperation(inferredOperation);
    }

    public JvmOperation findOverriddenOperation(JvmOperation operation) {
        JvmParameterizedTypeReference typeRef = this.typeReferences.createTypeRef((JvmType)operation.getDeclaringType(), new JvmTypeReference[0]);
        TypeArgumentContext typeArgumentContext = this.typeArgumentContextProvider.getReceiverContext((JvmTypeReference)typeRef);
        for (JvmOperation superOperation : this.allSuperOperations(operation.getDeclaringType())) {
            if (superOperation.getVisibility() == JvmVisibility.PRIVATE || !this.featureOverridesService.isOverridden((JvmFeature)operation, (JvmFeature)superOperation, typeArgumentContext, false)) continue;
            return superOperation;
        }
        return null;
    }

    protected Iterable<JvmOperation> allSuperOperations(JvmDeclaredType type) {
        Set superTypes = this.superTypeCollector.collectSuperTypes((JvmType)type);
        superTypes.add(this.typeReferences.getTypeForName(Object.class, (EObject)type, new JvmTypeReference[0]));
        Iterable result = Iterables.filter((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)superTypes, (Function)new Function<JvmTypeReference, Iterable<JvmFeature>>(){

            public Iterable<JvmFeature> apply(JvmTypeReference from) {
                return XtendOverridesService.this.featureOverridesService.getAllJvmFeatures(from);
            }
        })), JvmOperation.class);
        return result;
    }

    public JvmTypeReference getOverriddenReturnType(XtendFunction func) {
        JvmOperation operation = this.findOverriddenOperation(func);
        if (operation == null) {
            return null;
        }
        return operation.getReturnType();
    }
}

