/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.inject.Inject;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.generator.InMemoryFileSystemAccess;
import org.eclipse.xtext.junit4.util.ParseHelper;
import org.eclipse.xtext.junit4.validation.ValidationTestHelper;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.compiler.OnTheFlyJavaCompiler;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilationTestHelper {
    @Inject
    private OnTheFlyJavaCompiler javaCompiler;
    @Inject
    private ParseHelper<EObject> parseHelper;
    @Inject
    private ValidationTestHelper validationTestHelper;
    @Inject
    private IGenerator generator;

    public void assertCompilesTo(CharSequence source, final CharSequence expected) {
        final boolean[] called = new boolean[1];
        this.compile(source, new IAcceptor<Result>(){

            public void accept(Result r) {
                Assert.assertEquals((Object)expected.toString(), (Object)r.getGeneratedCode());
                called[0] = true;
            }
        });
        Assert.assertTrue((String)("Nothing was generated but the expectation was :\n" + expected), (boolean)called[0]);
    }

    public void compile(CharSequence source, IAcceptor<Result> acceptor) {
        try {
            final EObject parsed = this.parseHelper.parse(source);
            this.validationTestHelper.assertNoErrors(parsed);
            final InMemoryFileSystemAccess access = new InMemoryFileSystemAccess();
            this.generator.doGenerate(parsed.eResource(), (IFileSystemAccess)access);
            if (access.getFiles().size() != 1) {
                throw new AssertionError((Object)("Expected one generated Java source, but found " + access.getFiles().keySet()));
            }
            for (final Map.Entry e : access.getFiles().entrySet()) {
                acceptor.accept((Object)new Result(){

                    @Override
                    public String getGeneratedPath() {
                        return (String)e.getKey();
                    }

                    @Override
                    public String getGeneratedCode() {
                        return ((CharSequence)e.getValue()).toString();
                    }

                    @Override
                    public Resource getSource() {
                        return parsed.eResource();
                    }

                    @Override
                    public Class<?> getCompiledClass() {
                        String name = ((String)e.getKey()).substring("DEFAULT_OUTPUT".length(), ((String)e.getKey()).length() - ".java".length());
                        name = name.replace('/', '.');
                        Class<?> clazz = CompilationTestHelper.this.javaCompiler.compileToClass(name, ((CharSequence)e.getValue()).toString());
                        return clazz;
                    }

                    @Override
                    public Map<String, CharSequence> getAllGeneratedResources() {
                        return access.getFiles();
                    }
                });
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Result {
        public String getGeneratedPath();

        public String getGeneratedCode();

        public Resource getSource();

        public Class<?> getCompiledClass();

        public Map<String, CharSequence> getAllGeneratedResources();
    }
}

