/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.resource;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.DefaultLocationInFileProvider;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegionWithLineInformation;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.conversion.StaticQualifierValueConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class XbaseLocationInFileProvider
extends DefaultLocationInFileProvider {
    @Inject
    private StaticQualifierValueConverter staticQualifierValueConverter;

    public ITextRegion getSignificantTextRegion(EObject element) {
        if (element instanceof XSwitchExpression && ((XSwitchExpression)element).getLocalVarName() != null) {
            return this.getLocationOfAttribute(element, XbasePackage.Literals.XSWITCH_EXPRESSION__LOCAL_VAR_NAME, -1, true);
        }
        return super.getSignificantTextRegion(element);
    }

    protected ITextRegion getLocationOfCrossReference(EObject owner, EReference reference, int indexInList, boolean isSignificant) {
        List nodes;
        if (owner instanceof XFeatureCall && reference == XbasePackage.Literals.XFEATURE_CALL__DECLARING_TYPE && isSignificant && !(nodes = NodeModelUtils.findNodesForFeature((EObject)owner, (EStructuralFeature)reference)).isEmpty()) {
            INode qualifierNode = (INode)nodes.get(0);
            ITextRegion result = ITextRegion.EMPTY_REGION;
            INode pending = null;
            String delimiter = this.staticQualifierValueConverter.getStringNamespaceDelimiter();
            for (INode node : qualifierNode.getLeafNodes()) {
                int length;
                if (this.isHidden(node) || (length = node.getLength()) == 0) continue;
                if (pending != null) {
                    result.merge((ITextRegion)new TextRegionWithLineInformation(pending.getOffset(), length, pending.getStartLine() - 1, pending.getEndLine() - 1));
                    pending = null;
                }
                if (delimiter.equals(node.getText())) {
                    pending = node;
                    continue;
                }
                result = result.merge((ITextRegion)new TextRegionWithLineInformation(node.getOffset(), length, node.getStartLine() - 1, node.getEndLine() - 1));
            }
            return result;
        }
        return super.getLocationOfCrossReference(owner, reference, indexInList, isSignificant);
    }

    protected List<INode> getLocationNodes(EObject obj) {
        if (obj instanceof XMemberFeatureCall || obj instanceof XAssignment || obj instanceof XFeatureCall) {
            ArrayList resultNodes = Lists.newArrayList();
            ICompositeNode startNode = this.findNodeFor(obj);
            boolean crossRefConsumed = false;
            for (INode child : startNode.getChildren()) {
                if (crossRefConsumed) {
                    resultNodes.add(child);
                    continue;
                }
                EObject grammarElement = child.getGrammarElement();
                if (!(grammarElement instanceof CrossReference)) continue;
                Assignment assignment = GrammarUtil.containingAssignment((EObject)grammarElement);
                if (!XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE.getName().equals(assignment.getFeature())) continue;
                crossRefConsumed = true;
                resultNodes.add(child);
            }
            if (!resultNodes.isEmpty()) {
                return resultNodes;
            }
        }
        return super.getLocationNodes(obj);
    }

    protected boolean useKeyword(Keyword keyword, EObject context) {
        return false;
    }
}

