/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractMetamodelDeclaration;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.ReferencedMetamodel;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.UnorderedGroup;
import org.eclipse.xtext.nodemodel.BidiTreeIterator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xtext.CurrentTypeFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrammarUtil {
    public static String getClasspathRelativePathToXmi(Grammar grammar) {
        return String.valueOf(GrammarUtil.getLanguageId(grammar).replace('.', '/')) + ".xmi";
    }

    public static String getLanguageId(Grammar g) {
        return g.getName();
    }

    public static String getName(Grammar g) {
        if (Strings.isEmpty((String)g.getName())) {
            return null;
        }
        String[] splitted = g.getName().split("\\.");
        return splitted[splitted.length - 1];
    }

    public static String getNamespace(Grammar g) {
        if (Strings.isEmpty((String)g.getName())) {
            return null;
        }
        String[] splitted = g.getName().split("\\.");
        return Strings.concat((String)".", Arrays.asList(splitted), (int)1);
    }

    public static Grammar getGrammar(EObject grammarElement) {
        EObject root = EcoreUtil.getRootContainer((EObject)grammarElement);
        if (root instanceof Grammar) {
            return (Grammar)root;
        }
        return null;
    }

    public static AbstractRule containingRule(EObject e) {
        return EcoreUtil2.getContainerOfType(e, AbstractRule.class);
    }

    public static ParserRule containingParserRule(EObject e) {
        return EcoreUtil2.getContainerOfType(e, ParserRule.class);
    }

    public static EnumRule containingEnumRule(EObject e) {
        return EcoreUtil2.getContainerOfType(e, EnumRule.class);
    }

    public static Assignment containingAssignment(EObject e) {
        return EcoreUtil2.getContainerOfType(e, Assignment.class);
    }

    public static Group containingGroup(EObject e) {
        return EcoreUtil2.getContainerOfType(e, Group.class);
    }

    public static UnorderedGroup containingUnorderedGroup(EObject e) {
        return EcoreUtil2.getContainerOfType(e, UnorderedGroup.class);
    }

    public static CrossReference containingCrossReference(EObject e) {
        return EcoreUtil2.getContainerOfType(e, CrossReference.class);
    }

    public static List<Action> containedActions(EObject e) {
        List<Action> allContentsOfType = EcoreUtil2.getAllContentsOfType(e, Action.class);
        return allContentsOfType;
    }

    public static List<RuleCall> containedRuleCalls(EObject e) {
        return EcoreUtil2.getAllContentsOfType(e, RuleCall.class);
    }

    public static List<Assignment> containedAssignments(EObject e) {
        return EcoreUtil2.getAllContentsOfType(e, Assignment.class);
    }

    public static List<Keyword> containedKeywords(EObject e) {
        return EcoreUtil2.getAllContentsOfType(e, Keyword.class);
    }

    public static List<AbstractElement> containedAbstractElements(EObject e) {
        return EcoreUtil2.getAllContentsOfType(e, AbstractElement.class);
    }

    public static List<CrossReference> containedCrossReferences(EObject e) {
        return EcoreUtil2.getAllContentsOfType(e, CrossReference.class);
    }

    public static boolean containsAssignedAction(ParserRule rule) {
        TreeIterator ti = rule.eAllContents();
        while (ti.hasNext()) {
            EObject obj = (EObject)ti.next();
            if (!(obj instanceof Action) || ((Action)obj).getFeature() == null) continue;
            return true;
        }
        return false;
    }

    public static List<AbstractElement> elementsBeforeThisInContainingGroup(AbstractElement _this) {
        Group g = GrammarUtil.containingGroup(_this);
        ArrayList<AbstractElement> result = new ArrayList<AbstractElement>();
        for (AbstractElement ae : g.getElements()) {
            if (ae == _this || EcoreUtil2.eAllContentsAsList(ae).contains(_this)) {
                return result;
            }
            result.add(ae);
        }
        return result;
    }

    public static boolean isParserRuleCall(EObject grammarElement) {
        if (grammarElement instanceof RuleCall) {
            AbstractRule calledRule = ((RuleCall)grammarElement).getRule();
            return calledRule != null && calledRule instanceof ParserRule;
        }
        return false;
    }

    public static boolean isEObjectRuleCall(EObject grammarElement) {
        if (grammarElement instanceof RuleCall) {
            AbstractRule calledRule = ((RuleCall)grammarElement).getRule();
            return calledRule != null && calledRule instanceof ParserRule && calledRule.getType().getClassifier() instanceof EClass;
        }
        return false;
    }

    public static boolean isEObjectRule(EObject grammarElement) {
        return grammarElement instanceof ParserRule && ((ParserRule)grammarElement).getType().getClassifier() instanceof EClass;
    }

    public static boolean isUnassignedParserRuleCall(EObject ele) {
        if (!GrammarUtil.isParserRuleCall(ele)) {
            return false;
        }
        return GrammarUtil.containingAssignment(ele) == null;
    }

    public static boolean isUnassignedEObjectRuleCall(EObject ele) {
        if (!GrammarUtil.isEObjectRuleCall(ele)) {
            return false;
        }
        return GrammarUtil.containingAssignment(ele) == null;
    }

    public static boolean isAssignedEObjectRuleCall(EObject ele) {
        if (!GrammarUtil.isEObjectRuleCall(ele)) {
            return false;
        }
        return GrammarUtil.containingAssignment(ele) != null;
    }

    public static boolean isDatatypeRuleCall(EObject grammarElement) {
        if (grammarElement instanceof RuleCall) {
            AbstractRule calledRule = ((RuleCall)grammarElement).getRule();
            return calledRule != null && calledRule instanceof ParserRule && calledRule.getType().getClassifier() instanceof EDataType;
        }
        return false;
    }

    public static boolean isEnumRuleCall(EObject grammarElement) {
        if (grammarElement instanceof RuleCall) {
            AbstractRule calledRule = ((RuleCall)grammarElement).getRule();
            return calledRule != null && calledRule instanceof EnumRule;
        }
        return false;
    }

    public static boolean isTerminalRuleCall(EObject grammarElement) {
        if (grammarElement instanceof RuleCall) {
            AbstractRule calledRule = ((RuleCall)grammarElement).getRule();
            return calledRule != null && calledRule instanceof TerminalRule;
        }
        return false;
    }

    public static AbstractRule findRuleForName(Grammar grammar, String ruleName) {
        if (ruleName == null) {
            return null;
        }
        List<AbstractRule> rules = GrammarUtil.allRules(grammar);
        for (AbstractRule abstractRule : rules) {
            if (!ruleName.equals(abstractRule.getName())) continue;
            return abstractRule;
        }
        return null;
    }

    public static List<Grammar> allUsedGrammars(Grammar grammar) {
        ArrayList<Grammar> grammars = new ArrayList<Grammar>();
        GrammarUtil.collectAllUsedGrammars(grammars, grammar);
        return grammars;
    }

    private static void collectAllUsedGrammars(List<Grammar> grammars, Grammar grammar) {
        grammars.addAll((Collection<Grammar>)grammar.getUsedGrammars());
        for (Grammar g : grammar.getUsedGrammars()) {
            GrammarUtil.collectAllUsedGrammars(grammars, g);
        }
    }

    public static List<AbstractRule> allRules(Grammar grammar) {
        ArrayList<AbstractRule> result = new ArrayList<AbstractRule>();
        HashSet<String> names = new HashSet<String>();
        HashSet<Grammar> grammars = new HashSet<Grammar>();
        GrammarUtil.collectAllRules(grammar, result, grammars, names);
        return result;
    }

    private static void collectAllRules(Grammar grammar, List<AbstractRule> result, Set<Grammar> visitedGrammars, Set<String> knownRulenames) {
        if (!visitedGrammars.add(grammar)) {
            return;
        }
        for (AbstractRule rule : grammar.getRules()) {
            if (!knownRulenames.add(rule.getName())) continue;
            result.add(rule);
        }
        for (Grammar usedGrammar : grammar.getUsedGrammars()) {
            GrammarUtil.collectAllRules(usedGrammar, result, visitedGrammars, knownRulenames);
        }
    }

    public static List<ParserRule> allParserRules(Grammar _this) {
        return EcoreUtil2.typeSelect(GrammarUtil.allRules(_this), ParserRule.class);
    }

    public static List<EnumRule> allEnumRules(Grammar _this) {
        return EcoreUtil2.typeSelect(GrammarUtil.allRules(_this), EnumRule.class);
    }

    public static List<TerminalRule> allTerminalRules(Grammar _this) {
        return EcoreUtil2.typeSelect(GrammarUtil.allRules(_this), TerminalRule.class);
    }

    public static List<AbstractMetamodelDeclaration> allMetamodelDeclarations(Grammar grammar) {
        ArrayList<AbstractMetamodelDeclaration> result = new ArrayList<AbstractMetamodelDeclaration>();
        HashSet<Pair<String, String>> pairs = new HashSet<Pair<String, String>>();
        HashSet<Grammar> grammars = new HashSet<Grammar>();
        GrammarUtil.collectAllMetamodelDeclarations(grammar, result, pairs, grammars);
        return result;
    }

    private static void collectAllMetamodelDeclarations(Grammar grammar, List<AbstractMetamodelDeclaration> result, Set<Pair<String, String>> knownAliases, Set<Grammar> visitedGrammars) {
        if (!visitedGrammars.add(grammar)) {
            return;
        }
        for (AbstractMetamodelDeclaration decl : grammar.getMetamodelDeclarations()) {
            if (decl.getEPackage() == null) {
                result.add(decl);
                continue;
            }
            if (!knownAliases.add(GrammarUtil.getURIAliasPair(decl))) continue;
            result.add(decl);
        }
        for (Grammar usedGrammar : grammar.getUsedGrammars()) {
            GrammarUtil.collectAllMetamodelDeclarations(usedGrammar, result, knownAliases, visitedGrammars);
        }
    }

    private static Pair<String, String> getURIAliasPair(AbstractMetamodelDeclaration decl) {
        return Tuples.create((Object)decl.getEPackage().getNsURI(), (Object)Strings.emptyIfNull((String)decl.getAlias()));
    }

    public static String getTypeRefName(TypeRef typeRef) {
        if (typeRef.getClassifier() != null) {
            return typeRef.getClassifier().getName();
        }
        ICompositeNode node = NodeModelUtils.getNode(typeRef);
        if (node != null) {
            BidiTreeIterator<INode> leafNodes = node.getAsTreeIterable().iterator();
            while (leafNodes.hasPrevious()) {
                INode previous = (INode)leafNodes.previous();
                if (!(previous instanceof ILeafNode) || ((ILeafNode)previous).isHidden()) continue;
                return previous.getText();
            }
        }
        return null;
    }

    public static boolean isAssigned(EObject e) {
        return GrammarUtil.containingAssignment(e) != null;
    }

    public static boolean isAssignedAction(EObject e) {
        return e instanceof Action && ((Action)e).getFeature() != null;
    }

    public static boolean isUnassignedAction(EObject e) {
        return e instanceof Action && ((Action)e).getFeature() == null;
    }

    public static Set<String> getAllKeywords(Grammar g) {
        HashSet<String> kws = new HashSet<String>();
        List<ParserRule> rules = GrammarUtil.allParserRules(g);
        for (ParserRule parserRule : rules) {
            List<Keyword> list = EcoreUtil2.typeSelect(EcoreUtil2.eAllContentsAsList(parserRule), Keyword.class);
            for (Keyword keyword : list) {
                kws.add(keyword.getValue());
            }
        }
        List<EnumRule> enumRules = GrammarUtil.allEnumRules(g);
        for (EnumRule enumRule : enumRules) {
            List<Keyword> list = EcoreUtil2.typeSelect(EcoreUtil2.eAllContentsAsList(enumRule), Keyword.class);
            for (Keyword keyword : list) {
                kws.add(keyword.getValue());
            }
        }
        return kws;
    }

    public static boolean isBooleanAssignment(Assignment a) {
        return "?=".equals(a.getOperator());
    }

    public static boolean isSingleAssignment(Assignment a) {
        return "=".equals(a.getOperator());
    }

    public static boolean isMultipleAssignment(Assignment a) {
        return "+=".equals(a.getOperator());
    }

    public static boolean isMultipleAssignment(Action a) {
        return "+=".equals(a.getOperator());
    }

    public static boolean isOptionalCardinality(AbstractElement e) {
        return e.getCardinality() != null && (e.getCardinality().equals("?") || e.getCardinality().equals("*"));
    }

    public static boolean isMultipleCardinality(AbstractElement e) {
        return GrammarUtil.isOneOrMoreCardinality(e) || GrammarUtil.isAnyCardinality(e);
    }

    public static boolean isOneOrMoreCardinality(AbstractElement e) {
        return e.getCardinality() != null && e.getCardinality().equals("+");
    }

    public static boolean isAnyCardinality(AbstractElement e) {
        return e.getCardinality() != null && e.getCardinality().equals("*");
    }

    public static boolean isDatatypeRule(ParserRule parserRule) {
        return parserRule.getType() != null && parserRule.getType().getClassifier() instanceof EDataType;
    }

    public static boolean isDatatypeRule(AbstractRule abstractRule) {
        return abstractRule instanceof ParserRule && GrammarUtil.isDatatypeRule((ParserRule)abstractRule);
    }

    public static EReference getReference(CrossReference ref, EClass referenceOwner) {
        String feature = GrammarUtil.containingAssignment(ref).getFeature();
        EStructuralFeature result = referenceOwner.getEStructuralFeature(feature);
        if (result instanceof EReference && !((EReference)result).isContainment()) {
            return (EReference)result;
        }
        return null;
    }

    public static EReference getReference(CrossReference crossRef) {
        EClassifier referenceOwner = GrammarUtil.findCurrentType(crossRef);
        if (referenceOwner instanceof EClass) {
            return GrammarUtil.getReference(crossRef, (EClass)referenceOwner);
        }
        return null;
    }

    public static EClassifier findCurrentType(AbstractElement element) {
        return new CurrentTypeFinder().findCurrentTypeAfter(element);
    }

    public static Collection<EPackage> allEPackagesToValidate(Grammar _this) {
        Iterable allTypeRefs = Iterables.concat((Iterable)Iterables.transform(GrammarUtil.allParserRules(_this), (Function)new Function<ParserRule, Iterable<TypeRef>>(){

            public Iterable<TypeRef> apply(ParserRule from) {
                return EcoreUtil2.eAllOfType(from, TypeRef.class);
            }
        }));
        return Sets.newLinkedHashSet((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)allTypeRefs, (Predicate)new Predicate<TypeRef>(){

            public boolean apply(TypeRef input) {
                return !(input.eContainer() instanceof CrossReference) && input.getClassifier() instanceof EClass;
            }
        }), (Function)new Function<TypeRef, EPackage>(){

            public EPackage apply(TypeRef from) {
                return from.getClassifier().getEPackage();
            }
        }));
    }

    public static EDataType findEString(Grammar grammar) {
        EClassifier result = GrammarUtil.findEClassifierByName(grammar, "http://www.eclipse.org/emf/2002/Ecore", EcorePackage.Literals.ESTRING.getName());
        if (result instanceof EDataType) {
            return (EDataType)result;
        }
        return null;
    }

    public static EDataType findEBoolean(Grammar grammar) {
        EClassifier result = GrammarUtil.findEClassifierByName(grammar, "http://www.eclipse.org/emf/2002/Ecore", EcorePackage.Literals.EBOOLEAN.getName());
        if (result instanceof EDataType) {
            return (EDataType)result;
        }
        return null;
    }

    public static EClass findEObject(Grammar grammar) {
        EClassifier result = GrammarUtil.findEClassifierByName(grammar, "http://www.eclipse.org/emf/2002/Ecore", EcorePackage.Literals.EOBJECT.getName());
        if (result instanceof EClass) {
            return (EClass)result;
        }
        return null;
    }

    private static EClassifier findEClassifierByName(Grammar grammar, String nsURI, String name) {
        if (grammar != null) {
            for (AbstractMetamodelDeclaration declaration : GrammarUtil.allMetamodelDeclarations(grammar)) {
                EClassifier result;
                EPackage referencedPackage;
                if (!(declaration instanceof ReferencedMetamodel) || (referencedPackage = declaration.getEPackage()) == null || referencedPackage.eIsProxy() || !nsURI.equals(referencedPackage.getNsURI()) || (result = referencedPackage.getEClassifier(name)) == null) continue;
                return result;
            }
        }
        return null;
    }
}

