/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.hover;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.typing.XtendOverridesService;
import org.eclipse.xtend.core.xtend.XtendAnnotationTarget;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendParameter;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationsPackage;
import org.eclipse.xtext.xbase.ui.hover.HoverLinkHelper;
import org.eclipse.xtext.xbase.ui.hover.XbaseHoverDocumentationProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendHoverDocumentationProvider
extends XbaseHoverDocumentationProvider {
    @Inject
    private IXtendJvmAssociations associations;
    @Inject
    private XtendOverridesService overridesService;

    protected JvmDeclaredType getDeclaringType(EObject eObject) {
        if (eObject instanceof XtendFunction) {
            JvmOperation jvmOperation = this.associations.getDirectlyInferredOperation((XtendFunction)eObject);
            return super.getDeclaringType((EObject)jvmOperation);
        }
        return super.getDeclaringType(eObject);
    }

    protected void addAnnotations(EObject object) {
        if (object instanceof XtendAnnotationTarget) {
            for (XAnnotation annotation : ((XtendAnnotationTarget)object).getAnnotations()) {
                JvmType annotationType = annotation.getAnnotationType();
                if (annotationType == null || annotationType.eIsProxy() || !(annotationType instanceof JvmAnnotationType)) continue;
                this.buffer.append("@");
                this.buffer.append(HoverLinkHelper.createLinkWithLabel((String)"eclipse-xtext-doc", (URI)EcoreUtil.getURI((EObject)annotationType), (String)annotation.getAnnotationType().getSimpleName()));
                EList elementValuePairs = annotation.getElementValuePairs();
                if (elementValuePairs.size() > 0) {
                    this.buffer.append("(");
                    List findNodesForFeature = NodeModelUtils.findNodesForFeature((EObject)annotation, (EStructuralFeature)XAnnotationsPackage.eINSTANCE.getXAnnotation_ElementValuePairs());
                    if (findNodesForFeature.size() > 0) {
                        this.buffer.append(((INode)findNodesForFeature.get(0)).getText());
                    }
                    this.buffer.append(")");
                }
                this.buffer.append("<br>");
            }
        } else {
            super.addAnnotations(object);
        }
    }

    protected void handleSuperMethodReferences(EObject context) {
        XtendFunction function;
        if (context instanceof XtendFunction && (function = (XtendFunction)context).isOverride()) {
            JvmOperation overwritten = this.overridesService.findOverriddenOperation(function);
            this.buffer.append("<div>");
            this.buffer.append("<b>");
            this.buffer.append("Overrides:");
            this.buffer.append("</b> ");
            this.buffer.append(this.createMethodInTypeLinks(overwritten));
            this.buffer.append("</div>");
        }
    }

    protected List<String> initParameterNames() {
        List result = super.initParameterNames();
        if (this.context instanceof XtendFunction) {
            for (XtendParameter param : ((XtendFunction)this.context).getParameters()) {
                result.add(param.getName());
            }
        }
        if (this.context instanceof XtendConstructor) {
            for (XtendParameter param : ((XtendConstructor)this.context).getParameters()) {
                result.add(param.getName());
            }
        }
        return result;
    }

    protected Map<String, URI> initExceptionNamesToURI() {
        Map result = super.initExceptionNamesToURI();
        if (this.context instanceof XtendFunction) {
            for (JvmTypeReference exception : ((XtendFunction)this.context).getExceptions()) {
                result.put(exception.getSimpleName(), EcoreUtil.getURI((EObject)exception.getType()));
            }
        }
        if (this.context instanceof XtendConstructor) {
            for (JvmTypeReference exception : ((XtendConstructor)this.context).getExceptions()) {
                result.put(exception.getSimpleName(), EcoreUtil.getURI((EObject)exception.getType()));
            }
        }
        return result;
    }

    protected List<EObject> getFilteredDerivedElements(EObject o, EClass type) {
        List filteredDerivedElements = super.getFilteredDerivedElements(o, type);
        if (filteredDerivedElements.size() > 1) {
            return filteredDerivedElements;
        }
        return Lists.newArrayList();
    }

    protected List<EObject> getFilteredSourceElements(EObject o, EClass type) {
        List filteredSourceElements = super.getFilteredSourceElements(o, type);
        if (filteredSourceElements.size() > 1) {
            return filteredSourceElements;
        }
        return Lists.newArrayList();
    }
}

