/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.imports;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.imports.ConflictResolver;
import org.eclipse.xtext.xbase.imports.IUnresolvedTypeResolver;
import org.eclipse.xtext.xbase.imports.NonOverridableTypesProvider;
import org.eclipse.xtext.xbase.imports.RewritableImportSection;
import org.eclipse.xtext.xbase.imports.TypeUsage;
import org.eclipse.xtext.xbase.imports.TypeUsageCollector;
import org.eclipse.xtext.xbase.imports.TypeUsages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportOrganizer {
    @Inject
    private RewritableImportSection.Factory importSectionFactory;
    @Inject
    private Provider<TypeUsageCollector> typeUsageCollectorProvider;
    @Inject
    private ConflictResolver conflictResolver;
    @Inject
    private NonOverridableTypesProvider nonOverridableTypesProvider;
    @Inject(optional=true)
    private IUnresolvedTypeResolver unresolvedTypeResolver;

    public List<ReplaceRegion> getOrganizedImportChanges(XtextResource resource) {
        JvmDeclaredType type;
        String text;
        TypeUsageCollector typeUsageCollector = (TypeUsageCollector)this.typeUsageCollectorProvider.get();
        TypeUsages typeUsages = typeUsageCollector.collectTypeUsages(resource);
        if (this.unresolvedTypeResolver != null) {
            this.unresolvedTypeResolver.resolve(typeUsages, resource);
        }
        Map<String, JvmDeclaredType> name2type = this.conflictResolver.resolveConflicts(typeUsages, this.nonOverridableTypesProvider, resource);
        RewritableImportSection newImportSection = this.importSectionFactory.createNewEmpty(resource);
        ArrayList replaceRegions = Lists.newArrayList();
        for (Map.Entry<String, JvmDeclaredType> entry : name2type.entrySet()) {
            Iterable<TypeUsage> usages;
            text = entry.getKey();
            type = entry.getValue();
            if (!this.needsImport(type, text, this.nonOverridableTypesProvider, usages = typeUsages.getUsages(type))) continue;
            newImportSection.addImport(type);
        }
        for (Map.Entry<String, JvmDeclaredType> entry : name2type.entrySet()) {
            text = entry.getKey();
            type = entry.getValue();
            String packageLocalName = this.getPackageLocalName(type);
            Iterable<TypeUsage> usages = typeUsages.getUsages(type);
            for (TypeUsage usage : usages) {
                JvmDeclaredType importedType;
                if (Strings.equal((String)usage.getContextPackageName(), (String)type.getPackageName()) && (importedType = newImportSection.getImportedType(packageLocalName)) == null) {
                    text = packageLocalName;
                }
                if (Strings.equal((String)usage.getText(), (String)text)) continue;
                replaceRegions.add(new ReplaceRegion(usage.getTextRegion(), text));
            }
        }
        for (JvmDeclaredType staticImport : typeUsages.getStaticImports()) {
            newImportSection.addStaticImport(staticImport);
        }
        for (JvmDeclaredType extensionImport : typeUsages.getExtensionImports()) {
            newImportSection.addStaticExtensionImport(extensionImport);
        }
        replaceRegions.addAll(newImportSection.rewrite());
        return replaceRegions;
    }

    protected String getPackageLocalName(JvmDeclaredType type) {
        String packageName = type.getPackageName();
        if (Strings.isEmpty((String)packageName)) {
            return type.getIdentifier();
        }
        return type.getIdentifier().substring(packageName.length() + 1);
    }

    protected boolean needsImport(JvmDeclaredType type, String name, NonOverridableTypesProvider nonOverridableTypesProvider, Iterable<TypeUsage> usages) {
        return !type.getIdentifier().equals(name) && !this.isUsedInLocalContextOnly(type, usages, nonOverridableTypesProvider, name);
    }

    protected boolean isUsedInLocalContextOnly(JvmDeclaredType type, Iterable<TypeUsage> usages, NonOverridableTypesProvider nonOverridableTypesProvider, String name) {
        for (TypeUsage usage : usages) {
            if (nonOverridableTypesProvider.getVisibleType(usage.getContext(), name) != null || Strings.equal((String)usage.getContextPackageName(), (String)type.getPackageName())) continue;
            return false;
        }
        return true;
    }
}

