/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.serializer;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.SimpleScope;
import org.eclipse.xtext.scoping.impl.SingletonScope;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XUnaryOperation;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureNames;
import org.eclipse.xtext.xbase.scoping.batch.XbaseBatchScopeProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;

public class SerializerScopeProvider
extends XbaseBatchScopeProvider
implements IFeatureNames {
    @Inject
    private OperatorMapping operatorMapping;

    public IScope getScope(EObject context, EReference reference) {
        if (this.isFeatureCallScope(reference)) {
            IScope result = this.createFeatureCallSerializationScope(context);
            return result;
        }
        return super.getScope(context, reference);
    }

    public IScope createFeatureCallSerializationScope(EObject context) {
        if (!(context instanceof XAbstractFeatureCall)) {
            return IScope.NULLSCOPE;
        }
        XAbstractFeatureCall call = (XAbstractFeatureCall)context;
        JvmIdentifiableElement feature = call.getFeature();
        if (feature instanceof JvmType) {
            return new SingletonScope(EObjectDescription.create((QualifiedName)THIS, (EObject)feature), IScope.NULLSCOPE);
        }
        if (feature instanceof JvmConstructor) {
            return new SingletonScope(EObjectDescription.create((QualifiedName)THIS, (EObject)feature), IScope.NULLSCOPE);
        }
        if (feature instanceof JvmExecutable) {
            QualifiedName name = QualifiedName.create((String)feature.getSimpleName());
            if (call instanceof XBinaryOperation || call instanceof XUnaryOperation) {
                QualifiedName operator = this.operatorMapping.getOperator(name);
                if (operator == null) {
                    return IScope.NULLSCOPE;
                }
                return new SingletonScope(EObjectDescription.create((QualifiedName)operator, (EObject)feature), IScope.NULLSCOPE);
            }
            if (call instanceof XAssignment) {
                String propertyName = Strings.toFirstLower((String)feature.getSimpleName().substring(3));
                return new SingletonScope(EObjectDescription.create((String)propertyName, (EObject)feature), IScope.NULLSCOPE);
            }
            if (call.isExplicitOperationCallOrBuilderSyntax() || ((JvmExecutable)feature).getParameters().size() >= 1) {
                return new SingletonScope(EObjectDescription.create((QualifiedName)name, (EObject)feature), IScope.NULLSCOPE);
            }
            if (feature.getSimpleName().startsWith("get") || feature.getSimpleName().startsWith("is")) {
                ArrayList result = Lists.newArrayListWithCapacity((int)2);
                result.add(EObjectDescription.create((QualifiedName)name, (EObject)feature));
                if (feature.getSimpleName().startsWith("get")) {
                    String propertyName = Strings.toFirstLower((String)feature.getSimpleName().substring(3));
                    result.add(EObjectDescription.create((String)propertyName, (EObject)feature));
                } else {
                    String propertyName = Strings.toFirstLower((String)feature.getSimpleName().substring(2));
                    result.add(EObjectDescription.create((String)propertyName, (EObject)feature));
                }
                return new SimpleScope((Iterable)result);
            }
            return new SingletonScope(EObjectDescription.create((QualifiedName)name, (EObject)feature), IScope.NULLSCOPE);
        }
        if (feature instanceof JvmFormalParameter || feature instanceof JvmField || feature instanceof XVariableDeclaration) {
            return new SingletonScope(EObjectDescription.create((String)feature.getSimpleName(), (EObject)feature), IScope.NULLSCOPE);
        }
        if (feature instanceof XSwitchExpression) {
            return new SingletonScope(EObjectDescription.create((String)feature.getSimpleName(), (EObject)feature), IScope.NULLSCOPE);
        }
        return IScope.NULLSCOPE;
    }
}

