/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.tokens;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.linking.impl.LinkingHelper;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parsetree.reconstr.impl.TokenUtil;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic;
import org.eclipse.xtext.serializer.diagnostic.ITokenDiagnosticProvider;
import org.eclipse.xtext.serializer.tokens.ICrossReferenceSerializer;
import org.eclipse.xtext.serializer.tokens.SerializerScopeProviderBinding;

public class CrossReferenceSerializer
implements ICrossReferenceSerializer {
    @Inject
    protected ITokenDiagnosticProvider diagnostics;
    @Inject
    private LinkingHelper linkingHelper;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    @SerializerScopeProviderBinding
    private IScopeProvider scopeProvider;
    @Inject
    protected TokenUtil tokenUtil;
    @Inject
    private IValueConverterService valueConverter;

    public boolean isValid(EObject semanticObject, CrossReference crossref, EObject target, INode node, ISerializationDiagnostic.Acceptor errors) {
        if (target.eIsProxy() && node != null) {
            return true;
        }
        EReference ref = GrammarUtil.getReference(crossref, semanticObject.eClass());
        IScope scope = this.scopeProvider.getScope(semanticObject, ref);
        if (scope == null) {
            if (errors != null) {
                errors.accept(this.diagnostics.getNoScopeFoundDiagnostic(semanticObject, crossref, target));
            }
            return false;
        }
        return this.getCrossReferenceNameFromScope(semanticObject, crossref, target, scope, errors) != null;
    }

    public String serializeCrossRef(EObject semanticObject, CrossReference crossref, EObject target, INode node, ISerializationDiagnostic.Acceptor errors) {
        if (target.eIsProxy() && node != null) {
            return this.tokenUtil.serializeNode(node);
        }
        EReference ref = GrammarUtil.getReference(crossref, semanticObject.eClass());
        IScope scope = this.scopeProvider.getScope(semanticObject, ref);
        if (scope == null) {
            if (errors != null) {
                errors.accept(this.diagnostics.getNoScopeFoundDiagnostic(semanticObject, crossref, target));
            }
            return null;
        }
        if (node != null) {
            String text = this.linkingHelper.getCrossRefNodeAsString(node, true);
            QualifiedName qn = this.qualifiedNameConverter.toQualifiedName(text);
            URI targetURI = EcoreUtil.getURI((EObject)target);
            if (target.eResource() != null && target.eResource().getResourceSet() != null) {
                targetURI = target.eResource().getResourceSet().getURIConverter().normalize(targetURI);
            }
            for (IEObjectDescription desc : scope.getElements(qn)) {
                if (!desc.getEObjectURI().equals((Object)targetURI)) continue;
                return this.tokenUtil.serializeNode(node);
            }
        }
        return this.getCrossReferenceNameFromScope(semanticObject, crossref, target, scope, errors);
    }

    protected String getCrossReferenceNameFromScope(EObject semanticObject, CrossReference crossref, EObject target, IScope scope, ISerializationDiagnostic.Acceptor errors) {
        String ruleName = this.linkingHelper.getRuleNameFrom(crossref);
        boolean foundOne = false;
        List recordedErrros = null;
        for (IEObjectDescription desc : scope.getElements(target)) {
            foundOne = true;
            String unconverted = this.qualifiedNameConverter.toString(desc.getName());
            try {
                return this.valueConverter.toString(unconverted, ruleName);
            }
            catch (ValueConverterException e) {
                if (errors == null) continue;
                if (recordedErrros == null) {
                    recordedErrros = Lists.newArrayList();
                }
                recordedErrros.add(this.diagnostics.getValueConversionExceptionDiagnostic(semanticObject, crossref, unconverted, e));
            }
        }
        if (errors != null) {
            if (recordedErrros != null) {
                for (ISerializationDiagnostic diag : recordedErrros) {
                    errors.accept(diag);
                }
            }
            if (!foundOne) {
                errors.accept(this.diagnostics.getNoEObjectDescriptionFoundDiagnostic(semanticObject, crossref, target, scope));
            }
        }
        return null;
    }
}

