/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.builder.builderState.IBuilderState;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.resource.impl.AbstractResourceDescriptionChangeEventSource;
import org.eclipse.xtext.resource.impl.ChangedResourceDescriptionDelta;
import org.eclipse.xtext.resource.impl.ResourceDescriptionChangeEvent;
import org.eclipse.xtext.ui.editor.IDirtyStateManager;
import org.eclipse.xtext.ui.notification.IStateChangeEventBroker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirtyStateAwareResourceDescriptions
extends AbstractResourceDescriptionChangeEventSource
implements IResourceDescriptions {
    private final IDirtyStateManager dirtyStateManager;
    private final IBuilderState globalDescriptions;

    @Inject
    public DirtyStateAwareResourceDescriptions(IBuilderState globalDescriptions, IDirtyStateManager dirtyStateManager, IStateChangeEventBroker stateChangeEventBroker) {
        this.globalDescriptions = globalDescriptions;
        this.dirtyStateManager = dirtyStateManager;
        globalDescriptions.addListener(this.createGlobalStateListener());
        dirtyStateManager.addListener(this.createDirtyStateListener());
        this.addListener((IResourceDescription.Event.Listener)stateChangeEventBroker);
    }

    protected IResourceDescription.Event.Listener createDirtyStateListener() {
        return new DirtyStateListener();
    }

    protected IResourceDescription.Event.Listener createGlobalStateListener() {
        return new GlobalStateListener();
    }

    public void dirtyDescriptionsChanged(IResourceDescription.Event event) {
        ResourceDescriptionChangeEvent changeEvent = new ResourceDescriptionChangeEvent(Iterables.transform((Iterable)event.getDeltas(), (Function)new Function<IResourceDescription.Delta, IResourceDescription.Delta>(){

            public IResourceDescription.Delta apply(IResourceDescription.Delta from) {
                IResourceDescription.Delta result = from;
                if (from.getNew() == null) {
                    result = DirtyStateAwareResourceDescriptions.this.createDelta(from.getOld(), DirtyStateAwareResourceDescriptions.this.globalDescriptions.getResourceDescription(from.getUri()));
                } else if (from.getOld() == null) {
                    result = DirtyStateAwareResourceDescriptions.this.createDelta(DirtyStateAwareResourceDescriptions.this.globalDescriptions.getResourceDescription(from.getUri()), from.getNew());
                }
                return result;
            }
        }), (IResourceDescription.Event.Source)this);
        this.notifyListeners((IResourceDescription.Event)changeEvent);
    }

    protected IResourceDescription.Delta createDelta(IResourceDescription old, IResourceDescription _new) {
        return new ChangedResourceDescriptionDelta(old, _new);
    }

    public void globalDescriptionsChanged(IResourceDescription.Event event) {
        ResourceDescriptionChangeEvent changeEvent = new ResourceDescriptionChangeEvent(Iterables.filter((Iterable)event.getDeltas(), (Predicate)new Predicate<IResourceDescription.Delta>(){

            public boolean apply(IResourceDescription.Delta input) {
                URI uri = input.getUri();
                return !DirtyStateAwareResourceDescriptions.this.dirtyStateManager.hasContent(uri);
            }
        }), (IResourceDescription.Event.Source)this);
        this.notifyListeners((IResourceDescription.Event)changeEvent);
    }

    public Iterable<IResourceDescription> getAllResourceDescriptions() {
        return Iterables.transform((Iterable)this.globalDescriptions.getAllResourceDescriptions(), (Function)new Function<IResourceDescription, IResourceDescription>(){

            public IResourceDescription apply(IResourceDescription from) {
                IResourceDescription dirty = DirtyStateAwareResourceDescriptions.this.dirtyStateManager.getDirtyResourceDescription(from.getURI());
                if (dirty != null) {
                    return dirty;
                }
                return from;
            }
        });
    }

    public IResourceDescription getResourceDescription(URI uri) {
        IResourceDescription result = this.dirtyStateManager.getDirtyResourceDescription(uri);
        if (result == null) {
            result = this.globalDescriptions.getResourceDescription(uri);
        }
        return result;
    }

    public boolean isEmpty() {
        return this.globalDescriptions.isEmpty();
    }

    public Iterable<IEObjectDescription> getExportedObjects() {
        return Iterables.concat((Iterable)Iterables.transform(this.getAllResourceDescriptions(), (Function)new Function<ISelectable, Iterable<IEObjectDescription>>(){

            public Iterable<IEObjectDescription> apply(ISelectable from) {
                if (from != null) {
                    return from.getExportedObjects();
                }
                return Collections.emptyList();
            }
        }));
    }

    public Iterable<IEObjectDescription> getExportedObjects(EClass type, QualifiedName name, boolean ignoreCase) {
        Iterable dirtyDescriptions = this.dirtyStateManager.getExportedObjects(type, name, ignoreCase);
        Iterable persistentDescriptions = this.globalDescriptions.getExportedObjects(type, name, ignoreCase);
        return this.joinIterables(dirtyDescriptions, persistentDescriptions);
    }

    protected Iterable<IEObjectDescription> joinIterables(Iterable<IEObjectDescription> dirtyDescriptions, Iterable<IEObjectDescription> persistentDescriptions) {
        Iterable filteredPersistent = Iterables.filter(persistentDescriptions, (Predicate)new Predicate<IEObjectDescription>(){

            public boolean apply(IEObjectDescription input) {
                URI resourceURI = input.getEObjectURI().trimFragment();
                return !DirtyStateAwareResourceDescriptions.this.dirtyStateManager.hasContent(resourceURI);
            }
        });
        return Iterables.concat(dirtyDescriptions, (Iterable)filteredPersistent);
    }

    public Iterable<IEObjectDescription> getExportedObjectsByType(EClass type) {
        Iterable dirtyDescriptions = this.dirtyStateManager.getExportedObjectsByType(type);
        Iterable persistentDescriptions = this.globalDescriptions.getExportedObjectsByType(type);
        return this.joinIterables(dirtyDescriptions, persistentDescriptions);
    }

    public Iterable<IEObjectDescription> getExportedObjectsByObject(EObject object) {
        URI resourceURI = EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)object).trimFragment();
        if (this.dirtyStateManager.hasContent(resourceURI)) {
            return this.dirtyStateManager.getExportedObjectsByObject(object);
        }
        return this.globalDescriptions.getExportedObjectsByObject(object);
    }

    protected class DirtyStateListener
    implements IResourceDescription.Event.Listener {
        protected DirtyStateListener() {
        }

        public void descriptionsChanged(IResourceDescription.Event event) {
            DirtyStateAwareResourceDescriptions.this.dirtyDescriptionsChanged(event);
        }
    }

    protected class GlobalStateListener
    implements IResourceDescription.Event.Listener {
        protected GlobalStateListener() {
        }

        public void descriptionsChanged(IResourceDescription.Event event) {
            DirtyStateAwareResourceDescriptions.this.globalDescriptionsChanged(event);
        }
    }
}

