/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit4.ui.util;

import com.google.common.collect.Lists;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.xtext.junit4.ui.util.IResourcesSetupUtil;
import org.eclipse.xtext.junit4.ui.util.PluginUtil;

public class JavaProjectSetupUtil {
    private static final String JRE_CONTAINER_1_5 = "org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/J2SE-1.5";

    public static InputStream jarInputStream(TextFile ... files) {
        try {
            ByteArrayOutputStream out2 = new ByteArrayOutputStream();
            JarOutputStream jo = new JarOutputStream(new BufferedOutputStream(out2));
            TextFile[] textFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                TextFile textFile = textFileArray[n2];
                JarEntry je = new JarEntry(textFile.path);
                jo.putNextEntry(je);
                byte[] bytes = textFile.content.getBytes();
                jo.write(bytes, 0, bytes.length);
                ++n2;
            }
            jo.close();
            return new ByteArrayInputStream(out2.toByteArray());
        }
        catch (IOException e) {
            throw new WrappedException((Exception)e);
        }
    }

    public static IJavaProject createJavaProject(String projectName) throws CoreException {
        IProject project = JavaProjectSetupUtil.createSimpleProject(projectName);
        JavaCore.initializeAfterLoad((IProgressMonitor)IResourcesSetupUtil.monitor());
        IJavaProject javaProject = JavaProjectSetupUtil.makeJavaProject(project);
        return javaProject;
    }

    public static IJavaProject findJavaProject(String projectName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        if (project != null) {
            return JavaCore.create((IProject)project);
        }
        return null;
    }

    public static IProject createSimpleProject(String projectName) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        JavaProjectSetupUtil.deleteProject(project);
        project.create(null);
        project.open(null);
        return project;
    }

    public static IFolder createExternalFolder(String folderName) throws CoreException {
        Path externalFolderPath = new Path(folderName);
        IProject externalFoldersProject = JavaModelManager.getExternalManager().getExternalFoldersProject();
        if (!externalFoldersProject.isAccessible()) {
            if (!externalFoldersProject.exists()) {
                externalFoldersProject.create(IResourcesSetupUtil.monitor());
            }
            externalFoldersProject.open(IResourcesSetupUtil.monitor());
        }
        IFolder result = externalFoldersProject.getFolder((IPath)externalFolderPath);
        result.create(true, false, null);
        return result;
    }

    public static void deleteExternalFolder(IFolder folder) throws CoreException {
        JavaModelManager.getExternalManager().removeFolder(folder.getFullPath());
        folder.delete(true, null);
    }

    public static IFolder deleteSourceFolder(IJavaProject project, String folderPath) throws JavaModelException, CoreException {
        IFolder folder = project.getProject().getFolder(folderPath);
        JavaProjectSetupUtil.deleteClasspathEntry(project, folder.getFullPath());
        folder.delete(true, IResourcesSetupUtil.monitor());
        return folder;
    }

    public static void addProjectReference(IJavaProject from, IJavaProject to) throws CoreException {
        JavaProjectSetupUtil.addToClasspath(from, JavaCore.newProjectEntry((IPath)to.getPath()));
    }

    public static void removeProjectReference(IJavaProject from, IJavaProject to) throws CoreException {
        ArrayList classpath = Lists.newArrayList((Object[])from.getRawClasspath());
        Iterator iterator = classpath.iterator();
        while (iterator.hasNext()) {
            IClasspathEntry entry = (IClasspathEntry)iterator.next();
            if (entry.getEntryKind() != 2 || !entry.getPath().equals((Object)to.getPath())) continue;
            iterator.remove();
        }
        from.setRawClasspath(classpath.toArray(new IClasspathEntry[classpath.size()]), IResourcesSetupUtil.monitor());
    }

    public static void deleteJavaProject(IJavaProject javaProject) throws CoreException {
        IProject project = javaProject.getProject();
        JavaProjectSetupUtil.deleteProject(project);
    }

    public static void deleteProject(IProject project) throws CoreException {
        if (project.exists()) {
            project.delete(true, true, null);
        }
    }

    public static IJavaProject makeJavaProject(IProject project) throws CoreException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        javaProject.save(null, true);
        IResourcesSetupUtil.addNature(project, "org.eclipse.jdt.core.javanature");
        JavaProjectSetupUtil.addSourceFolder(javaProject, "src");
        JavaProjectSetupUtil.addJre15ClasspathEntry(javaProject);
        return javaProject;
    }

    public static IFolder addSourceFolder(IJavaProject javaProject, String folderName) throws CoreException, JavaModelException {
        IProject project = javaProject.getProject();
        IPath projectPath = project.getFullPath();
        JavaProjectSetupUtil.deleteClasspathEntry(javaProject, projectPath);
        IFolder srcFolder = JavaProjectSetupUtil.createSubFolder(project, folderName);
        IClasspathEntry srcFolderClasspathEntry = JavaCore.newSourceEntry((IPath)srcFolder.getFullPath());
        JavaProjectSetupUtil.addToClasspath(javaProject, srcFolderClasspathEntry);
        return srcFolder;
    }

    public static void deleteClasspathEntry(IJavaProject javaProject, IPath path) throws JavaModelException {
        IClasspathEntry[] classpath = javaProject.getRawClasspath();
        int i = 0;
        while (i < classpath.length) {
            IPath entryPath = classpath[i].getPath();
            if (path.equals((Object)entryPath)) {
                IClasspathEntry[] newClasspath = new IClasspathEntry[classpath.length - 1];
                System.arraycopy(classpath, 0, newClasspath, 0, i);
                System.arraycopy(classpath, i + 1, newClasspath, i, classpath.length - i - 1);
                javaProject.setRawClasspath(newClasspath, null);
            }
            ++i;
        }
    }

    public static void addToClasspath(IJavaProject javaProject, IClasspathEntry newClassPathEntry) throws JavaModelException {
        IClasspathEntry[] classPath;
        IClasspathEntry[] iClasspathEntryArray = classPath = javaProject.getRawClasspath();
        int n = classPath.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry classPathEntry = iClasspathEntryArray[n2];
            if (classPathEntry.equals(newClassPathEntry)) {
                return;
            }
            ++n2;
        }
        IClasspathEntry[] newClassPath = new IClasspathEntry[classPath.length + 1];
        System.arraycopy(classPath, 0, newClassPath, 1, classPath.length);
        newClassPath[0] = newClassPathEntry;
        javaProject.setRawClasspath(newClassPath, null);
        IResourcesSetupUtil.waitForAutoBuild();
    }

    public static IFolder createSubFolder(IProject project, String folderName) throws CoreException {
        IFolder folder = project.getFolder(folderName);
        if (folder.exists()) {
            folder.delete(true, null);
        }
        folder.create(true, true, null);
        return folder;
    }

    public static void addJre15ClasspathEntry(IJavaProject javaProject) throws JavaModelException {
        IClasspathEntry existingJreContainerClasspathEntry = JavaProjectSetupUtil.getJreContainerClasspathEntry(javaProject);
        if (existingJreContainerClasspathEntry == null) {
            JavaProjectSetupUtil.addToClasspath(javaProject, JavaCore.newContainerEntry((IPath)new Path(JRE_CONTAINER_1_5)));
        }
    }

    public static void makeJava5Compliant(IJavaProject javaProject) {
        Map options = javaProject.getOptions(false);
        options.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
        options.put("org.eclipse.jdt.core.compiler.source", "1.5");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        options.put("org.eclipse.jdt.core.compiler.problem.assertIdentifier", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.enumIdentifier", "error");
        options.put("org.eclipse.jdt.core.compiler.codegen.inlineJsrBytecode", "enabled");
        options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
        options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
        options.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "preserve");
        javaProject.setOptions(options);
    }

    public static IClasspathEntry getJreContainerClasspathEntry(IJavaProject javaProject) throws JavaModelException {
        IClasspathEntry[] rawClasspath;
        IClasspathEntry[] iClasspathEntryArray = rawClasspath = javaProject.getRawClasspath();
        int n = rawClasspath.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path;
            String pathAsString;
            IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
            int entryKind = classpathEntry.getEntryKind();
            if (entryKind == 5 && (pathAsString = (path = classpathEntry.getPath()).toString()).startsWith(JRE_CONTAINER_1_5)) {
                return classpathEntry;
            }
            ++n2;
        }
        return null;
    }

    public static IClasspathEntry addPlatformJarToClasspath(Plugin srcPlugin, String jarFileName, IJavaProject destProject) throws JavaModelException, IOException {
        IPath jarFilePath = PluginUtil.findPathInPlugin(srcPlugin, jarFileName);
        IClasspathEntry newLibraryEntry = JavaCore.newLibraryEntry((IPath)jarFilePath, null, null);
        JavaProjectSetupUtil.addToClasspath(destProject, newLibraryEntry);
        return newLibraryEntry;
    }

    public static IClasspathEntry addJarToClasspath(IJavaProject javaProject, IFile jarFile) throws JavaModelException {
        IClasspathEntry newLibraryEntry = JavaCore.newLibraryEntry((IPath)jarFile.getFullPath(), null, null);
        JavaProjectSetupUtil.addToClasspath(javaProject, newLibraryEntry);
        return newLibraryEntry;
    }

    public static IClasspathEntry addExternalFolderToClasspath(IJavaProject javaProject, IFolder folder) throws JavaModelException {
        IClasspathEntry newLibraryEntry = JavaCore.newLibraryEntry((IPath)folder.getLocation(), null, null);
        JavaProjectSetupUtil.addToClasspath(javaProject, newLibraryEntry);
        return newLibraryEntry;
    }

    public static File createExternalJar(InputStream data, String nameWithoutJarSuffix) throws IOException, FileNotFoundException {
        File tempFile = File.createTempFile(nameWithoutJarSuffix, ".jar");
        tempFile.createNewFile();
        FileOutputStream stream = new FileOutputStream(tempFile);
        int i = -1;
        while ((i = data.read()) != -1) {
            stream.write(i);
        }
        stream.close();
        data.close();
        return tempFile;
    }

    public static class TextFile {
        public String path;
        public String content;

        public TextFile(String path, String content) {
            this.path = path;
            this.content = content;
        }
    }
}

