/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.autoedit;

import com.google.inject.Inject;
import com.google.inject.MembersInjector;
import org.apache.log4j.Logger;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.xtext.formatting.IIndentationInformation;
import org.eclipse.xtext.ui.editor.autoedit.AbstractTerminalsEditStrategy;
import org.eclipse.xtext.ui.editor.autoedit.CommandInfo;
import org.eclipse.xtext.util.Strings;

public class MultiLineTerminalsEditStrategy
extends AbstractTerminalsEditStrategy {
    private static final Logger log = Logger.getLogger(MultiLineTerminalsEditStrategy.class);
    private final boolean nested;
    private String indentationString;

    public MultiLineTerminalsEditStrategy(String leftTerminal, String indentationString, String rightTerminal) {
        this(leftTerminal, indentationString, rightTerminal, true);
    }

    public MultiLineTerminalsEditStrategy(String leftTerminal, String indentationString, String rightTerminal, boolean nested) {
        super(leftTerminal, rightTerminal);
        this.nested = nested;
        this.indentationString = indentationString;
    }

    protected void internalCustomizeDocumentCommand(IDocument document, DocumentCommand command) throws BadLocationException {
        if (this.isLineDelimiter(document, command)) {
            CommandInfo newC;
            IRegion startTerminal = this.findStartTerminal(document, command.offset);
            if (startTerminal == null) {
                return;
            }
            IRegion stopTerminal = this.findStopTerminal(document, command.offset);
            if (stopTerminal != null && this.nested) {
                IRegion previousStart = startTerminal;
                IRegion previousStop = stopTerminal;
                while (stopTerminal != null && previousStart != null && previousStop != null) {
                    if ((previousStart = this.findStartTerminal(document, previousStart.getOffset())) == null || (previousStop = this.findStopTerminal(document, previousStop.getOffset() + 1)) != null) continue;
                    stopTerminal = null;
                }
            }
            if (this.util.isSameLine(document, startTerminal.getOffset(), command.offset)) {
                if (stopTerminal != null && stopTerminal.getLength() < this.getRightTerminal().length()) {
                    stopTerminal = null;
                }
                if ((newC = this.handleCursorInFirstLine(document, command, startTerminal, stopTerminal)) != null) {
                    newC.modifyCommand(command);
                }
                return;
            }
            if (stopTerminal == null) {
                newC = this.handleNoStopTerminal(document, command, startTerminal, stopTerminal);
                if (newC != null) {
                    newC.modifyCommand(command);
                }
                return;
            }
            if (!this.util.isSameLine(document, stopTerminal.getOffset(), command.offset)) {
                newC = this.handleCursorBetweenStartAndStopLine(document, command, startTerminal, stopTerminal);
                if (newC != null) {
                    newC.modifyCommand(command);
                }
                return;
            }
            newC = this.handleCursorInStopLine(document, command, startTerminal, stopTerminal);
            if (newC != null) {
                newC.modifyCommand(command);
            }
            return;
        }
    }

    private boolean isLineDelimiter(IDocument document, DocumentCommand command) {
        if (command.length != 0) {
            return false;
        }
        String originalText = command.text;
        String[] lineDelimiters = document.getLegalLineDelimiters();
        int delimiterIndex = TextUtilities.startsWith((String[])lineDelimiters, (String)originalText);
        return delimiterIndex != -1 && originalText.trim().length() == 0;
    }

    protected CommandInfo handleCursorInFirstLine(IDocument document, DocumentCommand command, IRegion startTerminal, IRegion stopTerminal) throws BadLocationException {
        CommandInfo newC = new CommandInfo();
        newC.isChange = true;
        newC.offset = command.offset;
        newC.text = String.valueOf(newC.text) + command.text + this.indentationString;
        newC.cursorOffset = command.offset + newC.text.length();
        if (stopTerminal == null && this.atEndOfLineInput(document, command.offset)) {
            newC.text = String.valueOf(newC.text) + command.text + this.getRightTerminal();
        }
        if (stopTerminal != null && stopTerminal.getOffset() >= command.offset && this.util.isSameLine(document, stopTerminal.getOffset(), command.offset)) {
            String string = document.get(command.offset, stopTerminal.getOffset() - command.offset);
            if (string.trim().length() > 0) {
                newC.text = String.valueOf(newC.text) + string.trim();
            }
            newC.text = String.valueOf(newC.text) + command.text;
            newC.length += string.length();
        }
        return newC;
    }

    protected CommandInfo handleNoStopTerminal(IDocument document, DocumentCommand command, IRegion startTerminal, IRegion stopTerminal) throws BadLocationException {
        if (this.atEndOfLineInput(document, command.offset)) {
            CommandInfo newC = new CommandInfo();
            newC.isChange = true;
            String textPartBeforeCursor = String.valueOf(command.text) + Strings.removeLeadingWhitespace((String)this.indentationString);
            newC.cursorOffset = command.offset + textPartBeforeCursor.length();
            newC.text = String.valueOf(textPartBeforeCursor) + command.text + Strings.removeLeadingWhitespace((String)this.getRightTerminal());
            return newC;
        }
        return null;
    }

    protected CommandInfo handleCursorBetweenStartAndStopLine(IDocument document, DocumentCommand command, IRegion startTerminal, IRegion stopTerminal) throws BadLocationException {
        if (this.indentationString.trim().length() > 0 && !this.atBeginningOfLineInput(document, command.offset)) {
            CommandInfo newC = new CommandInfo();
            newC.isChange = true;
            newC.text = String.valueOf(newC.text) + command.text + Strings.removeLeadingWhitespace((String)this.indentationString);
            return newC;
        }
        return null;
    }

    protected CommandInfo handleCursorInStopLine(IDocument document, DocumentCommand command, IRegion startTerminal, IRegion stopTerminal) throws BadLocationException {
        return this.handleCursorBetweenStartAndStopLine(document, command, startTerminal, stopTerminal);
    }

    private boolean atBeginningOfLineInput(IDocument document, int offset) throws BadLocationException {
        IRegion line = document.getLineInformation(document.getLineOfOffset(offset));
        return document.get(line.getOffset(), offset - line.getOffset()).trim().length() == 0;
    }

    protected boolean atEndOfLineInput(IDocument document, int offset) throws BadLocationException {
        IRegion line = document.getLineInformation(document.getLineOfOffset(offset));
        return document.get(offset, line.getOffset() + line.getLength() - offset).trim().length() == 0;
    }

    public static class Factory {
        @Inject
        private MembersInjector<MultiLineTerminalsEditStrategy> injector;
        @Inject
        private IIndentationInformation indentationInformation;

        public MultiLineTerminalsEditStrategy newInstance(String leftTerminal, String indentationString, String rightTerminal) {
            return this.newInstance(leftTerminal, indentationString, rightTerminal, true);
        }

        public MultiLineTerminalsEditStrategy newInstance(String leftTerminal, String indentationString, String rightTerminal, boolean nested) {
            indentationString = indentationString == null ? this.indentationInformation.getIndentString() : indentationString;
            MultiLineTerminalsEditStrategy strategy = new MultiLineTerminalsEditStrategy(leftTerminal, indentationString, rightTerminal, nested);
            this.injector.injectMembers((Object)strategy);
            return strategy;
        }
    }
}

