/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.findrefs;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.impl.DefaultReferenceDescription;
import org.eclipse.xtext.ui.editor.findrefs.IReferenceFinder;
import org.eclipse.xtext.ui.editor.findrefs.IReferenceFinderExtension1;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultReferenceFinder
implements IReferenceFinder,
IReferenceFinderExtension1 {
    private IResourceDescriptions indexData;
    private IResourceServiceProvider.Registry serviceProviderRegistry;

    @Inject
    public DefaultReferenceFinder(IResourceDescriptions indexData, IResourceServiceProvider.Registry serviceProviderRegistry) {
        this.indexData = indexData;
        this.serviceProviderRegistry = serviceProviderRegistry;
    }

    protected IResourceDescriptions getIndexData() {
        return this.indexData;
    }

    @Override
    public void findReferences(Iterable<URI> targetURIs, final Iterable<URI> sourceResourceURIs, IReferenceFinder.ILocalResourceAccess localResourceAccess, IAcceptor<IReferenceDescription> referenceAcceptor, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        if (!Iterables.isEmpty(targetURIs) && !Iterables.isEmpty(sourceResourceURIs)) {
            if (localResourceAccess != null) {
                Iterable localTargetURIs = Iterables.filter(targetURIs, (Predicate)new Predicate<URI>(){

                    public boolean apply(URI input) {
                        return Iterables.contains((Iterable)sourceResourceURIs, (Object)input.trimFragment());
                    }
                });
                this.findLocalReferences(localTargetURIs, localResourceAccess, referenceAcceptor, (IProgressMonitor)subMonitor.newChild(1));
            }
            LinkedHashSet targetURIsAsSet = Sets.newLinkedHashSet(targetURIs);
            subMonitor.setWorkRemaining(targetURIsAsSet.size());
            for (URI sourceResourceURI : sourceResourceURIs) {
                IResourceDescription resourceDescription = this.indexData.getResourceDescription(sourceResourceURI);
                if (resourceDescription == null) continue;
                this.findReferences(targetURIsAsSet, resourceDescription, referenceAcceptor, (IProgressMonitor)subMonitor.newChild(1), localResourceAccess);
            }
        }
    }

    @Override
    public void findAllReferences(Iterable<URI> targetURIs, IReferenceFinder.ILocalResourceAccess localResourceAccess, IAcceptor<IReferenceDescription> referenceAcceptor, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        if (!Iterables.isEmpty(targetURIs)) {
            if (localResourceAccess != null) {
                this.findLocalReferences(targetURIs, localResourceAccess, referenceAcceptor, (IProgressMonitor)subMonitor.newChild(1));
            }
            LinkedHashSet targetURIsAsSet = Sets.newLinkedHashSet(targetURIs);
            this.findAllIndexedReferences(referenceAcceptor, subMonitor, targetURIsAsSet, localResourceAccess);
        }
    }

    @Deprecated
    protected void findAllIndexedReferences(IAcceptor<IReferenceDescription> referenceAcceptor, SubMonitor subMonitor, Set<URI> targetURIsAsSet) {
        this.findAllIndexedReferences(referenceAcceptor, subMonitor, targetURIsAsSet, null);
    }

    protected void findAllIndexedReferences(IAcceptor<IReferenceDescription> referenceAcceptor, SubMonitor subMonitor, Set<URI> targetURIsAsSet, IReferenceFinder.ILocalResourceAccess localResourceAccess) {
        subMonitor.setWorkRemaining(Iterables.size((Iterable)this.indexData.getAllResourceDescriptions()));
        for (IResourceDescription resourceDescription : this.indexData.getAllResourceDescriptions()) {
            IResourceServiceProvider serviceProvider = this.serviceProviderRegistry.getResourceServiceProvider(resourceDescription.getURI());
            if (serviceProvider == null) continue;
            IReferenceFinder referenceFinder = (IReferenceFinder)serviceProvider.get(IReferenceFinder.class);
            if (referenceFinder instanceof IReferenceFinderExtension1) {
                IReferenceFinderExtension1 extension1 = (IReferenceFinderExtension1)((Object)referenceFinder);
                extension1.findReferences(targetURIsAsSet, resourceDescription, referenceAcceptor, (IProgressMonitor)subMonitor.newChild(1), localResourceAccess);
                continue;
            }
            this.findReferences(targetURIsAsSet, resourceDescription, referenceAcceptor, (IProgressMonitor)subMonitor.newChild(1), localResourceAccess);
        }
    }

    protected void findLocalReferences(Iterable<URI> localTargets, IReferenceFinder.ILocalResourceAccess localResourceAccess, IAcceptor<IReferenceDescription> acceptor, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        LinkedHashMultimap resource2target = LinkedHashMultimap.create();
        for (URI targetURI : localTargets) {
            resource2target.put((Object)targetURI.trimFragment(), (Object)targetURI);
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)resource2target.keySet().size());
        for (final URI resourceURI : resource2target.keySet()) {
            if (subMonitor.isCanceled()) {
                return;
            }
            localResourceAccess.readOnly(resourceURI, new IUnitOfWork.Void<ResourceSet>((Multimap)resource2target, acceptor){
                private final /* synthetic */ Multimap val$resource2target;
                private final /* synthetic */ IAcceptor val$acceptor;
                {
                    this.val$resource2target = multimap;
                    this.val$acceptor = iAcceptor;
                }

                public void process(ResourceSet resourceSet) throws Exception {
                    Resource resource = resourceSet.getResource(resourceURI, true);
                    DefaultReferenceFinder.this.findLocalReferencesInResource(this.val$resource2target.get((Object)resourceURI), resource, (IAcceptor<IReferenceDescription>)this.val$acceptor);
                }
            });
            subMonitor.worked(1);
        }
    }

    protected void findLocalReferencesInResource(Iterable<URI> targetURIs, Resource resource, IAcceptor<IReferenceDescription> acceptor) {
        ImmutableSet targetURISet = ImmutableSet.copyOf(targetURIs);
        Map<EObject, URI> exportedElementsMap = this.createExportedElementsMap(resource);
        for (EObject content : resource.getContents()) {
            this.findLocalReferencesFromElement((Set<URI>)targetURISet, content, resource, acceptor, null, exportedElementsMap);
        }
    }

    protected void findLocalReferencesFromElement(Set<URI> targetURISet, EObject sourceCandidate, Resource localResource, IAcceptor<IReferenceDescription> acceptor, URI currentExportedContainerURI, Map<EObject, URI> exportedElementsMap) {
        URI sourceURI = null;
        if (exportedElementsMap.containsKey(sourceCandidate)) {
            sourceURI = currentExportedContainerURI = exportedElementsMap.get(sourceCandidate);
        }
        for (EReference ref : sourceCandidate.eClass().getEAllReferences()) {
            if (!sourceCandidate.eIsSet((EStructuralFeature)ref)) continue;
            if (ref.isContainment()) {
                Object content = sourceCandidate.eGet((EStructuralFeature)ref, false);
                if (ref.isMany()) {
                    InternalEList contentList = (InternalEList)content;
                    int i = 0;
                    while (i < contentList.size()) {
                        EObject childElement = (EObject)contentList.basicGet(i);
                        if (!childElement.eIsProxy()) {
                            this.findLocalReferencesFromElement(targetURISet, childElement, localResource, acceptor, currentExportedContainerURI, exportedElementsMap);
                        }
                        ++i;
                    }
                    continue;
                }
                EObject childElement = (EObject)content;
                if (childElement.eIsProxy()) continue;
                this.findLocalReferencesFromElement(targetURISet, childElement, localResource, acceptor, currentExportedContainerURI, exportedElementsMap);
                continue;
            }
            if (ref.isContainer()) continue;
            Object value = sourceCandidate.eGet((EStructuralFeature)ref, false);
            if (ref.isMany()) {
                InternalEList values = (InternalEList)value;
                int i = 0;
                while (i < values.size()) {
                    EObject refElement = this.resolveInternalProxy((EObject)values.basicGet(i), localResource);
                    URI refURI = EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)refElement);
                    if (targetURISet.contains(refURI)) {
                        sourceURI = sourceURI == null ? EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)sourceCandidate) : sourceURI;
                        acceptor.accept((Object)new DefaultReferenceDescription(sourceURI, refURI, ref, i, currentExportedContainerURI));
                    }
                    ++i;
                }
                continue;
            }
            EObject refElement = this.resolveInternalProxy((EObject)value, localResource);
            URI refURI = EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)refElement);
            if (!targetURISet.contains(refURI)) continue;
            sourceURI = sourceURI == null ? EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)sourceCandidate) : sourceURI;
            acceptor.accept((Object)new DefaultReferenceDescription(sourceURI, refURI, ref, -1, currentExportedContainerURI));
        }
    }

    protected EObject resolveInternalProxy(EObject elementOrProxy, Resource resource) {
        if (elementOrProxy.eIsProxy() && ((InternalEObject)elementOrProxy).eProxyURI().trimFragment().equals(resource.getURI())) {
            return EcoreUtil.resolve((EObject)elementOrProxy, (Resource)resource);
        }
        return elementOrProxy;
    }

    protected Map<EObject, URI> createExportedElementsMap(Resource resource) {
        URI uri = EcoreUtil2.getPlatformResourceOrNormalizedURI((Resource)resource);
        IResourceServiceProvider resourceServiceProvider = this.serviceProviderRegistry.getResourceServiceProvider(uri);
        if (resourceServiceProvider == null) {
            return Collections.emptyMap();
        }
        IResourceDescription.Manager resourceDescriptionManager = resourceServiceProvider.getResourceDescriptionManager();
        if (resourceDescriptionManager == null) {
            return Collections.emptyMap();
        }
        IResourceDescription resourceDescription = resourceDescriptionManager.getResourceDescription(resource);
        IdentityHashMap exportedElementMap = Maps.newIdentityHashMap();
        if (resourceDescription != null) {
            for (IEObjectDescription exportedEObjectDescription : resourceDescription.getExportedObjects()) {
                EObject eObject = resource.getEObject(exportedEObjectDescription.getEObjectURI().fragment());
                if (eObject == null) continue;
                exportedElementMap.put(eObject, exportedEObjectDescription.getEObjectURI());
            }
        }
        return exportedElementMap;
    }

    @Deprecated
    protected URI findClosestExportedContainerURI(EObject element, Map<EObject, URI> exportedElementsMap) {
        EObject current = element;
        while (current != null) {
            URI uri = exportedElementsMap.get(current);
            if (uri != null) {
                return uri;
            }
            current = current.eContainer();
        }
        return null;
    }

    @Deprecated
    protected void findIndexedReferences(Set<URI> targetURIs, IResourceDescription resourceDescription, IAcceptor<IReferenceDescription> acceptor, IProgressMonitor monitor) {
        this.findReferences(targetURIs, resourceDescription, acceptor, monitor, null);
    }

    @Override
    public void findReferences(Set<URI> targetURIs, IResourceDescription resourceDescription, IAcceptor<IReferenceDescription> acceptor, IProgressMonitor monitor, IReferenceFinder.ILocalResourceAccess localResourceAccess) {
        for (IReferenceDescription referenceDescription : resourceDescription.getReferenceDescriptions()) {
            if (!targetURIs.contains(referenceDescription.getTargetEObjectUri())) continue;
            acceptor.accept((Object)referenceDescription);
        }
    }
}

