/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.search;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.xtext.resource.IEObjectDescription;

public interface IXtextSearchFilter {
    public boolean reject(IEObjectDescription var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Registry {
        private static final Logger LOG = Logger.getLogger(Registry.class);
        public static final String EXTENSION_POINT_ID = "org.eclipse.xtext.ui.searchFilter";
        public static final String FILTER = "filter";
        public static final String NAMESPACE_DELIMITER = "namespace_delimiter";
        public static final String ATTRIBUTE = "class";
        public static final String VALUE = "value";
        public static final String DEFAULT_NAMESPACE_DELIMITER = ".";

        public static Collection<IXtextSearchFilter> allFilters() {
            IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
            ArrayList filters = Lists.newArrayList();
            IConfigurationElement[] iConfigurationElementArray = configurationElements;
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                try {
                    if (FILTER.equals(configurationElement.getName())) {
                        IXtextSearchFilter filter = (IXtextSearchFilter)configurationElement.createExecutableExtension(ATTRIBUTE);
                        filters.add(filter);
                    }
                }
                catch (CoreException e) {
                    LOG.error((Object)"Error instantiating IXtextSerachFilter from registry", (Throwable)e);
                }
                ++n2;
            }
            return filters;
        }

        public static Collection<String> allNamespaceDelimiters() {
            IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
            HashSet delimiters = Sets.newHashSet();
            delimiters.add(DEFAULT_NAMESPACE_DELIMITER);
            IConfigurationElement[] iConfigurationElementArray = configurationElements;
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                if (NAMESPACE_DELIMITER.equals(configurationElement.getName())) {
                    String delimiter = configurationElement.getAttribute(VALUE);
                    if (delimiter.contains("*") || delimiter.contains("?")) {
                        LOG.error((Object)("Invalid namespace delimiter in " + configurationElement.getContributor().getName() + ": '*' and '?' not allowed."));
                    }
                    delimiters.add(delimiter);
                }
                ++n2;
            }
            return delimiters;
        }
    }
}

