/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTraversalData;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.OwnedConverter;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.DeclaratorTypeArgumentCollector;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;

@NonNullByDefault
public class ConstraintAwareTypeArgumentCollector
extends DeclaratorTypeArgumentCollector {
    private ITypeReferenceOwner owner;

    public ConstraintAwareTypeArgumentCollector(ITypeReferenceOwner owner) {
        this.owner = owner;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Boolean doVisitParameterizedTypeReference(ParameterizedTypeReference reference, LightweightTraversalData data) {
        JvmType type = reference.getType();
        if (type.eIsProxy() || !data.getVisited().add(type)) return Boolean.FALSE;
        if (!(type instanceof JvmTypeParameter)) return this.doVisitParameterizedTypeReference(reference, type, data);
        if (data.getTypeParameterMapping().containsKey(type)) return Boolean.FALSE;
        EList constraints = ((JvmTypeParameter)type).getConstraints();
        ArrayList upperBounds = Lists.newArrayList();
        OwnedConverter converter = new OwnedConverter(this.owner);
        for (JvmTypeConstraint constraint : constraints) {
            if (!(constraint instanceof JvmUpperBound) || constraint.getTypeReference() == null) continue;
            LightweightTypeReference upperBound = converter.toLightweightReference(constraint.getTypeReference());
            upperBound.accept(this, data);
            upperBounds.add(upperBound);
        }
        if (upperBounds.size() > 1) {
            CompoundTypeReference result = new CompoundTypeReference(this.owner, false);
            for (LightweightTypeReference upperBound : upperBounds) {
                result.addComponent(upperBound);
            }
            data.getTypeParameterMapping().put((JvmTypeParameter)type, new LightweightMergedBoundTypeArgument(result, VarianceInfo.INVARIANT));
            return Boolean.FALSE;
        } else {
            if (upperBounds.size() != 1) return Boolean.FALSE;
            data.getTypeParameterMapping().put((JvmTypeParameter)type, new LightweightMergedBoundTypeArgument((LightweightTypeReference)upperBounds.get(0), VarianceInfo.INVARIANT));
        }
        return Boolean.FALSE;
    }
}

