/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace;

import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.trace.ITraceURIConverter;
import org.eclipse.xtext.resource.XtextResource;

public class DefaultTraceURIConverter
implements ITraceURIConverter {
    public URI getURIForTrace(XtextResource context) {
        URI uri = context.getURI();
        return this.getURIForTrace(uri);
    }

    public URI getURIForTrace(URI uri) {
        if (uri.isPlatform()) {
            List segments = uri.segmentsList().subList(2, uri.segmentCount());
            return URI.createHierarchicalURI((String[])segments.toArray(new String[segments.size()]), null, null);
        }
        return uri.trimFragment().trimQuery();
    }

    protected boolean isPrefix(URI prefix, URI uri) {
        if (prefix.scheme() == null || !prefix.scheme().equals(uri.scheme())) {
            return false;
        }
        String[] prefixSeg = prefix.segments();
        String[] uriSeg = uri.segments();
        if (prefixSeg.length == 0 || uriSeg.length == 0) {
            return false;
        }
        if (!"".equals(prefixSeg[prefixSeg.length - 1])) {
            return false;
        }
        if (uriSeg.length < prefixSeg.length - 1) {
            return false;
        }
        int i = 0;
        while (i < prefixSeg.length - 1) {
            if (!uriSeg[i].equals(prefixSeg[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

