/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.trace;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.xtext.builder.trace.AbstractTrace;
import org.eclipse.xtext.builder.trace.IStorageAwareTraceContribution;
import org.eclipse.xtext.ui.shared.contribution.ISharedStateContributionRegistry;
import org.eclipse.xtext.util.Pair;

@NonNullByDefault
public class StorageAwareTrace
extends AbstractTrace {
    private IStorage localStorage;
    private String projectName;
    private ImmutableList<? extends IStorageAwareTraceContribution> contributions = ImmutableList.of();

    @Inject
    private void initializeContributions(ISharedStateContributionRegistry registry) {
        this.contributions = registry.getContributedInstances(IStorageAwareTraceContribution.class);
    }

    public IStorage getLocalStorage() {
        return this.localStorage;
    }

    public URI getLocalURI() {
        IStorage localStorage = this.getLocalStorage();
        return this.getURIForStorage(localStorage);
    }

    public IProject getLocalProject() {
        return this.findProject(this.projectName);
    }

    protected URI resolvePath(URI path) {
        IProject project;
        if (!path.isRelative()) {
            return path;
        }
        int i = 0;
        int size = this.contributions.size();
        while (i < size) {
            URI result = ((IStorageAwareTraceContribution)this.contributions.get(i)).tryResolvePath(this.localStorage, path);
            if (result != null) {
                return result;
            }
            ++i;
        }
        if (this.localStorage instanceof IFile && (project = ((IFile)this.localStorage).getProject()) != null) {
            return this.resolvePath(project, path);
        }
        return path;
    }

    protected URI resolvePath(IProject project, URI path) {
        IResource candidate = project.findMember(path.toString());
        if (candidate != null && candidate.exists()) {
            return URI.createPlatformResourceURI((String)(project.getFullPath() + "/" + path), (boolean)true);
        }
        return path;
    }

    protected void setLocalStorage(IStorage derivedResource) {
        this.localStorage = derivedResource;
        if (derivedResource instanceof IResource) {
            this.projectName = ((IResource)derivedResource).getProject().getName();
        }
    }

    protected IStorage findStorage(URI uri, IProject project) {
        Iterable allStorages = this.getStorage2uriMapper().getStorages(this.resolvePath(uri));
        for (Pair storage : allStorages) {
            if (!project.equals(storage.getSecond())) continue;
            return (IStorage)storage.getFirst();
        }
        throw new IllegalStateException("No storage found for given path: " + uri);
    }

    protected InputStream getContents(URI uri, IProject project) throws CoreException {
        return this.findStorage(uri, project).getContents();
    }
}

